/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.connector.jmx;

import com.facebook.presto.connector.jmx.JmxMetadata;
import com.facebook.presto.connector.jmx.JmxPeriodicSampler;
import com.facebook.presto.connector.jmx.JmxRecordSetProvider;
import com.facebook.presto.connector.jmx.JmxSplitManager;
import com.facebook.presto.connector.jmx.JmxTransactionHandle;
import com.facebook.presto.spi.connector.Connector;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.transaction.IsolationLevel;
import io.airlift.log.Logger;
import java.util.Objects;
import javax.inject.Inject;

public class JmxConnector
implements Connector {
    private static final Logger log = Logger.get(JmxConnector.class);
    private final JmxMetadata jmxMetadata;
    private final JmxPeriodicSampler jmxPeriodicSampler;
    private final JmxSplitManager jmxSplitManager;
    private final JmxRecordSetProvider jmxRecordSetProvider;

    @Inject
    public JmxConnector(JmxMetadata jmxMetadata, JmxSplitManager jmxSplitManager, JmxRecordSetProvider jmxRecordSetProvider, JmxPeriodicSampler jmxPeriodicSampler) {
        this.jmxMetadata = Objects.requireNonNull(jmxMetadata, "jmxMetadata is null");
        this.jmxSplitManager = Objects.requireNonNull(jmxSplitManager, "jmxSplitManager is null");
        this.jmxRecordSetProvider = Objects.requireNonNull(jmxRecordSetProvider, "jmxRecordSetProvider is null");
        this.jmxPeriodicSampler = Objects.requireNonNull(jmxPeriodicSampler, "jmxHistoryDumper is null");
    }

    public JmxMetadata getMetadata(ConnectorTransactionHandle transactionHandle) {
        return this.jmxMetadata;
    }

    public JmxSplitManager getSplitManager() {
        return this.jmxSplitManager;
    }

    public JmxRecordSetProvider getRecordSetProvider() {
        return this.jmxRecordSetProvider;
    }

    public ConnectorTransactionHandle beginTransaction(IsolationLevel isolationLevel, boolean readOnly) {
        IsolationLevel.checkConnectorSupports((IsolationLevel)IsolationLevel.READ_COMMITTED, (IsolationLevel)isolationLevel);
        return JmxTransactionHandle.INSTANCE;
    }

    public void shutdown() {
        try {
            this.jmxPeriodicSampler.shutdown();
        }
        catch (Exception e) {
            log.error((Throwable)e, "Error shutting down connector");
        }
    }
}

