/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.connector.jmx;

import com.facebook.presto.connector.jmx.JmxConnector;
import com.facebook.presto.connector.jmx.JmxConnectorConfig;
import com.facebook.presto.connector.jmx.JmxHandleResolver;
import com.facebook.presto.connector.jmx.JmxHistoricalData;
import com.facebook.presto.connector.jmx.JmxMetadata;
import com.facebook.presto.connector.jmx.JmxPeriodicSampler;
import com.facebook.presto.connector.jmx.JmxRecordSetProvider;
import com.facebook.presto.connector.jmx.JmxSplitManager;
import com.facebook.presto.connector.jmx.util.RebindSafeMBeanServer;
import com.facebook.presto.spi.ConnectorHandleResolver;
import com.facebook.presto.spi.NodeManager;
import com.facebook.presto.spi.connector.Connector;
import com.facebook.presto.spi.connector.ConnectorContext;
import com.facebook.presto.spi.connector.ConnectorFactory;
import com.google.common.base.Throwables;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Scopes;
import io.airlift.bootstrap.Bootstrap;
import io.airlift.configuration.ConfigBinder;
import java.util.Map;
import java.util.Objects;
import javax.management.MBeanServer;

public class JmxConnectorFactory
implements ConnectorFactory {
    private final MBeanServer mbeanServer;

    public JmxConnectorFactory(MBeanServer mbeanServer) {
        this.mbeanServer = Objects.requireNonNull(mbeanServer, "mbeanServer is null");
    }

    public String getName() {
        return "jmx";
    }

    public ConnectorHandleResolver getHandleResolver() {
        return new JmxHandleResolver();
    }

    public Connector create(String connectorId, Map<String, String> config, ConnectorContext context) {
        try {
            Bootstrap app = new Bootstrap(new Module[]{binder -> {
                ConfigBinder.configBinder((Binder)binder).bindConfig(JmxConnectorConfig.class);
                binder.bind(MBeanServer.class).toInstance((Object)new RebindSafeMBeanServer(this.mbeanServer));
                binder.bind(NodeManager.class).toInstance((Object)context.getNodeManager());
                binder.bind(JmxConnector.class).in(Scopes.SINGLETON);
                binder.bind(JmxHistoricalData.class).in(Scopes.SINGLETON);
                binder.bind(JmxMetadata.class).in(Scopes.SINGLETON);
                binder.bind(JmxSplitManager.class).in(Scopes.SINGLETON);
                binder.bind(JmxPeriodicSampler.class).in(Scopes.SINGLETON);
                binder.bind(JmxRecordSetProvider.class).in(Scopes.SINGLETON);
            }});
            Injector injector = app.strictConfig().doNotInitializeLogging().setRequiredConfigurationProperties(config).initialize();
            return (Connector)injector.getInstance(JmxConnector.class);
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

