/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.connector.jmx;

import com.facebook.presto.connector.jmx.JmxConnectorConfig;
import com.facebook.presto.connector.jmx.JmxHistoricalData;
import com.facebook.presto.connector.jmx.JmxMetadata;
import com.facebook.presto.connector.jmx.JmxRecordSetProvider;
import com.facebook.presto.connector.jmx.JmxTableHandle;
import com.facebook.presto.spi.SchemaTableName;
import com.google.common.collect.ImmutableList;
import io.airlift.concurrent.Threads;
import io.airlift.log.Logger;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.inject.Inject;

public class JmxPeriodicSampler
implements Runnable {
    private static final Logger log = Logger.get(JmxPeriodicSampler.class);
    private final JmxHistoricalData jmxHistoricalData;
    private final JmxRecordSetProvider jmxRecordSetProvider;
    private final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor(Threads.daemonThreadsNamed((String)"jmx-history-%s"));
    private final long period;
    private final List<JmxTableHandle> tableHandles;
    private long lastDumpTimestamp;

    @Inject
    public JmxPeriodicSampler(JmxHistoricalData jmxHistoricalData, JmxMetadata jmxMetadata, JmxRecordSetProvider jmxRecordSetProvider, JmxConnectorConfig jmxConfig) {
        this.jmxHistoricalData = Objects.requireNonNull(jmxHistoricalData, "jmxStatsHolder is null");
        Objects.requireNonNull(jmxMetadata, "jmxMetadata is null");
        this.jmxRecordSetProvider = Objects.requireNonNull(jmxRecordSetProvider, "jmxRecordSetProvider is null");
        Objects.requireNonNull(jmxConfig, "jmxConfig is null");
        this.period = jmxConfig.getDumpPeriod().toMillis();
        ImmutableList.Builder tableHandleBuilder = ImmutableList.builder();
        for (String tableName : jmxHistoricalData.getTables()) {
            tableHandleBuilder.add((Object)Objects.requireNonNull(jmxMetadata.getTableHandle(new SchemaTableName("history", tableName)), String.format("tableHandle is null for table [%s]", tableName)));
        }
        this.tableHandles = tableHandleBuilder.build();
    }

    @PostConstruct
    public void start() {
        if (this.tableHandles.size() > 0) {
            this.lastDumpTimestamp = this.roundToPeriod(System.currentTimeMillis());
            this.schedule();
        }
    }

    private void schedule() {
        long nextDumpTimestamp = this.lastDumpTimestamp + this.period;
        long nowMillis = System.currentTimeMillis();
        long delay = nextDumpTimestamp - nowMillis;
        this.executor.schedule(this, Math.max(delay, 0L), TimeUnit.MILLISECONDS);
    }

    private long roundToPeriod(long millis) {
        return (millis + this.period / 2L) / this.period * this.period;
    }

    @Override
    public void run() {
        try {
            this.runUnsafe();
        }
        catch (Exception exception) {
            log.error((Throwable)exception, "This should never happen, JmxPeriodicSampler will not be scheduled again.");
        }
    }

    private void runUnsafe() {
        long dumpTimestamp = this.roundToPeriod(System.currentTimeMillis());
        if (dumpTimestamp <= this.lastDumpTimestamp) {
            return;
        }
        this.lastDumpTimestamp = dumpTimestamp;
        for (JmxTableHandle tableHandle : this.tableHandles) {
            try {
                for (String objectName : tableHandle.getObjectNames()) {
                    List<Object> row = this.jmxRecordSetProvider.getLiveRow(objectName, tableHandle.getColumnHandles(), dumpTimestamp);
                    this.jmxHistoricalData.addRow(tableHandle.getTableName().getTableName(), row);
                }
            }
            catch (Exception exception) {
                log.error((Throwable)exception, "Error reading jmx records");
            }
        }
        this.schedule();
    }

    public void shutdown() {
        this.executor.shutdown();
    }
}

