/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.connector.jmx;

import com.facebook.presto.connector.jmx.JmxColumnHandle;
import com.facebook.presto.connector.jmx.JmxSplit;
import com.facebook.presto.connector.jmx.JmxTableHandle;
import com.facebook.presto.connector.jmx.JmxTableLayoutHandle;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorSplitSource;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.FixedSplitSource;
import com.facebook.presto.spi.HostAddress;
import com.facebook.presto.spi.NodeManager;
import com.facebook.presto.spi.connector.ConnectorSplitManager;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.predicate.NullableValue;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slices;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;

public class JmxSplitManager
implements ConnectorSplitManager {
    private final NodeManager nodeManager;

    @Inject
    public JmxSplitManager(NodeManager nodeManager) {
        this.nodeManager = Objects.requireNonNull(nodeManager, "nodeManager is null");
    }

    public ConnectorSplitSource getSplits(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorTableLayoutHandle layout, ConnectorSplitManager.SplitSchedulingStrategy splitSchedulingStrategy) {
        JmxTableLayoutHandle jmxLayout = (JmxTableLayoutHandle)layout;
        JmxTableHandle tableHandle = jmxLayout.getTable();
        TupleDomain<ColumnHandle> predicate = jmxLayout.getConstraint();
        Optional<JmxColumnHandle> nodeColumnHandle = tableHandle.getColumnHandles().stream().filter(jmxColumnHandle -> jmxColumnHandle.getColumnName().equals("node")).findFirst();
        Preconditions.checkState((boolean)nodeColumnHandle.isPresent(), (String)"Failed to find %s column", (Object)"node");
        List splits = this.nodeManager.getAllNodes().stream().filter(node -> {
            NullableValue value = NullableValue.of((Type)VarcharType.createUnboundedVarcharType(), (Object)Slices.utf8Slice((String)node.getNodeIdentifier()));
            return predicate.overlaps(TupleDomain.fromFixedValues((Map)ImmutableMap.of(nodeColumnHandle.get(), (Object)value)));
        }).map(node -> new JmxSplit(tableHandle, (List<HostAddress>)ImmutableList.of((Object)node.getHostAndPort()))).collect(Collectors.toList());
        return new FixedSplitSource(splits);
    }
}

