/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.connector.jmx;

import com.facebook.airlift.configuration.Config;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import io.airlift.units.Duration;
import io.airlift.units.MinDuration;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

public class JmxConnectorConfig {
    private Set<String> dumpTables = ImmutableSet.of();
    private Duration dumpPeriod = new Duration(10.0, TimeUnit.SECONDS);
    private int maxEntries = 86400;

    @NotNull
    public Set<String> getDumpTables() {
        return this.dumpTables;
    }

    @Config(value="jmx.dump-tables")
    public JmxConnectorConfig setDumpTables(String tableNames) {
        this.dumpTables = Splitter.on((Pattern)Pattern.compile("(?<!\\\\),")).omitEmptyStrings().splitToList((CharSequence)tableNames).stream().map(part -> part.replace("\\,", ",")).collect(Collectors.toSet());
        return this;
    }

    @VisibleForTesting
    JmxConnectorConfig setDumpTables(Set<String> tableNames) {
        this.dumpTables = ImmutableSet.copyOf(tableNames);
        return this;
    }

    @MinDuration(value="1ms")
    public Duration getDumpPeriod() {
        return this.dumpPeriod;
    }

    @Config(value="jmx.dump-period")
    public JmxConnectorConfig setDumpPeriod(Duration dumpPeriod) {
        this.dumpPeriod = dumpPeriod;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getMaxEntries() {
        return this.maxEntries;
    }

    @Config(value="jmx.max-entries")
    public JmxConnectorConfig setMaxEntries(int maxEntries) {
        this.maxEntries = maxEntries;
        return this;
    }
}

