/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.connector.jmx;

import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.TimestampType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.connector.jmx.JmxColumnHandle;
import com.facebook.presto.connector.jmx.JmxHistoricalData;
import com.facebook.presto.connector.jmx.JmxTableHandle;
import com.facebook.presto.connector.jmx.JmxTableLayoutHandle;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.ConnectorTableLayout;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.ConnectorTableLayoutResult;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.Constraint;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.SchemaTablePrefix;
import com.facebook.presto.spi.connector.ConnectorMetadata;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Streams;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class JmxMetadata
implements ConnectorMetadata {
    public static final String JMX_SCHEMA_NAME = "current";
    public static final String HISTORY_SCHEMA_NAME = "history";
    public static final String NODE_COLUMN_NAME = "node";
    public static final String OBJECT_NAME_NAME = "object_name";
    public static final String TIMESTAMP_COLUMN_NAME = "timestamp";
    private final MBeanServer mbeanServer;
    private final JmxHistoricalData jmxHistoricalData;

    @Inject
    public JmxMetadata(MBeanServer mbeanServer, JmxHistoricalData jmxHistoricalData) {
        this.mbeanServer = Objects.requireNonNull(mbeanServer, "mbeanServer is null");
        this.jmxHistoricalData = Objects.requireNonNull(jmxHistoricalData, "jmxStatsHolder is null");
    }

    public List<String> listSchemaNames(ConnectorSession session) {
        return ImmutableList.of((Object)JMX_SCHEMA_NAME, (Object)HISTORY_SCHEMA_NAME);
    }

    public JmxTableHandle getTableHandle(ConnectorSession session, SchemaTableName tableName) {
        return this.getTableHandle(tableName);
    }

    public JmxTableHandle getTableHandle(SchemaTableName tableName) {
        Objects.requireNonNull(tableName, "tableName is null");
        if (tableName.getSchemaName().equals(JMX_SCHEMA_NAME)) {
            return this.getJmxTableHandle(tableName);
        }
        if (tableName.getSchemaName().equals(HISTORY_SCHEMA_NAME)) {
            return this.getJmxHistoryTableHandle(tableName);
        }
        return null;
    }

    private JmxTableHandle getJmxHistoryTableHandle(SchemaTableName tableName) {
        JmxTableHandle handle = this.getJmxTableHandle(tableName);
        if (handle == null) {
            return null;
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)new JmxColumnHandle(TIMESTAMP_COLUMN_NAME, (Type)TimestampType.TIMESTAMP));
        builder.addAll(handle.getColumnHandles());
        return new JmxTableHandle(handle.getTableName(), handle.getObjectNames(), (List<JmxColumnHandle>)builder.build(), false);
    }

    private JmxTableHandle getJmxTableHandle(SchemaTableName tableName) {
        try {
            String objectNamePattern = this.toPattern(tableName.getTableName().toLowerCase(Locale.ENGLISH));
            List objectNames = (List)this.mbeanServer.queryNames(ObjectName.WILDCARD, null).stream().filter(name -> name.getCanonicalName().toLowerCase(Locale.ENGLISH).matches(objectNamePattern)).collect(ImmutableList.toImmutableList());
            if (objectNames.isEmpty()) {
                return null;
            }
            ArrayList<JmxColumnHandle> columns = new ArrayList<JmxColumnHandle>();
            columns.add(new JmxColumnHandle(NODE_COLUMN_NAME, (Type)VarcharType.createUnboundedVarcharType()));
            columns.add(new JmxColumnHandle(OBJECT_NAME_NAME, (Type)VarcharType.createUnboundedVarcharType()));
            for (ObjectName objectName : objectNames) {
                MBeanInfo mbeanInfo = this.mbeanServer.getMBeanInfo(objectName);
                this.getColumnHandles(mbeanInfo).forEach(columns::add);
            }
            columns = (List)columns.stream().distinct().sorted(Comparator.comparing(JmxColumnHandle::getColumnName)).collect(ImmutableList.toImmutableList());
            return new JmxTableHandle(tableName, (List)objectNames.stream().map(ObjectName::toString).collect(ImmutableList.toImmutableList()), columns, true);
        }
        catch (JMException e) {
            return null;
        }
    }

    private String toPattern(String tableName) throws MalformedObjectNameException {
        if (!tableName.contains("*")) {
            return Pattern.quote(new ObjectName(tableName).getCanonicalName());
        }
        return Streams.stream((Iterable)Splitter.on((char)'*').split((CharSequence)tableName)).map(Pattern::quote).collect(Collectors.joining(".*"));
    }

    private Stream<JmxColumnHandle> getColumnHandles(MBeanInfo mbeanInfo) {
        return Arrays.stream(mbeanInfo.getAttributes()).filter(MBeanAttributeInfo::isReadable).map(attribute -> new JmxColumnHandle(attribute.getName(), JmxMetadata.getColumnType(attribute)));
    }

    public ConnectorTableMetadata getTableMetadata(ConnectorSession session, ConnectorTableHandle tableHandle) {
        return ((JmxTableHandle)tableHandle).getTableMetadata();
    }

    public List<SchemaTableName> listTables(ConnectorSession session, String schemaNameOrNull) {
        ImmutableSet schemaNames = schemaNameOrNull != null ? ImmutableSet.of((Object)schemaNameOrNull) : ImmutableSet.copyOf(this.listSchemaNames(session));
        ImmutableList.Builder schemaTableNames = ImmutableList.builder();
        for (String schema : schemaNames) {
            if (JMX_SCHEMA_NAME.equals(schema)) {
                return this.listJmxTables();
            }
            if (!HISTORY_SCHEMA_NAME.equals(schema)) continue;
            return this.jmxHistoricalData.getTables().stream().map(tableName -> new SchemaTableName(HISTORY_SCHEMA_NAME, tableName)).collect(Collectors.toList());
        }
        return schemaTableNames.build();
    }

    private List<SchemaTableName> listJmxTables() {
        ImmutableList.Builder tableNames = ImmutableList.builder();
        for (ObjectName objectName : this.mbeanServer.queryNames(ObjectName.WILDCARD, null)) {
            tableNames.add((Object)new SchemaTableName(JMX_SCHEMA_NAME, objectName.getCanonicalName().toLowerCase(Locale.ENGLISH)));
        }
        return tableNames.build();
    }

    public Map<String, ColumnHandle> getColumnHandles(ConnectorSession session, ConnectorTableHandle tableHandle) {
        JmxTableHandle jmxTableHandle = (JmxTableHandle)tableHandle;
        return ImmutableMap.copyOf((Map)Maps.uniqueIndex(jmxTableHandle.getColumnHandles(), column -> column.getColumnName().toLowerCase(Locale.ENGLISH)));
    }

    public ColumnMetadata getColumnMetadata(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle) {
        return ((JmxColumnHandle)columnHandle).getColumnMetadata();
    }

    public Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(ConnectorSession session, SchemaTablePrefix prefix) {
        Objects.requireNonNull(prefix, "prefix is null");
        if (prefix.getSchemaName() != null && !prefix.getSchemaName().equals(JMX_SCHEMA_NAME) && !prefix.getSchemaName().equals(HISTORY_SCHEMA_NAME)) {
            return ImmutableMap.of();
        }
        ImmutableList tableNames = prefix.getTableName() == null ? this.listTables(session, prefix.getSchemaName()) : ImmutableList.of((Object)new SchemaTableName(prefix.getSchemaName(), prefix.getTableName()));
        return (Map)tableNames.stream().collect(ImmutableMap.toImmutableMap(Function.identity(), tableName -> this.getTableHandle(session, (SchemaTableName)tableName).getTableMetadata().getColumns()));
    }

    public List<ConnectorTableLayoutResult> getTableLayouts(ConnectorSession session, ConnectorTableHandle table, Constraint<ColumnHandle> constraint, Optional<Set<ColumnHandle>> desiredColumns) {
        JmxTableHandle handle = (JmxTableHandle)table;
        ConnectorTableLayout layout = new ConnectorTableLayout((ConnectorTableLayoutHandle)new JmxTableLayoutHandle(handle, (TupleDomain<ColumnHandle>)constraint.getSummary()));
        return ImmutableList.of((Object)new ConnectorTableLayoutResult(layout, constraint.getSummary()));
    }

    public ConnectorTableLayout getTableLayout(ConnectorSession session, ConnectorTableLayoutHandle handle) {
        return new ConnectorTableLayout(handle);
    }

    private static Type getColumnType(MBeanAttributeInfo attribute) {
        switch (attribute.getType()) {
            case "boolean": 
            case "java.lang.Boolean": {
                return BooleanType.BOOLEAN;
            }
            case "byte": 
            case "java.lang.Byte": 
            case "short": 
            case "java.lang.Short": 
            case "int": 
            case "java.lang.Integer": 
            case "long": 
            case "java.lang.Long": {
                return BigintType.BIGINT;
            }
            case "java.lang.Number": 
            case "float": 
            case "java.lang.Float": 
            case "double": 
            case "java.lang.Double": {
                return DoubleType.DOUBLE;
            }
        }
        return VarcharType.createUnboundedVarcharType();
    }
}

