/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.kafka;

import com.facebook.presto.spi.HostAddress;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import io.airlift.configuration.Config;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.airlift.units.MinDuration;
import java.io.File;
import java.util.Set;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

public class KafkaConnectorConfig {
    private static final int KAFKA_DEFAULT_PORT = 9092;
    private Set<HostAddress> nodes = ImmutableSet.of();
    private Duration kafkaConnectTimeout = Duration.valueOf((String)"10s");
    private DataSize kafkaBufferSize = new DataSize(64.0, DataSize.Unit.KILOBYTE);
    private String defaultSchema = "default";
    private Set<String> tableNames = ImmutableSet.of();
    private File tableDescriptionDir = new File("etc/kafka/");
    private boolean hideInternalColumns = true;

    @NotNull
    public File getTableDescriptionDir() {
        return this.tableDescriptionDir;
    }

    @Config(value="kafka.table-description-dir")
    public KafkaConnectorConfig setTableDescriptionDir(File tableDescriptionDir) {
        this.tableDescriptionDir = tableDescriptionDir;
        return this;
    }

    @NotNull
    public Set<String> getTableNames() {
        return this.tableNames;
    }

    @Config(value="kafka.table-names")
    public KafkaConnectorConfig setTableNames(String tableNames) {
        this.tableNames = ImmutableSet.copyOf((Iterable)Splitter.on((char)',').omitEmptyStrings().trimResults().split((CharSequence)tableNames));
        return this;
    }

    @NotNull
    public String getDefaultSchema() {
        return this.defaultSchema;
    }

    @Config(value="kafka.default-schema")
    public KafkaConnectorConfig setDefaultSchema(String defaultSchema) {
        this.defaultSchema = defaultSchema;
        return this;
    }

    @Size(min=1)
    public Set<HostAddress> getNodes() {
        return this.nodes;
    }

    @Config(value="kafka.nodes")
    public KafkaConnectorConfig setNodes(String nodes) {
        this.nodes = nodes == null ? null : KafkaConnectorConfig.parseNodes(nodes);
        return this;
    }

    @MinDuration(value="1s")
    public Duration getKafkaConnectTimeout() {
        return this.kafkaConnectTimeout;
    }

    @Config(value="kafka.connect-timeout")
    public KafkaConnectorConfig setKafkaConnectTimeout(String kafkaConnectTimeout) {
        this.kafkaConnectTimeout = Duration.valueOf((String)kafkaConnectTimeout);
        return this;
    }

    public DataSize getKafkaBufferSize() {
        return this.kafkaBufferSize;
    }

    @Config(value="kafka.buffer-size")
    public KafkaConnectorConfig setKafkaBufferSize(String kafkaBufferSize) {
        this.kafkaBufferSize = DataSize.valueOf((String)kafkaBufferSize);
        return this;
    }

    public boolean isHideInternalColumns() {
        return this.hideInternalColumns;
    }

    @Config(value="kafka.hide-internal-columns")
    public KafkaConnectorConfig setHideInternalColumns(boolean hideInternalColumns) {
        this.hideInternalColumns = hideInternalColumns;
        return this;
    }

    public static ImmutableSet<HostAddress> parseNodes(String nodes) {
        Splitter splitter = Splitter.on((char)',').omitEmptyStrings().trimResults();
        return ImmutableSet.copyOf((Iterable)Iterables.transform((Iterable)splitter.split((CharSequence)nodes), KafkaConnectorConfig::toHostAddress));
    }

    private static HostAddress toHostAddress(String value) {
        return HostAddress.fromString((String)value).withDefaultPort(9092);
    }
}

