/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.kafka;

import com.facebook.presto.decoder.DecoderColumnHandle;
import com.facebook.presto.decoder.FieldValueProvider;
import com.facebook.presto.decoder.FieldValueProviders;
import com.facebook.presto.decoder.RowDecoder;
import com.facebook.presto.kafka.KafkaColumnHandle;
import com.facebook.presto.kafka.KafkaErrorCode;
import com.facebook.presto.kafka.KafkaInternalFieldDescription;
import com.facebook.presto.kafka.KafkaSimpleConsumerManager;
import com.facebook.presto.kafka.KafkaSplit;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.RecordCursor;
import com.facebook.presto.spi.RecordSet;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.log.Logger;
import io.airlift.slice.Slice;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.api.FetchRequest;
import kafka.api.FetchRequestBuilder;
import kafka.javaapi.FetchResponse;
import kafka.javaapi.consumer.SimpleConsumer;
import kafka.message.MessageAndOffset;

public class KafkaRecordSet
implements RecordSet {
    private static final Logger log = Logger.get(KafkaRecordSet.class);
    private static final int KAFKA_READ_BUFFER_SIZE = 100000;
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private final KafkaSplit split;
    private final KafkaSimpleConsumerManager consumerManager;
    private final RowDecoder keyDecoder;
    private final RowDecoder messageDecoder;
    private final List<KafkaColumnHandle> columnHandles;
    private final List<Type> columnTypes;

    KafkaRecordSet(KafkaSplit split, KafkaSimpleConsumerManager consumerManager, List<KafkaColumnHandle> columnHandles, RowDecoder keyDecoder, RowDecoder messageDecoder) {
        this.split = Objects.requireNonNull(split, "split is null");
        this.consumerManager = Objects.requireNonNull(consumerManager, "consumerManager is null");
        this.keyDecoder = Objects.requireNonNull(keyDecoder, "rowDecoder is null");
        this.messageDecoder = Objects.requireNonNull(messageDecoder, "rowDecoder is null");
        this.columnHandles = Objects.requireNonNull(columnHandles, "columnHandles is null");
        ImmutableList.Builder typeBuilder = ImmutableList.builder();
        for (DecoderColumnHandle decoderColumnHandle : columnHandles) {
            typeBuilder.add((Object)decoderColumnHandle.getType());
        }
        this.columnTypes = typeBuilder.build();
    }

    public List<Type> getColumnTypes() {
        return this.columnTypes;
    }

    public RecordCursor cursor() {
        return new KafkaRecordCursor();
    }

    public class KafkaRecordCursor
    implements RecordCursor {
        private long totalBytes;
        private long totalMessages;
        private long cursorOffset;
        private Iterator<MessageAndOffset> messageAndOffsetIterator;
        private final AtomicBoolean reported;
        private final FieldValueProvider[] currentRowValues;

        KafkaRecordCursor() {
            this.cursorOffset = KafkaRecordSet.this.split.getStart();
            this.reported = new AtomicBoolean();
            this.currentRowValues = new FieldValueProvider[KafkaRecordSet.this.columnHandles.size()];
        }

        public long getCompletedBytes() {
            return this.totalBytes;
        }

        public long getReadTimeNanos() {
            return 0L;
        }

        public Type getType(int field) {
            Preconditions.checkArgument((field < KafkaRecordSet.this.columnHandles.size() ? 1 : 0) != 0, (Object)"Invalid field index");
            return ((KafkaColumnHandle)KafkaRecordSet.this.columnHandles.get(field)).getType();
        }

        public boolean advanceNextPosition() {
            while (this.cursorOffset < KafkaRecordSet.this.split.getEnd()) {
                this.openFetchRequest();
                while (this.messageAndOffsetIterator.hasNext()) {
                    MessageAndOffset currentMessageAndOffset = this.messageAndOffsetIterator.next();
                    long messageOffset = currentMessageAndOffset.offset();
                    if (messageOffset >= KafkaRecordSet.this.split.getEnd()) {
                        return this.endOfData();
                    }
                    if (messageOffset < this.cursorOffset) continue;
                    return this.nextRow(currentMessageAndOffset);
                }
                this.messageAndOffsetIterator = null;
            }
            return this.endOfData();
        }

        private boolean endOfData() {
            if (!this.reported.getAndSet(true)) {
                log.debug("Found a total of %d messages with %d bytes (%d messages expected). Last Offset: %d (%d, %d)", new Object[]{this.totalMessages, this.totalBytes, KafkaRecordSet.this.split.getEnd() - KafkaRecordSet.this.split.getStart(), this.cursorOffset, KafkaRecordSet.this.split.getStart(), KafkaRecordSet.this.split.getEnd()});
            }
            return false;
        }

        private boolean nextRow(MessageAndOffset messageAndOffset) {
            ByteBuffer message;
            this.cursorOffset = messageAndOffset.offset() + 1L;
            this.totalBytes += (long)messageAndOffset.message().payloadSize();
            ++this.totalMessages;
            byte[] keyData = EMPTY_BYTE_ARRAY;
            byte[] messageData = EMPTY_BYTE_ARRAY;
            ByteBuffer key = messageAndOffset.message().key();
            if (key != null) {
                keyData = new byte[key.remaining()];
                key.get(keyData);
            }
            if ((message = messageAndOffset.message().payload()) != null) {
                messageData = new byte[message.remaining()];
                message.get(messageData);
            }
            HashMap<DecoderColumnHandle, FieldValueProvider> currentRowValuesMap = new HashMap<DecoderColumnHandle, FieldValueProvider>();
            Optional decodedKey = KafkaRecordSet.this.keyDecoder.decodeRow(keyData, null);
            Optional decodedValue = KafkaRecordSet.this.messageDecoder.decodeRow(messageData, null);
            block13: for (DecoderColumnHandle columnHandle : KafkaRecordSet.this.columnHandles) {
                if (!columnHandle.isInternal()) continue;
                KafkaInternalFieldDescription fieldDescription = KafkaInternalFieldDescription.forColumnName(columnHandle.getName());
                switch (fieldDescription) {
                    case SEGMENT_COUNT_FIELD: {
                        currentRowValuesMap.put(columnHandle, FieldValueProviders.longValueProvider((long)this.totalMessages));
                        continue block13;
                    }
                    case PARTITION_OFFSET_FIELD: {
                        currentRowValuesMap.put(columnHandle, FieldValueProviders.longValueProvider((long)messageAndOffset.offset()));
                        continue block13;
                    }
                    case MESSAGE_FIELD: {
                        currentRowValuesMap.put(columnHandle, FieldValueProviders.bytesValueProvider((byte[])messageData));
                        continue block13;
                    }
                    case MESSAGE_LENGTH_FIELD: {
                        currentRowValuesMap.put(columnHandle, FieldValueProviders.longValueProvider((long)messageData.length));
                        continue block13;
                    }
                    case KEY_FIELD: {
                        currentRowValuesMap.put(columnHandle, FieldValueProviders.bytesValueProvider((byte[])keyData));
                        continue block13;
                    }
                    case KEY_LENGTH_FIELD: {
                        currentRowValuesMap.put(columnHandle, FieldValueProviders.longValueProvider((long)keyData.length));
                        continue block13;
                    }
                    case KEY_CORRUPT_FIELD: {
                        currentRowValuesMap.put(columnHandle, FieldValueProviders.booleanValueProvider((!decodedKey.isPresent() ? 1 : 0) != 0));
                        continue block13;
                    }
                    case MESSAGE_CORRUPT_FIELD: {
                        currentRowValuesMap.put(columnHandle, FieldValueProviders.booleanValueProvider((!decodedValue.isPresent() ? 1 : 0) != 0));
                        continue block13;
                    }
                    case PARTITION_ID_FIELD: {
                        currentRowValuesMap.put(columnHandle, FieldValueProviders.longValueProvider((long)KafkaRecordSet.this.split.getPartitionId()));
                        continue block13;
                    }
                    case SEGMENT_START_FIELD: {
                        currentRowValuesMap.put(columnHandle, FieldValueProviders.longValueProvider((long)KafkaRecordSet.this.split.getStart()));
                        continue block13;
                    }
                    case SEGMENT_END_FIELD: {
                        currentRowValuesMap.put(columnHandle, FieldValueProviders.longValueProvider((long)KafkaRecordSet.this.split.getEnd()));
                        continue block13;
                    }
                }
                throw new IllegalArgumentException("unknown internal field " + (Object)((Object)fieldDescription));
            }
            decodedKey.ifPresent(currentRowValuesMap::putAll);
            decodedValue.ifPresent(currentRowValuesMap::putAll);
            for (int i = 0; i < KafkaRecordSet.this.columnHandles.size(); ++i) {
                DecoderColumnHandle columnHandle;
                columnHandle = (ColumnHandle)KafkaRecordSet.this.columnHandles.get(i);
                this.currentRowValues[i] = (FieldValueProvider)currentRowValuesMap.get(columnHandle);
            }
            return true;
        }

        public boolean getBoolean(int field) {
            return this.getFieldValueProvider(field, Boolean.TYPE).getBoolean();
        }

        public long getLong(int field) {
            return this.getFieldValueProvider(field, Long.TYPE).getLong();
        }

        public double getDouble(int field) {
            return this.getFieldValueProvider(field, Double.TYPE).getDouble();
        }

        public Slice getSlice(int field) {
            return this.getFieldValueProvider(field, Slice.class).getSlice();
        }

        public Object getObject(int field) {
            return this.getFieldValueProvider(field, Block.class).getBlock();
        }

        public boolean isNull(int field) {
            Preconditions.checkArgument((field < KafkaRecordSet.this.columnHandles.size() ? 1 : 0) != 0, (Object)"Invalid field index");
            return this.currentRowValues[field] == null || this.currentRowValues[field].isNull();
        }

        private FieldValueProvider getFieldValueProvider(int field, Class<?> expectedType) {
            Preconditions.checkArgument((field < KafkaRecordSet.this.columnHandles.size() ? 1 : 0) != 0, (Object)"Invalid field index");
            this.checkFieldType(field, expectedType);
            return this.currentRowValues[field];
        }

        private void checkFieldType(int field, Class<?> expected) {
            Class actual = this.getType(field).getJavaType();
            Preconditions.checkArgument((actual == expected ? 1 : 0) != 0, (String)"Expected field %s to be type %s but is %s", (Object)field, expected, (Object)actual);
        }

        public void close() {
        }

        private void openFetchRequest() {
            try {
                if (this.messageAndOffsetIterator == null) {
                    log.debug("Fetching %d bytes from offset %d (%d - %d). %d messages read so far", new Object[]{100000, this.cursorOffset, KafkaRecordSet.this.split.getStart(), KafkaRecordSet.this.split.getEnd(), this.totalMessages});
                    FetchRequest req = new FetchRequestBuilder().clientId("presto-worker-" + Thread.currentThread().getName()).addFetch(KafkaRecordSet.this.split.getTopicName(), KafkaRecordSet.this.split.getPartitionId(), this.cursorOffset, 100000).build();
                    SimpleConsumer consumer = KafkaRecordSet.this.consumerManager.getConsumer(KafkaRecordSet.this.split.getLeader());
                    FetchResponse fetchResponse = consumer.fetch(req);
                    if (fetchResponse.hasError()) {
                        short errorCode = fetchResponse.errorCode(KafkaRecordSet.this.split.getTopicName(), KafkaRecordSet.this.split.getPartitionId());
                        log.warn("Fetch response has error: %d", new Object[]{errorCode});
                        throw new RuntimeException("could not fetch data from Kafka, error code is '" + errorCode + "'");
                    }
                    this.messageAndOffsetIterator = fetchResponse.messageSet(KafkaRecordSet.this.split.getTopicName(), KafkaRecordSet.this.split.getPartitionId()).iterator();
                }
            }
            catch (Exception e) {
                if (e instanceof PrestoException) {
                    throw e;
                }
                throw new PrestoException((ErrorCodeSupplier)KafkaErrorCode.KAFKA_SPLIT_ERROR, String.format("Cannot read data from topic '%s', partition '%s', startOffset %s, endOffset %s, leader %s ", KafkaRecordSet.this.split.getTopicName(), KafkaRecordSet.this.split.getPartitionId(), KafkaRecordSet.this.split.getStart(), KafkaRecordSet.this.split.getEnd(), KafkaRecordSet.this.split.getLeader()), (Throwable)e);
            }
        }
    }
}

