/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.kafka;

import com.facebook.presto.decoder.DispatchingRowDecoderFactory;
import com.facebook.presto.decoder.RowDecoder;
import com.facebook.presto.kafka.KafkaColumnHandle;
import com.facebook.presto.kafka.KafkaHandleResolver;
import com.facebook.presto.kafka.KafkaRecordSet;
import com.facebook.presto.kafka.KafkaSimpleConsumerManager;
import com.facebook.presto.kafka.KafkaSplit;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.RecordSet;
import com.facebook.presto.spi.connector.ConnectorRecordSetProvider;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;

public class KafkaRecordSetProvider
implements ConnectorRecordSetProvider {
    private DispatchingRowDecoderFactory decoderFactory;
    private final KafkaSimpleConsumerManager consumerManager;

    @Inject
    public KafkaRecordSetProvider(DispatchingRowDecoderFactory decoderFactory, KafkaSimpleConsumerManager consumerManager) {
        this.decoderFactory = Objects.requireNonNull(decoderFactory, "decoderFactory is null");
        this.consumerManager = Objects.requireNonNull(consumerManager, "consumerManager is null");
    }

    public RecordSet getRecordSet(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorSplit split, List<? extends ColumnHandle> columns) {
        KafkaSplit kafkaSplit = KafkaHandleResolver.convertSplit(split);
        List kafkaColumns = (List)columns.stream().map(KafkaHandleResolver::convertColumnHandle).collect(ImmutableList.toImmutableList());
        RowDecoder keyDecoder = this.decoderFactory.create(kafkaSplit.getKeyDataFormat(), this.getDecoderParameters(kafkaSplit.getKeyDataSchemaContents()), (Set)kafkaColumns.stream().filter(col -> !col.isInternal()).filter(KafkaColumnHandle::isKeyDecoder).collect(ImmutableSet.toImmutableSet()));
        RowDecoder messageDecoder = this.decoderFactory.create(kafkaSplit.getMessageDataFormat(), this.getDecoderParameters(kafkaSplit.getMessageDataSchemaContents()), (Set)kafkaColumns.stream().filter(col -> !col.isInternal()).filter(col -> !col.isKeyDecoder()).collect(ImmutableSet.toImmutableSet()));
        return new KafkaRecordSet(kafkaSplit, this.consumerManager, kafkaColumns, keyDecoder, messageDecoder);
    }

    private Map<String, String> getDecoderParameters(Optional<String> dataSchema) {
        ImmutableMap.Builder parameters = ImmutableMap.builder();
        dataSchema.ifPresent(schema -> parameters.put((Object)"dataSchema", schema));
        return parameters.build();
    }
}

