/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.kafka;

import com.facebook.presto.kafka.KafkaConnectorConfig;
import com.facebook.presto.kafka.KafkaConnectorId;
import com.facebook.presto.spi.HostAddress;
import com.facebook.presto.spi.NodeManager;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import io.airlift.log.Logger;
import java.util.Map;
import java.util.Objects;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import kafka.javaapi.consumer.SimpleConsumer;

public class KafkaSimpleConsumerManager {
    private static final Logger log = Logger.get(KafkaSimpleConsumerManager.class);
    private final LoadingCache<HostAddress, SimpleConsumer> consumerCache;
    private final String connectorId;
    private final NodeManager nodeManager;
    private final int connectTimeoutMillis;
    private final int bufferSizeBytes;

    @Inject
    public KafkaSimpleConsumerManager(KafkaConnectorId connectorId, KafkaConnectorConfig kafkaConnectorConfig, NodeManager nodeManager) {
        this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null").toString();
        this.nodeManager = Objects.requireNonNull(nodeManager, "nodeManager is null");
        Objects.requireNonNull(kafkaConnectorConfig, "kafkaConfig is null");
        this.connectTimeoutMillis = Math.toIntExact(kafkaConnectorConfig.getKafkaConnectTimeout().toMillis());
        this.bufferSizeBytes = Math.toIntExact(kafkaConnectorConfig.getKafkaBufferSize().toBytes());
        this.consumerCache = CacheBuilder.newBuilder().build(CacheLoader.from(this::createConsumer));
    }

    @PreDestroy
    public void tearDown() {
        for (Map.Entry entry : this.consumerCache.asMap().entrySet()) {
            try {
                ((SimpleConsumer)entry.getValue()).close();
            }
            catch (Exception e) {
                log.warn((Throwable)e, "While closing consumer %s:", new Object[]{entry.getKey()});
            }
        }
    }

    public SimpleConsumer getConsumer(HostAddress host) {
        Objects.requireNonNull(host, "host is null");
        return (SimpleConsumer)this.consumerCache.getUnchecked((Object)host);
    }

    private SimpleConsumer createConsumer(HostAddress host) {
        log.info("Creating new Consumer for %s", new Object[]{host});
        return new SimpleConsumer(host.getHostText(), host.getPort(), this.connectTimeoutMillis, this.bufferSizeBytes, String.format("presto-kafka-%s-%s", this.connectorId, this.nodeManager.getCurrentNode().getNodeIdentifier()));
    }
}

