/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.kafka;

import com.facebook.presto.kafka.KafkaConnectorConfig;
import com.facebook.presto.kafka.KafkaConnectorId;
import com.facebook.presto.kafka.KafkaErrorCode;
import com.facebook.presto.kafka.KafkaHandleResolver;
import com.facebook.presto.kafka.KafkaSimpleConsumerManager;
import com.facebook.presto.kafka.KafkaSplit;
import com.facebook.presto.kafka.KafkaTableHandle;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorSplitSource;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.FixedSplitSource;
import com.facebook.presto.spi.HostAddress;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.connector.ConnectorSplitManager;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.CharStreams;
import io.airlift.log.Logger;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import javax.inject.Inject;
import kafka.api.PartitionOffsetRequestInfo;
import kafka.cluster.Broker;
import kafka.common.TopicAndPartition;
import kafka.javaapi.OffsetRequest;
import kafka.javaapi.OffsetResponse;
import kafka.javaapi.PartitionMetadata;
import kafka.javaapi.TopicMetadata;
import kafka.javaapi.TopicMetadataRequest;
import kafka.javaapi.TopicMetadataResponse;
import kafka.javaapi.consumer.SimpleConsumer;

public class KafkaSplitManager
implements ConnectorSplitManager {
    private static final Logger log = Logger.get(KafkaSplitManager.class);
    private final String connectorId;
    private final KafkaSimpleConsumerManager consumerManager;
    private final Set<HostAddress> nodes;

    @Inject
    public KafkaSplitManager(KafkaConnectorId connectorId, KafkaConnectorConfig kafkaConnectorConfig, KafkaSimpleConsumerManager consumerManager) {
        this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null").toString();
        this.consumerManager = Objects.requireNonNull(consumerManager, "consumerManager is null");
        Objects.requireNonNull(kafkaConnectorConfig, "kafkaConfig is null");
        this.nodes = ImmutableSet.copyOf(kafkaConnectorConfig.getNodes());
    }

    public ConnectorSplitSource getSplits(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorTableLayoutHandle layout, ConnectorSplitManager.SplitSchedulingStrategy splitSchedulingStrategy) {
        KafkaTableHandle kafkaTableHandle = KafkaHandleResolver.convertLayout(layout).getTable();
        try {
            SimpleConsumer simpleConsumer = this.consumerManager.getConsumer(KafkaSplitManager.selectRandom(this.nodes));
            TopicMetadataRequest topicMetadataRequest = new TopicMetadataRequest((List)ImmutableList.of((Object)kafkaTableHandle.getTopicName()));
            TopicMetadataResponse topicMetadataResponse = simpleConsumer.send(topicMetadataRequest);
            ImmutableList.Builder splits = ImmutableList.builder();
            for (TopicMetadata metadata : topicMetadataResponse.topicsMetadata()) {
                for (PartitionMetadata part : metadata.partitionsMetadata()) {
                    log.debug("Adding Partition %s/%s", new Object[]{metadata.topic(), part.partitionId()});
                    Broker leader = part.leader();
                    if (leader == null) {
                        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, String.format("Leader election in progress for Kafka topic '%s' partition %s", metadata.topic(), part.partitionId()));
                    }
                    HostAddress partitionLeader = HostAddress.fromParts((String)leader.host(), (int)leader.port());
                    SimpleConsumer leaderConsumer = this.consumerManager.getConsumer(partitionLeader);
                    long[] offsets = KafkaSplitManager.findAllOffsets(leaderConsumer, metadata.topic(), part.partitionId());
                    for (int i = offsets.length - 1; i > 0; --i) {
                        KafkaSplit split = new KafkaSplit(this.connectorId, metadata.topic(), kafkaTableHandle.getKeyDataFormat(), kafkaTableHandle.getMessageDataFormat(), kafkaTableHandle.getKeyDataSchemaLocation().map(KafkaSplitManager::readSchema), kafkaTableHandle.getMessageDataSchemaLocation().map(KafkaSplitManager::readSchema), part.partitionId(), offsets[i], offsets[i - 1], partitionLeader);
                        splits.add((Object)split);
                    }
                }
            }
            return new FixedSplitSource((Iterable)splits.build());
        }
        catch (Exception e) {
            if (e instanceof PrestoException) {
                throw e;
            }
            throw new PrestoException((ErrorCodeSupplier)KafkaErrorCode.KAFKA_SPLIT_ERROR, String.format("Cannot list splits for table '%s' reading topic '%s'", kafkaTableHandle.getTableName(), kafkaTableHandle.getTopicName()), (Throwable)e);
        }
    }

    private static String readSchema(String dataSchemaLocation) {
        InputStream inputStream = null;
        try {
            if (KafkaSplitManager.isURI(dataSchemaLocation.trim().toLowerCase(Locale.ENGLISH))) {
                try {
                    inputStream = new URL(dataSchemaLocation).openStream();
                }
                catch (MalformedURLException e) {
                    inputStream = new FileInputStream(dataSchemaLocation);
                }
            } else {
                inputStream = new FileInputStream(dataSchemaLocation);
            }
            String e = CharStreams.toString((Readable)new InputStreamReader(inputStream, StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            try {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Could not parse the Avro schema at: " + dataSchemaLocation, (Throwable)e);
            }
            catch (Throwable throwable) {
                KafkaSplitManager.closeQuietly(inputStream);
                throw throwable;
            }
        }
        KafkaSplitManager.closeQuietly(inputStream);
        return e;
    }

    private static void closeQuietly(InputStream stream) {
        try {
            if (stream != null) {
                stream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static boolean isURI(String location) {
        try {
            URI.create(location);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private static long[] findAllOffsets(SimpleConsumer consumer, String topicName, int partitionId) {
        TopicAndPartition topicAndPartition = new TopicAndPartition(topicName, partitionId);
        PartitionOffsetRequestInfo partitionOffsetRequestInfo = new PartitionOffsetRequestInfo(kafka.api.OffsetRequest.LatestTime(), Integer.MAX_VALUE);
        OffsetRequest offsetRequest = new OffsetRequest((Map)ImmutableMap.of((Object)topicAndPartition, (Object)partitionOffsetRequestInfo), kafka.api.OffsetRequest.CurrentVersion(), consumer.clientId());
        OffsetResponse offsetResponse = consumer.getOffsetsBefore(offsetRequest);
        if (offsetResponse.hasError()) {
            short errorCode = offsetResponse.errorCode(topicName, partitionId);
            throw new RuntimeException("could not fetch data from Kafka, error code is '" + errorCode + "'");
        }
        return offsetResponse.offsets(topicName, partitionId);
    }

    private static <T> T selectRandom(Iterable<T> iterable) {
        ImmutableList list = ImmutableList.copyOf(iterable);
        return (T)list.get(ThreadLocalRandom.current().nextInt(list.size()));
    }
}

