/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.kafka;

import com.facebook.airlift.configuration.Config;
import io.airlift.units.Duration;
import io.airlift.units.MinDuration;
import javax.validation.constraints.NotNull;

public class KafkaConnectorConfig {
    private Duration kafkaConnectTimeout = Duration.valueOf((String)"10s");
    private String defaultSchema = "default";
    private boolean hideInternalColumns = true;
    private int maxPollRecords = 500;
    private int maxPartitionFetchBytes = 0x100000;
    private String tableDescriptionSupplier = "file";
    private String clusterMetadataSupplier = "file";

    @NotNull
    public String getDefaultSchema() {
        return this.defaultSchema;
    }

    @Config(value="kafka.default-schema")
    public KafkaConnectorConfig setDefaultSchema(String defaultSchema) {
        this.defaultSchema = defaultSchema;
        return this;
    }

    @MinDuration(value="1s")
    public Duration getKafkaConnectTimeout() {
        return this.kafkaConnectTimeout;
    }

    @Config(value="kafka.connect-timeout")
    public KafkaConnectorConfig setKafkaConnectTimeout(String kafkaConnectTimeout) {
        this.kafkaConnectTimeout = Duration.valueOf((String)kafkaConnectTimeout);
        return this;
    }

    public int getMaxPollRecords() {
        return this.maxPollRecords;
    }

    @Config(value="kafka.max-poll-records")
    public KafkaConnectorConfig setMaxPollRecords(int maxPollRecords) {
        this.maxPollRecords = maxPollRecords;
        return this;
    }

    public int getMaxPartitionFetchBytes() {
        return this.maxPartitionFetchBytes;
    }

    @Config(value="kafka.max-partition-fetch-bytes")
    public KafkaConnectorConfig setMaxPartitionFetchBytes(int maxPartitionFetchBytes) {
        this.maxPartitionFetchBytes = maxPartitionFetchBytes;
        return this;
    }

    @NotNull
    public String getTableDescriptionSupplier() {
        return this.tableDescriptionSupplier;
    }

    @Config(value="kafka.table-description-supplier")
    public KafkaConnectorConfig setTableDescriptionSupplier(String tableDescriptionSupplier) {
        this.tableDescriptionSupplier = tableDescriptionSupplier;
        return this;
    }

    @NotNull
    public String getClusterMetadataSupplier() {
        return this.clusterMetadataSupplier;
    }

    @Config(value="kafka.cluster-metadata-supplier")
    public KafkaConnectorConfig setClusterMetadataSupplier(String clusterMetadataSupplier) {
        this.clusterMetadataSupplier = clusterMetadataSupplier;
        return this;
    }

    public boolean isHideInternalColumns() {
        return this.hideInternalColumns;
    }

    @Config(value="kafka.hide-internal-columns")
    public KafkaConnectorConfig setHideInternalColumns(boolean hideInternalColumns) {
        this.hideInternalColumns = hideInternalColumns;
        return this;
    }
}

