/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.kafka;

import com.facebook.airlift.bootstrap.Bootstrap;
import com.facebook.airlift.json.JsonModule;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.kafka.KafkaConnector;
import com.facebook.presto.kafka.KafkaConnectorId;
import com.facebook.presto.kafka.KafkaConnectorModule;
import com.facebook.presto.kafka.KafkaHandleResolver;
import com.facebook.presto.spi.ConnectorHandleResolver;
import com.facebook.presto.spi.NodeManager;
import com.facebook.presto.spi.connector.Connector;
import com.facebook.presto.spi.connector.ConnectorContext;
import com.facebook.presto.spi.connector.ConnectorFactory;
import com.google.common.base.Throwables;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.Map;
import java.util.Objects;

public class KafkaConnectorFactory
implements ConnectorFactory {
    private final Module extension;

    KafkaConnectorFactory(Module extension) {
        this.extension = Objects.requireNonNull(extension, "extension is null");
    }

    public String getName() {
        return "kafka";
    }

    public ConnectorHandleResolver getHandleResolver() {
        return new KafkaHandleResolver();
    }

    public Connector create(String catalogName, Map<String, String> config, ConnectorContext context) {
        Objects.requireNonNull(catalogName, "catalogName is null");
        Objects.requireNonNull(config, "config is null");
        try {
            Bootstrap app = new Bootstrap(new Module[]{this.extension, new JsonModule(), new KafkaConnectorModule(), binder -> {
                binder.bind(KafkaConnectorId.class).toInstance((Object)new KafkaConnectorId(catalogName));
                binder.bind(TypeManager.class).toInstance((Object)context.getTypeManager());
                binder.bind(NodeManager.class).toInstance((Object)context.getNodeManager());
            }});
            Injector injector = app.doNotInitializeLogging().setRequiredConfigurationProperties(config).initialize();
            return (Connector)injector.getInstance(KafkaConnector.class);
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

