/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.kafka;

import com.facebook.airlift.log.Logger;
import com.facebook.presto.kafka.KafkaConnectorConfig;
import com.facebook.presto.kafka.KafkaPlugin;
import com.facebook.presto.spi.HostAddress;
import com.facebook.presto.spi.classloader.ThreadContextClassLoader;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.Properties;
import javax.inject.Inject;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.serialization.ByteBufferDeserializer;
import org.apache.kafka.common.serialization.Deserializer;

public class KafkaConsumerManager {
    private static final Logger log = Logger.get(KafkaConsumerManager.class);
    private final int maxPartitionFetchBytes;
    private final int maxPollRecords;

    @Inject
    public KafkaConsumerManager(KafkaConnectorConfig kafkaConnectorConfig) {
        Objects.requireNonNull(kafkaConnectorConfig, "kafkaConfig is null");
        this.maxPartitionFetchBytes = kafkaConnectorConfig.getMaxPartitionFetchBytes();
        this.maxPollRecords = kafkaConnectorConfig.getMaxPollRecords();
    }

    KafkaConsumer<ByteBuffer, ByteBuffer> createConsumer(String threadName, HostAddress hostAddress) {
        Properties properties = new Properties();
        properties.put("bootstrap.servers", hostAddress.toString());
        properties.put("group.id", threadName);
        properties.put("max.poll.records", Integer.toString(this.maxPollRecords));
        properties.put("max.partition.fetch.bytes", (Object)this.maxPartitionFetchBytes);
        properties.put("client.id", String.format("%s-%s", threadName, hostAddress.toString()));
        properties.put("enable.auto.commit", (Object)false);
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(KafkaPlugin.class.getClassLoader());){
            log.debug("Creating KafkaConsumer for thread %s broker %s", new Object[]{threadName, hostAddress.toString()});
            KafkaConsumer kafkaConsumer = new KafkaConsumer(properties, (Deserializer)new ByteBufferDeserializer(), (Deserializer)new ByteBufferDeserializer());
            return kafkaConsumer;
        }
    }
}

