/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.kafka;

import com.facebook.presto.kafka.KafkaColumnHandle;
import com.facebook.presto.spi.ConnectorInsertTableHandle;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.SchemaTableName;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class KafkaTableHandle
implements ConnectorTableHandle,
ConnectorInsertTableHandle {
    private final String connectorId;
    private final String schemaName;
    private final String tableName;
    private final String topicName;
    private final String keyDataFormat;
    private final String messageDataFormat;
    private final Optional<String> keyDataSchemaLocation;
    private final Optional<String> messageDataSchemaLocation;
    private final List<KafkaColumnHandle> columns;

    @JsonCreator
    public KafkaTableHandle(@JsonProperty(value="connectorId") String connectorId, @JsonProperty(value="schemaName") String schemaName, @JsonProperty(value="tableName") String tableName, @JsonProperty(value="topicName") String topicName, @JsonProperty(value="keyDataFormat") String keyDataFormat, @JsonProperty(value="messageDataFormat") String messageDataFormat, @JsonProperty(value="keyDataSchemaLocation") Optional<String> keyDataSchemaLocation, @JsonProperty(value="messageDataSchemaLocation") Optional<String> messageDataSchemaLocation, @JsonProperty(value="columns") List<KafkaColumnHandle> columns) {
        this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null");
        this.schemaName = Objects.requireNonNull(schemaName, "schemaName is null");
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        this.topicName = Objects.requireNonNull(topicName, "topicName is null");
        this.keyDataFormat = Objects.requireNonNull(keyDataFormat, "keyDataFormat is null");
        this.messageDataFormat = Objects.requireNonNull(messageDataFormat, "messageDataFormat is null");
        this.keyDataSchemaLocation = Objects.requireNonNull(keyDataSchemaLocation, "keyDataSchemaLocation is null");
        this.messageDataSchemaLocation = Objects.requireNonNull(messageDataSchemaLocation, "messageDataSchemaLocation is null");
        this.columns = (List)Objects.requireNonNull(ImmutableList.copyOf(columns), "columns is null");
    }

    @JsonProperty
    public String getConnectorId() {
        return this.connectorId;
    }

    @JsonProperty
    public String getSchemaName() {
        return this.schemaName;
    }

    @JsonProperty
    public String getTableName() {
        return this.tableName;
    }

    @JsonProperty
    public String getTopicName() {
        return this.topicName;
    }

    @JsonProperty
    public String getKeyDataFormat() {
        return this.keyDataFormat;
    }

    @JsonProperty
    public String getMessageDataFormat() {
        return this.messageDataFormat;
    }

    @JsonProperty
    public Optional<String> getMessageDataSchemaLocation() {
        return this.messageDataSchemaLocation;
    }

    @JsonProperty
    public Optional<String> getKeyDataSchemaLocation() {
        return this.keyDataSchemaLocation;
    }

    @JsonProperty
    public List<KafkaColumnHandle> getColumns() {
        return this.columns;
    }

    public SchemaTableName toSchemaTableName() {
        return new SchemaTableName(this.schemaName, this.tableName);
    }

    public int hashCode() {
        return Objects.hash(this.connectorId, this.schemaName, this.tableName, this.topicName, this.keyDataFormat, this.messageDataFormat, this.keyDataSchemaLocation, this.messageDataSchemaLocation, this.columns);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        KafkaTableHandle other = (KafkaTableHandle)obj;
        return Objects.equals(this.connectorId, other.connectorId) && Objects.equals(this.schemaName, other.schemaName) && Objects.equals(this.tableName, other.tableName) && Objects.equals(this.topicName, other.topicName) && Objects.equals(this.keyDataFormat, other.keyDataFormat) && Objects.equals(this.messageDataFormat, other.messageDataFormat) && Objects.equals(this.keyDataSchemaLocation, other.keyDataSchemaLocation) && Objects.equals(this.messageDataSchemaLocation, other.messageDataSchemaLocation) && Objects.equals(this.columns, other.columns);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("connectorId", (Object)this.connectorId).add("schemaName", (Object)this.schemaName).add("tableName", (Object)this.tableName).add("topicName", (Object)this.topicName).add("keyDataFormat", (Object)this.keyDataFormat).add("messageDataFormat", (Object)this.messageDataFormat).add("keyDataSchemaLocation", this.keyDataSchemaLocation).add("messageDataSchemaLocation", this.messageDataSchemaLocation).add("columns", this.columns).toString();
    }
}

