/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.kafka.encoder.avro;

import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.RealType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.Varchars;
import com.facebook.presto.kafka.encoder.AbstractRowEncoder;
import com.facebook.presto.kafka.encoder.EncoderColumnHandle;
import com.facebook.presto.spi.ConnectorSession;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.DatumWriter;

public class AvroRowEncoder
extends AbstractRowEncoder {
    private static final Set<Type> SUPPORTED_PRIMITIVE_TYPES = ImmutableSet.of((Object)BooleanType.BOOLEAN, (Object)IntegerType.INTEGER, (Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE, (Object)RealType.REAL);
    public static final String NAME = "avro";
    private final ByteArrayOutputStream byteArrayOutputStream;
    private final Schema parsedSchema;
    private final DataFileWriter<GenericRecord> dataFileWriter;
    private final GenericRecord record;

    public AvroRowEncoder(ConnectorSession session, List<EncoderColumnHandle> columnHandles, Schema parsedSchema) {
        super(session, columnHandles);
        for (EncoderColumnHandle columnHandle : this.columnHandles) {
            Preconditions.checkArgument((columnHandle.getFormatHint() == null ? 1 : 0) != 0, (String)"Unexpected format hint '%s' defined for column '%s'", (Object)columnHandle.getFormatHint(), (Object)columnHandle.getName());
            Preconditions.checkArgument((columnHandle.getDataFormat() == null ? 1 : 0) != 0, (String)"Unexpected data format '%s' defined for column '%s'", (Object)columnHandle.getDataFormat(), (Object)columnHandle.getName());
            Preconditions.checkArgument((boolean)this.isSupportedType(columnHandle.getType()), (String)"Unsupported column type '%s' for column '%s'", (Object)columnHandle.getType(), (Object)columnHandle.getName());
        }
        this.byteArrayOutputStream = new ByteArrayOutputStream();
        this.parsedSchema = Objects.requireNonNull(parsedSchema, "parsedSchema is null");
        this.dataFileWriter = new DataFileWriter((DatumWriter)new GenericDatumWriter(this.parsedSchema));
        this.record = new GenericData.Record(this.parsedSchema);
    }

    private boolean isSupportedType(Type type) {
        return Varchars.isVarcharType((Type)type) || SUPPORTED_PRIMITIVE_TYPES.contains(type);
    }

    @Override
    protected void appendNullValue() {
        this.record.put(((EncoderColumnHandle)this.columnHandles.get(this.currentColumnIndex)).getName(), null);
    }

    @Override
    protected void appendLong(long value) {
        this.record.put(((EncoderColumnHandle)this.columnHandles.get(this.currentColumnIndex)).getName(), (Object)value);
    }

    @Override
    protected void appendInt(int value) {
        this.record.put(((EncoderColumnHandle)this.columnHandles.get(this.currentColumnIndex)).getName(), (Object)value);
    }

    @Override
    protected void appendShort(short value) {
        this.record.put(((EncoderColumnHandle)this.columnHandles.get(this.currentColumnIndex)).getName(), (Object)value);
    }

    @Override
    protected void appendByte(byte value) {
        this.record.put(((EncoderColumnHandle)this.columnHandles.get(this.currentColumnIndex)).getName(), (Object)value);
    }

    @Override
    protected void appendDouble(double value) {
        this.record.put(((EncoderColumnHandle)this.columnHandles.get(this.currentColumnIndex)).getName(), (Object)value);
    }

    @Override
    protected void appendFloat(float value) {
        this.record.put(((EncoderColumnHandle)this.columnHandles.get(this.currentColumnIndex)).getName(), (Object)Float.valueOf(value));
    }

    @Override
    protected void appendBoolean(boolean value) {
        this.record.put(((EncoderColumnHandle)this.columnHandles.get(this.currentColumnIndex)).getName(), (Object)value);
    }

    @Override
    protected void appendString(String value) {
        this.record.put(((EncoderColumnHandle)this.columnHandles.get(this.currentColumnIndex)).getName(), (Object)value);
    }

    @Override
    public byte[] toByteArray() {
        Preconditions.checkArgument((this.currentColumnIndex == this.columnHandles.size() ? 1 : 0) != 0, (Object)String.format("Missing %d columns", this.columnHandles.size() - this.currentColumnIndex + 1));
        try {
            this.byteArrayOutputStream.reset();
            this.dataFileWriter.create(this.parsedSchema, (OutputStream)this.byteArrayOutputStream);
            this.dataFileWriter.append((Object)this.record);
            this.dataFileWriter.close();
            this.resetColumnIndex();
            return this.byteArrayOutputStream.toByteArray();
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to append record", e);
        }
    }

    @Override
    public void close() {
        try {
            this.byteArrayOutputStream.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to close ByteArrayOutputStream", e);
        }
    }
}

