/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.kafka.encoder.avro;

import com.facebook.presto.kafka.encoder.EncoderColumnHandle;
import com.facebook.presto.kafka.encoder.RowEncoder;
import com.facebook.presto.kafka.encoder.RowEncoderFactory;
import com.facebook.presto.kafka.encoder.avro.AvroRowEncoder;
import com.facebook.presto.spi.ConnectorSession;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.avro.Schema;

public class AvroRowEncoderFactory
implements RowEncoderFactory {
    @Override
    public RowEncoder create(ConnectorSession session, Optional<String> dataSchema, List<EncoderColumnHandle> columnHandles) {
        Preconditions.checkArgument((boolean)dataSchema.isPresent(), (Object)"dataSchema for Avro format is not present");
        Schema parsedSchema = new Schema.Parser().parse(Objects.requireNonNull(dataSchema.get(), "dataSchema is null"));
        return new AvroRowEncoder(session, columnHandles, parsedSchema);
    }
}

