/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.kafka.encoder.csv;

import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.RealType;
import com.facebook.presto.common.type.SmallintType;
import com.facebook.presto.common.type.TinyintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.Varchars;
import com.facebook.presto.kafka.encoder.AbstractRowEncoder;
import com.facebook.presto.kafka.encoder.EncoderColumnHandle;
import com.facebook.presto.spi.ConnectorSession;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;

public class CsvRowEncoder
extends AbstractRowEncoder {
    private static final Set<Type> SUPPORTED_PRIMITIVE_TYPES = ImmutableSet.of((Object)BooleanType.BOOLEAN, (Object)TinyintType.TINYINT, (Object)SmallintType.SMALLINT, (Object)IntegerType.INTEGER, (Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE, (Object[])new Type[]{RealType.REAL});
    public static final String NAME = "csv";
    private final String[] row;

    public CsvRowEncoder(ConnectorSession session, List<EncoderColumnHandle> columnHandles) {
        super(session, columnHandles);
        for (EncoderColumnHandle columnHandle : this.columnHandles) {
            Preconditions.checkArgument((columnHandle.getFormatHint() == null ? 1 : 0) != 0, (String)"Unexpected format hint '%s' defined for column '%s'", (Object)columnHandle.getFormatHint(), (Object)columnHandle.getName());
            Preconditions.checkArgument((columnHandle.getDataFormat() == null ? 1 : 0) != 0, (String)"Unexpected data format '%s' defined for column '%s'", (Object)columnHandle.getDataFormat(), (Object)columnHandle.getName());
            Preconditions.checkArgument((boolean)this.isSupportedType(columnHandle.getType()), (String)"Unsupported column type '%s' for column '%s'", (Object)columnHandle.getType(), (Object)columnHandle.getName());
        }
        this.row = new String[this.columnHandles.size()];
    }

    private boolean isSupportedType(Type type) {
        return Varchars.isVarcharType((Type)type) || SUPPORTED_PRIMITIVE_TYPES.contains(type);
    }

    @Override
    protected void appendNullValue() {
        this.row[this.currentColumnIndex] = null;
    }

    @Override
    protected void appendLong(long value) {
        this.row[this.currentColumnIndex] = Long.toString(value);
    }

    @Override
    protected void appendInt(int value) {
        this.row[this.currentColumnIndex] = Integer.toString(value);
    }

    @Override
    protected void appendShort(short value) {
        this.row[this.currentColumnIndex] = Short.toString(value);
    }

    @Override
    protected void appendByte(byte value) {
        this.row[this.currentColumnIndex] = Byte.toString(value);
    }

    @Override
    protected void appendDouble(double value) {
        this.row[this.currentColumnIndex] = Double.toString(value);
    }

    @Override
    protected void appendFloat(float value) {
        this.row[this.currentColumnIndex] = Float.toString(value);
    }

    @Override
    protected void appendBoolean(boolean value) {
        this.row[this.currentColumnIndex] = Boolean.toString(value);
    }

    @Override
    protected void appendString(String value) {
        this.row[this.currentColumnIndex] = value;
    }

    /*
     * Exception decompiling
     */
    @Override
    public byte[] toByteArray() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

