/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.kafka.encoder.json;

import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.SmallintType;
import com.facebook.presto.common.type.TinyintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.Varchars;
import com.facebook.presto.kafka.encoder.AbstractRowEncoder;
import com.facebook.presto.kafka.encoder.EncoderColumnHandle;
import com.facebook.presto.spi.ConnectorSession;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class JsonRowEncoder
extends AbstractRowEncoder {
    private static final Set<Type> PRIMITIVE_SUPPORTED_TYPES = ImmutableSet.of((Object)BigintType.BIGINT, (Object)IntegerType.INTEGER, (Object)SmallintType.SMALLINT, (Object)TinyintType.TINYINT, (Object)DoubleType.DOUBLE, (Object)BooleanType.BOOLEAN, (Object[])new Type[0]);
    public static final String NAME = "json";
    private final ObjectMapper objectMapper;
    private final ObjectNode node;

    JsonRowEncoder(ConnectorSession session, List<EncoderColumnHandle> columnHandles, ObjectMapper objectMapper) {
        super(session, columnHandles);
        for (EncoderColumnHandle columnHandle : this.columnHandles) {
            Preconditions.checkArgument((boolean)this.isSupportedType(columnHandle.getType()), (String)"Unsupported column type '%s' for column '%s'", (Object)columnHandle.getType(), (Object)columnHandle.getName());
            Preconditions.checkArgument((columnHandle.getFormatHint() == null ? 1 : 0) != 0, (String)"Unexpected format hint '%s' defined for column '%s'", (Object)columnHandle.getFormatHint(), (Object)columnHandle.getName());
            Preconditions.checkArgument((columnHandle.getDataFormat() == null ? 1 : 0) != 0, (String)"Unexpected data format '%s' defined for column '%s'", (Object)columnHandle.getDataFormat(), (Object)columnHandle.getName());
        }
        this.objectMapper = Objects.requireNonNull(objectMapper, "objectMapper is null");
        this.node = objectMapper.createObjectNode();
    }

    private boolean isSupportedType(Type type) {
        return Varchars.isVarcharType((Type)type) || PRIMITIVE_SUPPORTED_TYPES.contains(type);
    }

    private String currentColumnName() {
        return ((EncoderColumnHandle)this.columnHandles.get(this.currentColumnIndex)).getName();
    }

    @Override
    protected void appendNullValue() {
        this.node.putNull(this.currentColumnName());
    }

    @Override
    protected void appendLong(long value) {
        this.node.put(this.currentColumnName(), value);
    }

    @Override
    protected void appendInt(int value) {
        this.node.put(this.currentColumnName(), value);
    }

    @Override
    protected void appendShort(short value) {
        this.node.put(this.currentColumnName(), value);
    }

    @Override
    protected void appendByte(byte value) {
        this.node.put(this.currentColumnName(), (short)value);
    }

    @Override
    protected void appendDouble(double value) {
        this.node.put(this.currentColumnName(), value);
    }

    @Override
    protected void appendFloat(float value) {
        this.node.put(this.currentColumnName(), value);
    }

    @Override
    protected void appendBoolean(boolean value) {
        this.node.put(this.currentColumnName(), value);
    }

    @Override
    protected void appendString(String value) {
        this.node.put(this.currentColumnName(), value);
    }

    @Override
    protected void appendByteBuffer(ByteBuffer value) {
        this.node.put(this.currentColumnName(), value.array());
    }

    @Override
    public byte[] toByteArray() {
        Preconditions.checkArgument((this.currentColumnIndex == this.columnHandles.size() ? 1 : 0) != 0, (Object)String.format("Missing %d columns", this.columnHandles.size() - this.currentColumnIndex + 1));
        try {
            this.resetColumnIndex();
            return this.objectMapper.writeValueAsBytes((Object)this.node);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }
}

