/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.kafka.server.file;

import com.facebook.airlift.configuration.Config;
import com.facebook.presto.spi.HostAddress;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.List;

public class FileKafkaClusterMetadataSupplierConfig {
    private static final int KAFKA_DEFAULT_PORT = 9092;
    private List<HostAddress> nodes;

    public List<HostAddress> getNodes() {
        return this.nodes;
    }

    @Config(value="kafka.nodes")
    public FileKafkaClusterMetadataSupplierConfig setNodes(String nodes) {
        this.nodes = nodes == null ? null : FileKafkaClusterMetadataSupplierConfig.parseNodes(nodes).asList();
        return this;
    }

    public static ImmutableSet<HostAddress> parseNodes(String nodes) {
        Splitter splitter = Splitter.on((char)',').omitEmptyStrings().trimResults();
        return ImmutableSet.copyOf((Iterable)Iterables.transform((Iterable)splitter.split((CharSequence)nodes), FileKafkaClusterMetadataSupplierConfig::toHostAddress));
    }

    private static HostAddress toHostAddress(String value) {
        return HostAddress.fromString((String)value).withDefaultPort(9092);
    }
}

