/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.kudu;

import com.facebook.airlift.log.Logger;
import com.facebook.presto.common.predicate.DiscreteValues;
import com.facebook.presto.common.predicate.Domain;
import com.facebook.presto.common.predicate.EquatableValueSet;
import com.facebook.presto.common.predicate.Marker;
import com.facebook.presto.common.predicate.Range;
import com.facebook.presto.common.predicate.Ranges;
import com.facebook.presto.common.predicate.SortedRangeSet;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.predicate.ValueSet;
import com.facebook.presto.common.type.DecimalType;
import com.facebook.presto.kudu.KuduColumnHandle;
import com.facebook.presto.kudu.KuduConnectorId;
import com.facebook.presto.kudu.KuduSplit;
import com.facebook.presto.kudu.KuduTableHandle;
import com.facebook.presto.kudu.KuduTableLayoutHandle;
import com.facebook.presto.kudu.KuduUtil;
import com.facebook.presto.kudu.RangePartitionChange;
import com.facebook.presto.kudu.TypeHelper;
import com.facebook.presto.kudu.properties.ColumnDesign;
import com.facebook.presto.kudu.properties.HashPartitionDefinition;
import com.facebook.presto.kudu.properties.KuduTableProperties;
import com.facebook.presto.kudu.properties.PartitionDesign;
import com.facebook.presto.kudu.properties.RangePartition;
import com.facebook.presto.kudu.properties.RangePartitionDefinition;
import com.facebook.presto.kudu.schema.SchemaEmulation;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.SchemaNotFoundException;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.TableNotFoundException;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.kudu.ColumnSchema;
import org.apache.kudu.ColumnTypeAttributes;
import org.apache.kudu.Schema;
import org.apache.kudu.Type;
import org.apache.kudu.client.AlterTableOptions;
import org.apache.kudu.client.CreateTableOptions;
import org.apache.kudu.client.KuduClient;
import org.apache.kudu.client.KuduException;
import org.apache.kudu.client.KuduPredicate;
import org.apache.kudu.client.KuduScanToken;
import org.apache.kudu.client.KuduScanner;
import org.apache.kudu.client.KuduSession;
import org.apache.kudu.client.KuduTable;
import org.apache.kudu.client.PartialRow;

public class KuduClientSession {
    public static final String DEFAULT_SCHEMA = "default";
    private final Logger log = Logger.get(this.getClass());
    private final KuduConnectorId connectorId;
    private final KuduClient client;
    private final SchemaEmulation schemaEmulation;
    private final boolean kerberosAuthEnabled;

    public KuduClientSession(KuduConnectorId connectorId, KuduClient client, SchemaEmulation schemaEmulation, boolean kerberosAuthEnabled) {
        this.connectorId = connectorId;
        this.client = client;
        this.schemaEmulation = schemaEmulation;
        this.kerberosAuthEnabled = kerberosAuthEnabled;
    }

    public List<String> listSchemaNames() {
        KuduUtil.reTryKerberos(this.kerberosAuthEnabled);
        return this.schemaEmulation.listSchemaNames(this.client);
    }

    private List<String> internalListTables(String prefix) {
        try {
            if (prefix.isEmpty()) {
                return this.client.getTablesList().getTablesList();
            }
            return this.client.getTablesList(prefix).getTablesList();
        }
        catch (KuduException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, (Throwable)e);
        }
    }

    public List<SchemaTableName> listTables(Optional<String> optSchemaName) {
        KuduUtil.reTryKerberos(this.kerberosAuthEnabled);
        if (optSchemaName.isPresent()) {
            return this.listTablesSingleSchema(optSchemaName.get());
        }
        ArrayList<SchemaTableName> all = new ArrayList<SchemaTableName>();
        for (String schemaName : this.listSchemaNames()) {
            List<SchemaTableName> single = this.listTablesSingleSchema(schemaName);
            all.addAll(single);
        }
        return all;
    }

    private List<SchemaTableName> listTablesSingleSchema(String schemaName) {
        String prefix = this.schemaEmulation.getPrefixForTablesOfSchema(schemaName);
        List<String> tables = this.internalListTables(prefix);
        return (List)tables.stream().map(this.schemaEmulation::fromRawName).filter(Objects::nonNull).collect(ImmutableList.toImmutableList());
    }

    public Schema getTableSchema(KuduTableHandle tableHandle) {
        KuduUtil.reTryKerberos(this.kerberosAuthEnabled);
        KuduTable table = tableHandle.getTable(this);
        return table.getSchema();
    }

    public Map<String, Object> getTableProperties(KuduTableHandle tableHandle) {
        KuduUtil.reTryKerberos(this.kerberosAuthEnabled);
        KuduTable table = tableHandle.getTable(this);
        return KuduTableProperties.toMap(table);
    }

    public List<KuduSplit> buildKuduSplits(KuduTableLayoutHandle layoutHandle) {
        KuduUtil.reTryKerberos(this.kerberosAuthEnabled);
        KuduTableHandle tableHandle = layoutHandle.getTableHandle();
        KuduTable table = tableHandle.getTable(this);
        int primaryKeyColumnCount = table.getSchema().getPrimaryKeyColumnCount();
        KuduScanToken.KuduScanTokenBuilder builder = this.client.newScanTokenBuilder(table);
        TupleDomain<ColumnHandle> constraintSummary = layoutHandle.getConstraintSummary();
        if (!this.addConstraintPredicates(table, builder, constraintSummary)) {
            return ImmutableList.of();
        }
        Optional<Set<ColumnHandle>> desiredColumns = layoutHandle.getDesiredColumns();
        if (desiredColumns.isPresent()) {
            List columnIndexes;
            if (desiredColumns.get().contains(KuduColumnHandle.ROW_ID_HANDLE)) {
                columnIndexes = IntStream.range(0, primaryKeyColumnCount).boxed().collect(Collectors.toList());
                for (ColumnHandle columnHandle : desiredColumns.get()) {
                    KuduColumnHandle k;
                    int index;
                    if (!(columnHandle instanceof KuduColumnHandle) || (index = (k = (KuduColumnHandle)columnHandle).getOrdinalPosition()) < primaryKeyColumnCount) continue;
                    columnIndexes.add(index);
                }
                builder.setProjectedColumnIndexes(columnIndexes);
            } else {
                columnIndexes = (List)desiredColumns.get().stream().map(handle -> ((KuduColumnHandle)handle).getOrdinalPosition()).collect(ImmutableList.toImmutableList());
                builder.setProjectedColumnIndexes(columnIndexes);
            }
        }
        List tokens = builder.build();
        return (List)tokens.stream().map(token -> this.toKuduSplit(tableHandle, (KuduScanToken)token, primaryKeyColumnCount)).collect(ImmutableList.toImmutableList());
    }

    public KuduScanner createScanner(KuduSplit kuduSplit) {
        KuduUtil.reTryKerberos(this.kerberosAuthEnabled);
        try {
            return KuduScanToken.deserializeIntoScanner((byte[])kuduSplit.getSerializedScanToken(), (KuduClient)this.client);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public KuduTable openTable(SchemaTableName schemaTableName) {
        KuduUtil.reTryKerberos(this.kerberosAuthEnabled);
        String rawName = this.schemaEmulation.toRawName(schemaTableName);
        try {
            return this.client.openTable(rawName);
        }
        catch (KuduException e) {
            this.log.debug("Error on doOpenTable: " + (Object)((Object)e), new Object[]{e});
            if (!this.listSchemaNames().contains(schemaTableName.getSchemaName())) {
                throw new SchemaNotFoundException(schemaTableName.getSchemaName());
            }
            throw new TableNotFoundException(schemaTableName);
        }
    }

    public KuduSession newSession() {
        KuduUtil.reTryKerberos(this.kerberosAuthEnabled);
        return this.client.newSession();
    }

    public void createSchema(String schemaName) {
        KuduUtil.reTryKerberos(this.kerberosAuthEnabled);
        this.schemaEmulation.createSchema(this.client, schemaName);
    }

    public void dropSchema(String schemaName) {
        KuduUtil.reTryKerberos(this.kerberosAuthEnabled);
        this.schemaEmulation.dropSchema(this.client, schemaName);
    }

    public void dropTable(SchemaTableName schemaTableName) {
        KuduUtil.reTryKerberos(this.kerberosAuthEnabled);
        try {
            String rawName = this.schemaEmulation.toRawName(schemaTableName);
            this.client.deleteTable(rawName);
        }
        catch (KuduException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, (Throwable)e);
        }
    }

    public void renameTable(SchemaTableName schemaTableName, SchemaTableName newSchemaTableName) {
        KuduUtil.reTryKerberos(this.kerberosAuthEnabled);
        try {
            String rawName = this.schemaEmulation.toRawName(schemaTableName);
            String newRawName = this.schemaEmulation.toRawName(newSchemaTableName);
            AlterTableOptions alterOptions = new AlterTableOptions();
            alterOptions.renameTable(newRawName);
            this.client.alterTable(rawName, alterOptions);
        }
        catch (KuduException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, (Throwable)e);
        }
    }

    public KuduTable createTable(ConnectorTableMetadata tableMetadata, boolean ignoreExisting) {
        KuduUtil.reTryKerberos(this.kerberosAuthEnabled);
        try {
            String rawName = this.schemaEmulation.toRawName(tableMetadata.getTable());
            if (ignoreExisting && this.client.tableExists(rawName)) {
                return null;
            }
            if (!this.schemaEmulation.existsSchema(this.client, tableMetadata.getTable().getSchemaName())) {
                throw new SchemaNotFoundException(tableMetadata.getTable().getSchemaName());
            }
            List columns = tableMetadata.getColumns();
            Map properties = tableMetadata.getProperties();
            Schema schema = this.buildSchema(columns, properties);
            CreateTableOptions options = this.buildCreateTableOptions(schema, properties);
            return this.client.createTable(rawName, schema, options);
        }
        catch (KuduException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, (Throwable)e);
        }
    }

    public void addColumn(SchemaTableName schemaTableName, ColumnMetadata column) {
        KuduUtil.reTryKerberos(this.kerberosAuthEnabled);
        try {
            String rawName = this.schemaEmulation.toRawName(schemaTableName);
            AlterTableOptions alterOptions = new AlterTableOptions();
            Type type = TypeHelper.toKuduClientType(column.getType());
            alterOptions.addNullableColumn(column.getName(), type);
            this.client.alterTable(rawName, alterOptions);
        }
        catch (KuduException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, (Throwable)e);
        }
    }

    public void dropColumn(SchemaTableName schemaTableName, String name) {
        KuduUtil.reTryKerberos(this.kerberosAuthEnabled);
        try {
            String rawName = this.schemaEmulation.toRawName(schemaTableName);
            AlterTableOptions alterOptions = new AlterTableOptions();
            alterOptions.dropColumn(name);
            this.client.alterTable(rawName, alterOptions);
        }
        catch (KuduException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, (Throwable)e);
        }
    }

    public void renameColumn(SchemaTableName schemaTableName, String oldName, String newName) {
        KuduUtil.reTryKerberos(this.kerberosAuthEnabled);
        try {
            String rawName = this.schemaEmulation.toRawName(schemaTableName);
            AlterTableOptions alterOptions = new AlterTableOptions();
            alterOptions.renameColumn(oldName, newName);
            this.client.alterTable(rawName, alterOptions);
        }
        catch (KuduException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, (Throwable)e);
        }
    }

    public void addRangePartition(SchemaTableName schemaTableName, RangePartition rangePartition) {
        KuduUtil.reTryKerberos(this.kerberosAuthEnabled);
        this.changeRangePartition(schemaTableName, rangePartition, RangePartitionChange.ADD);
    }

    public void dropRangePartition(SchemaTableName schemaTableName, RangePartition rangePartition) {
        KuduUtil.reTryKerberos(this.kerberosAuthEnabled);
        this.changeRangePartition(schemaTableName, rangePartition, RangePartitionChange.DROP);
    }

    private void changeRangePartition(SchemaTableName schemaTableName, RangePartition rangePartition, RangePartitionChange change) {
        try {
            String rawName = this.schemaEmulation.toRawName(schemaTableName);
            KuduTable table = this.client.openTable(rawName);
            Schema schema = table.getSchema();
            PartitionDesign design = KuduTableProperties.getPartitionDesign(table);
            RangePartitionDefinition definition = design.getRange();
            if (definition == null) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.QUERY_REJECTED, "Table " + schemaTableName + " has no range partition");
            }
            PartialRow lowerBound = KuduTableProperties.toRangeBoundToPartialRow(schema, definition, rangePartition.getLower());
            PartialRow upperBound = KuduTableProperties.toRangeBoundToPartialRow(schema, definition, rangePartition.getUpper());
            AlterTableOptions alterOptions = new AlterTableOptions();
            switch (change) {
                case ADD: {
                    alterOptions.addRangePartition(lowerBound, upperBound);
                    break;
                }
                case DROP: {
                    alterOptions.dropRangePartition(lowerBound, upperBound);
                }
            }
            this.client.alterTable(rawName, alterOptions);
        }
        catch (KuduException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, (Throwable)e);
        }
    }

    private Schema buildSchema(List<ColumnMetadata> columns, Map<String, Object> tableProperties) {
        List kuduColumns = (List)columns.stream().map(this::toColumnSchema).collect(ImmutableList.toImmutableList());
        return new Schema(kuduColumns);
    }

    private ColumnSchema toColumnSchema(ColumnMetadata columnMetadata) {
        String name = columnMetadata.getName();
        ColumnDesign design = KuduTableProperties.getColumnDesign(columnMetadata.getProperties());
        Type ktype = TypeHelper.toKuduClientType(columnMetadata.getType());
        ColumnSchema.ColumnSchemaBuilder builder = new ColumnSchema.ColumnSchemaBuilder(name, ktype);
        builder.key(design.isPrimaryKey()).nullable(design.isNullable());
        this.setEncoding(name, builder, design);
        this.setCompression(name, builder, design);
        this.setTypeAttributes(columnMetadata, builder);
        return builder.build();
    }

    private void setTypeAttributes(ColumnMetadata columnMetadata, ColumnSchema.ColumnSchemaBuilder builder) {
        if (columnMetadata.getType() instanceof DecimalType) {
            DecimalType type = (DecimalType)columnMetadata.getType();
            ColumnTypeAttributes attributes = new ColumnTypeAttributes.ColumnTypeAttributesBuilder().precision(type.getPrecision()).scale(type.getScale()).build();
            builder.typeAttributes(attributes);
        }
    }

    private void setCompression(String name, ColumnSchema.ColumnSchemaBuilder builder, ColumnDesign design) {
        if (design.getCompression() != null) {
            try {
                ColumnSchema.CompressionAlgorithm algorithm = KuduTableProperties.lookupCompression(design.getCompression());
                builder.compressionAlgorithm(algorithm);
            }
            catch (IllegalArgumentException e) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Unknown compression algorithm " + design.getCompression() + " for column " + name);
            }
        }
    }

    private void setEncoding(String name, ColumnSchema.ColumnSchemaBuilder builder, ColumnDesign design) {
        if (design.getEncoding() != null) {
            try {
                ColumnSchema.Encoding encoding = KuduTableProperties.lookupEncoding(design.getEncoding());
                builder.encoding(encoding);
            }
            catch (IllegalArgumentException e) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Unknown encoding " + design.getEncoding() + " for column " + name);
            }
        }
    }

    private CreateTableOptions buildCreateTableOptions(Schema schema, Map<String, Object> properties) {
        CreateTableOptions options = new CreateTableOptions();
        RangePartitionDefinition rangePartitionDefinition = null;
        PartitionDesign partitionDesign = KuduTableProperties.getPartitionDesign(properties);
        if (partitionDesign.getHash() != null) {
            for (HashPartitionDefinition hashPartitionDefinition : partitionDesign.getHash()) {
                options.addHashPartitions(hashPartitionDefinition.getColumns(), hashPartitionDefinition.getBuckets());
            }
        }
        if (partitionDesign.getRange() != null) {
            rangePartitionDefinition = partitionDesign.getRange();
            options.setRangePartitionColumns(rangePartitionDefinition.getColumns());
        }
        List<RangePartition> rangePartitions = KuduTableProperties.getRangePartitions(properties);
        if (rangePartitionDefinition != null && !rangePartitions.isEmpty()) {
            for (RangePartition rangePartition : rangePartitions) {
                PartialRow lower = KuduTableProperties.toRangeBoundToPartialRow(schema, rangePartitionDefinition, rangePartition.getLower());
                PartialRow upper = KuduTableProperties.toRangeBoundToPartialRow(schema, rangePartitionDefinition, rangePartition.getUpper());
                options.addRangePartition(lower, upper);
            }
        }
        Optional<Integer> optional = KuduTableProperties.getNumReplicas(properties);
        optional.ifPresent(arg_0 -> ((CreateTableOptions)options).setNumReplicas(arg_0));
        return options;
    }

    private boolean addConstraintPredicates(KuduTable table, KuduScanToken.KuduScanTokenBuilder builder, TupleDomain<ColumnHandle> constraintSummary) {
        if (constraintSummary.isNone()) {
            return false;
        }
        if (!constraintSummary.isAll()) {
            Schema schema = table.getSchema();
            for (TupleDomain.ColumnDomain columnDomain : (List)constraintSummary.getColumnDomains().get()) {
                int position = ((KuduColumnHandle)columnDomain.getColumn()).getOrdinalPosition();
                ColumnSchema columnSchema = schema.getColumnByIndex(position);
                Domain domain = columnDomain.getDomain();
                if (domain.isNone()) {
                    return false;
                }
                if (domain.isAll()) continue;
                if (domain.isOnlyNull()) {
                    builder.addPredicate(KuduPredicate.newIsNullPredicate((ColumnSchema)columnSchema));
                    continue;
                }
                if (domain.getValues().isAll() && domain.isNullAllowed()) {
                    builder.addPredicate(KuduPredicate.newIsNotNullPredicate((ColumnSchema)columnSchema));
                    continue;
                }
                if (domain.isSingleValue()) {
                    KuduPredicate predicate = this.createEqualsPredicate(columnSchema, domain.getSingleValue());
                    builder.addPredicate(predicate);
                    continue;
                }
                ValueSet valueSet = domain.getValues();
                if (valueSet instanceof EquatableValueSet) {
                    DiscreteValues discreteValues = valueSet.getDiscreteValues();
                    KuduPredicate predicate = this.createInListPredicate(columnSchema, discreteValues);
                    builder.addPredicate(predicate);
                    continue;
                }
                if (valueSet instanceof SortedRangeSet) {
                    Marker high;
                    Ranges ranges = ((SortedRangeSet)valueSet).getRanges();
                    Range span = ranges.getSpan();
                    Marker low = span.getLow();
                    if (!low.isLowerUnbounded()) {
                        KuduPredicate.ComparisonOp op = low.getBound() == Marker.Bound.ABOVE ? KuduPredicate.ComparisonOp.GREATER : KuduPredicate.ComparisonOp.GREATER_EQUAL;
                        KuduPredicate predicate = this.createComparisonPredicate(columnSchema, op, low.getValue());
                        builder.addPredicate(predicate);
                    }
                    if ((high = span.getHigh()).isUpperUnbounded()) continue;
                    KuduPredicate.ComparisonOp op = low.getBound() == Marker.Bound.BELOW ? KuduPredicate.ComparisonOp.LESS : KuduPredicate.ComparisonOp.LESS_EQUAL;
                    KuduPredicate predicate = this.createComparisonPredicate(columnSchema, op, high.getValue());
                    builder.addPredicate(predicate);
                    continue;
                }
                throw new IllegalStateException("Unexpected domain: " + domain);
            }
        }
        return true;
    }

    private KuduPredicate createInListPredicate(ColumnSchema columnSchema, DiscreteValues discreteValues) {
        com.facebook.presto.common.type.Type type = TypeHelper.fromKuduColumn(columnSchema);
        List javaValues = (List)discreteValues.getValues().stream().map(value -> TypeHelper.getJavaValue(type, value)).collect(ImmutableList.toImmutableList());
        return KuduPredicate.newInListPredicate((ColumnSchema)columnSchema, (List)javaValues);
    }

    private KuduPredicate createEqualsPredicate(ColumnSchema columnSchema, Object value) {
        return this.createComparisonPredicate(columnSchema, KuduPredicate.ComparisonOp.EQUAL, value);
    }

    private KuduPredicate createComparisonPredicate(ColumnSchema columnSchema, KuduPredicate.ComparisonOp op, Object value) {
        com.facebook.presto.common.type.Type type = TypeHelper.fromKuduColumn(columnSchema);
        Object javaValue = TypeHelper.getJavaValue(type, value);
        if (javaValue instanceof Long) {
            return KuduPredicate.newComparisonPredicate((ColumnSchema)columnSchema, (KuduPredicate.ComparisonOp)op, (Object)((Long)javaValue));
        }
        if (javaValue instanceof Integer) {
            return KuduPredicate.newComparisonPredicate((ColumnSchema)columnSchema, (KuduPredicate.ComparisonOp)op, (Object)((Integer)javaValue));
        }
        if (javaValue instanceof Short) {
            return KuduPredicate.newComparisonPredicate((ColumnSchema)columnSchema, (KuduPredicate.ComparisonOp)op, (Object)((Short)javaValue));
        }
        if (javaValue instanceof Byte) {
            return KuduPredicate.newComparisonPredicate((ColumnSchema)columnSchema, (KuduPredicate.ComparisonOp)op, (Object)((Byte)javaValue));
        }
        if (javaValue instanceof String) {
            return KuduPredicate.newComparisonPredicate((ColumnSchema)columnSchema, (KuduPredicate.ComparisonOp)op, (String)((String)javaValue));
        }
        if (javaValue instanceof Double) {
            return KuduPredicate.newComparisonPredicate((ColumnSchema)columnSchema, (KuduPredicate.ComparisonOp)op, (Object)((Double)javaValue));
        }
        if (javaValue instanceof Float) {
            return KuduPredicate.newComparisonPredicate((ColumnSchema)columnSchema, (KuduPredicate.ComparisonOp)op, (Object)((Float)javaValue));
        }
        if (javaValue instanceof Boolean) {
            return KuduPredicate.newComparisonPredicate((ColumnSchema)columnSchema, (KuduPredicate.ComparisonOp)op, (Object)((Boolean)javaValue));
        }
        if (javaValue instanceof byte[]) {
            return KuduPredicate.newComparisonPredicate((ColumnSchema)columnSchema, (KuduPredicate.ComparisonOp)op, (byte[])((byte[])javaValue));
        }
        if (javaValue == null) {
            throw new IllegalStateException("Unexpected null java value for column " + columnSchema.getName());
        }
        throw new IllegalStateException("Unexpected java value for column " + columnSchema.getName() + ": " + javaValue + "(" + javaValue.getClass() + ")");
    }

    private KuduSplit toKuduSplit(KuduTableHandle tableHandle, KuduScanToken token, int primaryKeyColumnCount) {
        try {
            byte[] serializedScanToken = token.serialize();
            return new KuduSplit(tableHandle, primaryKeyColumnCount, serializedScanToken);
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, (Throwable)e);
        }
    }
}

