/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.kudu;

import com.facebook.presto.kudu.KuduColumnHandle;
import com.facebook.presto.kudu.KuduRecordSet;
import com.facebook.presto.kudu.KuduRecordSetProvider;
import com.facebook.presto.kudu.KuduUpdatablePageSource;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.RecordPageSource;
import com.facebook.presto.spi.RecordSet;
import com.facebook.presto.spi.SplitContext;
import com.facebook.presto.spi.connector.ConnectorPageSourceProvider;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.google.inject.Inject;
import java.util.List;
import java.util.Objects;

public class KuduPageSourceProvider
implements ConnectorPageSourceProvider {
    private final KuduRecordSetProvider recordSetProvider;

    @Inject
    public KuduPageSourceProvider(KuduRecordSetProvider recordSetProvider) {
        this.recordSetProvider = Objects.requireNonNull(recordSetProvider, "recordSetProvider is null");
    }

    public ConnectorPageSource createPageSource(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorSplit split, List<ColumnHandle> columns, SplitContext splitContext) {
        KuduRecordSet recordSet = (KuduRecordSet)this.recordSetProvider.getRecordSet(transactionHandle, session, split, columns);
        if (columns.contains(KuduColumnHandle.ROW_ID_HANDLE)) {
            return new KuduUpdatablePageSource(recordSet);
        }
        return new RecordPageSource((RecordSet)recordSet);
    }
}

