/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.kudu;

import com.facebook.presto.kudu.KuduClientSession;
import com.facebook.presto.kudu.KuduConnectorId;
import com.facebook.presto.kudu.KuduRecordSet;
import com.facebook.presto.kudu.KuduSplit;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.RecordSet;
import com.facebook.presto.spi.connector.ConnectorRecordSetProvider;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;

public class KuduRecordSetProvider
implements ConnectorRecordSetProvider {
    private final String connectorId;
    private final KuduClientSession clientSession;

    @Inject
    public KuduRecordSetProvider(KuduConnectorId connectorId, KuduClientSession clientSession) {
        this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null").toString();
        this.clientSession = clientSession;
    }

    public RecordSet getRecordSet(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorSplit split, List<? extends ColumnHandle> columns) {
        Objects.requireNonNull(split, "split is null");
        Objects.requireNonNull(columns, "columns is null");
        KuduSplit kuduSplit = (KuduSplit)split;
        return new KuduRecordSet(this.clientSession, kuduSplit, columns);
    }

    public KuduClientSession getClientSession() {
        return this.clientSession;
    }
}

