/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.kudu;

import com.facebook.presto.kudu.KuduClientSession;
import com.facebook.presto.kudu.KuduConnectorId;
import com.facebook.presto.kudu.KuduSplit;
import com.facebook.presto.kudu.KuduTableLayoutHandle;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorSplitSource;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.FixedSplitSource;
import com.facebook.presto.spi.connector.ConnectorSplitManager;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;

public class KuduSplitManager
implements ConnectorSplitManager {
    private final String connectorId;
    private final KuduClientSession clientSession;

    @Inject
    public KuduSplitManager(KuduConnectorId connectorId, KuduClientSession clientSession) {
        this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null").toString();
        this.clientSession = Objects.requireNonNull(clientSession, "clientSession is null");
    }

    public ConnectorSplitSource getSplits(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorTableLayoutHandle layout, ConnectorSplitManager.SplitSchedulingContext splitSchedulingContext) {
        KuduTableLayoutHandle layoutHandle = (KuduTableLayoutHandle)layout;
        List<KuduSplit> splits = this.clientSession.buildKuduSplits(layoutHandle);
        return new FixedSplitSource(splits);
    }
}

