/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.kudu;

import com.facebook.presto.kudu.KuduClientSession;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.SchemaTableName;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Locale;
import java.util.Objects;
import org.apache.kudu.client.KuduTable;

public class KuduTableHandle
implements ConnectorTableHandle {
    private final String connectorId;
    private final SchemaTableName schemaTableName;
    private transient KuduTable table;

    @JsonCreator
    public KuduTableHandle(@JsonProperty(value="connectorId") String connectorId, @JsonProperty(value="schemaTableName") SchemaTableName schemaTableName) {
        this(connectorId, schemaTableName, null);
    }

    public KuduTableHandle(String connectorId, SchemaTableName schemaTableName, KuduTable table) {
        this.connectorId = Objects.requireNonNull(connectorId.toLowerCase(Locale.ENGLISH), "connectorId is null");
        this.schemaTableName = Objects.requireNonNull(schemaTableName, "schemaTableName is null");
        this.table = table;
    }

    public KuduTable getTable(KuduClientSession session) {
        if (this.table == null) {
            this.table = session.openTable(this.schemaTableName);
        }
        return this.table;
    }

    @JsonProperty
    public String getConnectorId() {
        return this.connectorId;
    }

    @JsonProperty
    public SchemaTableName getSchemaTableName() {
        return this.schemaTableName;
    }

    public int hashCode() {
        return Objects.hash(this.connectorId, this.schemaTableName);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        KuduTableHandle other = (KuduTableHandle)obj;
        return Objects.equals(this.connectorId, other.connectorId) && this.schemaTableName.equals((Object)other.getSchemaTableName());
    }

    public String toString() {
        return this.connectorId + ":" + this.schemaTableName;
    }
}

