/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.kudu;

import com.facebook.airlift.log.Logger;
import com.facebook.presto.kudu.KuduClientConfig;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.kudu.client.KuduClient;

public class KuduUtil {
    private static final Logger log = Logger.get(KuduUtil.class);

    private KuduUtil() {
    }

    static void initKerberosENV(String principal, String keytab, boolean debugEnabled) {
        try {
            Configuration conf = new Configuration();
            conf.set("hadoop.security.authentication", "kerberos");
            if (debugEnabled) {
                System.setProperty("sun.security.krb5.debug", "true");
            }
            UserGroupInformation.setConfiguration((Configuration)conf);
            UserGroupInformation.loginUserFromKeytab((String)principal, (String)keytab);
            log.info("Connecting to kudu with kerberos authentication");
            log.info("Current user: " + UserGroupInformation.getCurrentUser());
            log.info("Login user: " + UserGroupInformation.getLoginUser());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static KuduClient createKuduKerberosClient(KuduClientConfig config) {
        KuduClient client = null;
        try {
            KuduUtil.reTryKerberos(true);
            client = (KuduClient)UserGroupInformation.getLoginUser().doAs(() -> KuduUtil.createKuduClient(config));
            return client;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static KuduClient createKuduClient(KuduClientConfig config) {
        KuduClient.KuduClientBuilder builder = new KuduClient.KuduClientBuilder(config.getMasterAddresses());
        builder.defaultAdminOperationTimeoutMs(config.getDefaultAdminOperationTimeout().toMillis());
        builder.defaultOperationTimeoutMs(config.getDefaultOperationTimeout().toMillis());
        builder.defaultSocketReadTimeoutMs(config.getDefaultSocketReadTimeout().toMillis());
        if (config.isDisableStatistics()) {
            builder.disableStatistics();
        }
        return builder.build();
    }

    static void reTryKerberos(boolean enabled) {
        if (enabled) {
            log.debug("Try relogin kerberos at first!");
            try {
                if (UserGroupInformation.isLoginKeytabBased()) {
                    UserGroupInformation.getLoginUser().reloginFromKeytab();
                } else if (UserGroupInformation.isLoginTicketBased()) {
                    UserGroupInformation.getLoginUser().reloginFromTicketCache();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

