/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.kudu;

import java.nio.charset.StandardCharsets;
import org.apache.kudu.Schema;
import org.apache.kudu.client.PartialRow;
import org.apache.kudu.client.RowResult;

public class RowHelper {
    private RowHelper() {
    }

    public static void copyPrimaryKey(Schema schema, RowResult from, PartialRow to) {
        block11: for (int i = 0; i < schema.getPrimaryKeyColumnCount(); ++i) {
            switch (schema.getColumnByIndex(i).getType()) {
                case STRING: {
                    to.addStringUtf8(i, from.getString(i).getBytes(StandardCharsets.UTF_8));
                    continue block11;
                }
                case INT64: 
                case UNIXTIME_MICROS: {
                    to.addLong(i, from.getLong(i));
                    continue block11;
                }
                case INT32: {
                    to.addInt(i, from.getInt(i));
                    continue block11;
                }
                case INT16: {
                    to.addShort(i, from.getShort(i));
                    continue block11;
                }
                case INT8: {
                    to.addByte(i, from.getByte(i));
                    continue block11;
                }
                case DOUBLE: {
                    to.addDouble(i, from.getDouble(i));
                    continue block11;
                }
                case FLOAT: {
                    to.addFloat(i, from.getFloat(i));
                    continue block11;
                }
                case BOOL: {
                    to.addBoolean(i, from.getBoolean(i));
                    continue block11;
                }
                case BINARY: {
                    to.addBinary(i, from.getBinary(i));
                    continue block11;
                }
                default: {
                    throw new IllegalStateException("Unknown type " + schema.getColumnByIndex(i).getType() + " for column " + schema.getColumnByIndex(i).getName());
                }
            }
        }
    }

    public static void copyPrimaryKey(Schema schema, PartialRow from, PartialRow to) {
        block11: for (int i = 0; i < schema.getPrimaryKeyColumnCount(); ++i) {
            switch (schema.getColumnByIndex(i).getType()) {
                case STRING: {
                    to.addStringUtf8(i, from.getString(i).getBytes(StandardCharsets.UTF_8));
                    continue block11;
                }
                case INT64: 
                case UNIXTIME_MICROS: {
                    to.addLong(i, from.getLong(i));
                    continue block11;
                }
                case INT32: {
                    to.addInt(i, from.getInt(i));
                    continue block11;
                }
                case INT16: {
                    to.addShort(i, from.getShort(i));
                    continue block11;
                }
                case INT8: {
                    to.addByte(i, from.getByte(i));
                    continue block11;
                }
                case DOUBLE: {
                    to.addDouble(i, from.getDouble(i));
                    continue block11;
                }
                case FLOAT: {
                    to.addFloat(i, from.getFloat(i));
                    continue block11;
                }
                case BOOL: {
                    to.addBoolean(i, from.getBoolean(i));
                    continue block11;
                }
                case BINARY: {
                    to.addBinary(i, from.getBinary(i));
                    continue block11;
                }
                default: {
                    throw new IllegalStateException("Unknown type " + schema.getColumnByIndex(i).getType() + " for column " + schema.getColumnByIndex(i).getName());
                }
            }
        }
    }
}

