/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.localfile;

import com.facebook.presto.localfile.LocalFileMetadata;
import com.facebook.presto.localfile.LocalFileRecordSetProvider;
import com.facebook.presto.localfile.LocalFileSplitManager;
import com.facebook.presto.localfile.LocalFileTransactionHandle;
import com.facebook.presto.spi.connector.Connector;
import com.facebook.presto.spi.connector.ConnectorMetadata;
import com.facebook.presto.spi.connector.ConnectorRecordSetProvider;
import com.facebook.presto.spi.connector.ConnectorSplitManager;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.transaction.IsolationLevel;
import io.airlift.bootstrap.LifeCycleManager;
import io.airlift.log.Logger;
import java.util.Objects;
import javax.inject.Inject;

public class LocalFileConnector
implements Connector {
    private static final Logger log = Logger.get(LocalFileConnector.class);
    private final LifeCycleManager lifeCycleManager;
    private final LocalFileMetadata metadata;
    private final LocalFileSplitManager splitManager;
    private final LocalFileRecordSetProvider recordSetProvider;

    @Inject
    public LocalFileConnector(LifeCycleManager lifeCycleManager, LocalFileMetadata metadata, LocalFileSplitManager splitManager, LocalFileRecordSetProvider recordSetProvider) {
        this.recordSetProvider = recordSetProvider;
        this.lifeCycleManager = Objects.requireNonNull(lifeCycleManager, "lifeCycleManager is null");
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.splitManager = Objects.requireNonNull(splitManager, "splitManager is null");
    }

    public ConnectorTransactionHandle beginTransaction(IsolationLevel isolationLevel, boolean readOnly) {
        IsolationLevel.checkConnectorSupports((IsolationLevel)IsolationLevel.READ_COMMITTED, (IsolationLevel)isolationLevel);
        return LocalFileTransactionHandle.INSTANCE;
    }

    public ConnectorMetadata getMetadata(ConnectorTransactionHandle transactionHandle) {
        return this.metadata;
    }

    public ConnectorSplitManager getSplitManager() {
        return this.splitManager;
    }

    public ConnectorRecordSetProvider getRecordSetProvider() {
        return this.recordSetProvider;
    }

    public final void shutdown() {
        try {
            this.lifeCycleManager.stop();
        }
        catch (Exception e) {
            log.error((Throwable)e, "Error shutting down connector");
        }
    }
}

