/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.validation.ConstraintDeclarationException;
import javax.validation.GroupDefinitionException;
import javax.validation.GroupSequence;
import javax.validation.groups.ConvertGroup;
import javax.validation.groups.Default;
import org.apache.bval.MetaBeanFactory;
import org.apache.bval.jsr.AnnotationProcessor;
import org.apache.bval.jsr.ApacheValidatorFactory;
import org.apache.bval.jsr.AppendValidationToMeta;
import org.apache.bval.jsr.JsrMetaBeanFactory$org_apache_bval_util_reflection_Reflection$$getDeclaredFields$$Ljava_lang_Class$_ACTION;
import org.apache.bval.jsr.JsrMetaBeanFactory$org_apache_bval_util_reflection_Reflection$$getDeclaredMethods$$Ljava_lang_Class$_ACTION;
import org.apache.bval.jsr.groups.Group;
import org.apache.bval.jsr.util.ClassHelper;
import org.apache.bval.jsr.xml.MetaConstraint;
import org.apache.bval.model.FeaturesCapable;
import org.apache.bval.model.Meta;
import org.apache.bval.model.MetaBean;
import org.apache.bval.model.MetaConstructor;
import org.apache.bval.model.MetaInvocable;
import org.apache.bval.model.MetaMethod;
import org.apache.bval.model.MetaParameter;
import org.apache.bval.model.MetaProperty;
import org.apache.bval.util.AccessStrategy;
import org.apache.bval.util.FieldAccess;
import org.apache.bval.util.MethodAccess;
import org.apache.bval.util.reflection.Reflection;
import org.apache.commons.weaver.privilizer.Privileged;
import org.apache.commons.weaver.privilizer.Privilized;
import org.apache.commons.weaver.privilizer.Privilizing;

@Privilizing(value={@Privilizing.CallTo(value=Reflection.class)})
@Privilized(value="DYNAMIC")
public class JsrMetaBeanFactory
implements MetaBeanFactory {
    protected static final Logger log;
    protected final ApacheValidatorFactory factory;
    protected AnnotationProcessor annotationProcessor;

    public JsrMetaBeanFactory(ApacheValidatorFactory factory) {
        this.factory = factory;
        this.annotationProcessor = new AnnotationProcessor(factory);
    }

    public void buildMetaBean(MetaBean metabean) {
        try {
            Class beanClass = metabean.getBeanClass();
            this.processGroupSequence(beanClass, metabean);
            List<Class<?>> classSequence = ClassHelper.fillFullClassHierarchyAsList(new ArrayList(), beanClass);
            for (int i = classSequence.size() - 1; i >= 0; --i) {
                Class<?> eachClass = classSequence.get(i);
                this.processClass(eachClass, metabean);
                this.processGroupSequence(eachClass, metabean, "{GroupSequence:" + eachClass.getCanonicalName() + "}");
            }
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException(e.getTargetException());
        }
    }

    private void processClass(Class<?> beanClass, MetaBean metabean) throws IllegalAccessException, InvocationTargetException {
        Method[] methods;
        Field[] fields;
        if (!this.factory.getAnnotationIgnores().isIgnoreAnnotations(beanClass)) {
            this.annotationProcessor.processAnnotations(null, beanClass, beanClass, null, new AppendValidationToMeta((FeaturesCapable)metabean));
        }
        ArrayList<String> missingValid = new ArrayList<String>();
        for (Field field : fields = JsrMetaBeanFactory.org_apache_bval_util_reflection_Reflection$$getDeclaredFields(beanClass)) {
            boolean create;
            MetaProperty metaProperty = metabean.getProperty(field.getName());
            if (this.factory.getAnnotationIgnores().isIgnoreAnnotations(field)) continue;
            FieldAccess access = new FieldAccess(field);
            boolean bl = create = metaProperty == null;
            if (create) {
                metaProperty = JsrMetaBeanFactory.addMetaProperty(metabean, (AccessStrategy)access);
            }
            if (!this.annotationProcessor.processAnnotations((Meta)metaProperty, beanClass, field, (AccessStrategy)access, new AppendValidationToMeta((FeaturesCapable)metaProperty)) && create) {
                metabean.putProperty(metaProperty.getName(), null);
            }
            if (field.getAnnotation(ConvertGroup.class) == null) continue;
            missingValid.add(field.getName());
        }
        for (Method method : methods = JsrMetaBeanFactory.org_apache_bval_util_reflection_Reflection$$getDeclaredMethods(beanClass)) {
            boolean create;
            if (method.isSynthetic() || method.isBridge()) continue;
            String propName = null;
            if (method.getParameterTypes().length == 0) {
                propName = MethodAccess.getPropertyName((Method)method);
            }
            if (propName == null || this.factory.getAnnotationIgnores().isIgnoreAnnotations(method)) continue;
            MethodAccess access = new MethodAccess(propName, method);
            MetaProperty metaProperty = metabean.getProperty(propName);
            boolean bl = create = metaProperty == null;
            if (create) {
                metaProperty = JsrMetaBeanFactory.addMetaProperty(metabean, (AccessStrategy)access);
            }
            if (this.annotationProcessor.processAnnotations((Meta)metaProperty, beanClass, method, (AccessStrategy)access, new AppendValidationToMeta((FeaturesCapable)metaProperty)) || !create) continue;
            metabean.putProperty(propName, null);
        }
        this.addXmlConstraints(beanClass, metabean);
        for (String name : missingValid) {
            MetaProperty metaProperty = metabean.getProperty(name);
            if (metaProperty == null || metaProperty.getFeature("refCascade") != null) continue;
            throw new ConstraintDeclarationException("@ConvertGroup needs @Valid");
        }
        missingValid.clear();
    }

    @Privileged
    private static /* synthetic */ Field[] org_apache_bval_util_reflection_Reflection$$getDeclaredFields(Class<?> clazz) {
        if (!(System.getSecurityManager() != null)) {
            return clazz.getDeclaredFields();
        }
        return (Field[])AccessController.doPrivileged(new JsrMetaBeanFactory$org_apache_bval_util_reflection_Reflection$$getDeclaredFields$$Ljava_lang_Class$_ACTION(clazz));
    }

    static /* synthetic */ Field[] __privileged_access$0(Class clazz) {
        return clazz.getDeclaredFields();
    }

    @Privileged
    private static /* synthetic */ Method[] org_apache_bval_util_reflection_Reflection$$getDeclaredMethods(Class<?> clazz) {
        if (!(System.getSecurityManager() != null)) {
            return clazz.getDeclaredMethods();
        }
        return (Method[])AccessController.doPrivileged(new JsrMetaBeanFactory$org_apache_bval_util_reflection_Reflection$$getDeclaredMethods$$Ljava_lang_Class$_ACTION(clazz));
    }

    static /* synthetic */ Method[] __privileged_access$1(Class clazz) {
        return clazz.getDeclaredMethods();
    }

    private void addXmlConstraints(Class<?> beanClass, MetaBean metabean) throws IllegalAccessException, InvocationTargetException {
        for (MetaConstraint<?, Annotation> metaConstraint : this.factory.getMetaConstraints(beanClass)) {
            MetaProperty meta;
            AccessStrategy access = metaConstraint.getAccessStrategy();
            boolean create = false;
            if (access == null) {
                meta = null;
            } else {
                MetaParameter param;
                Integer index;
                if (access.getElementType() == ElementType.METHOD && !metaConstraint.getMember().getName().startsWith("get")) {
                    MetaMethod metaMethod;
                    Method method = (Method)Method.class.cast(metaConstraint.getMember());
                    meta = metabean.getMethod(method);
                    if (meta == null) {
                        meta = new MetaMethod(metabean, method);
                        metaMethod = (MetaMethod)MetaMethod.class.cast(meta);
                        metabean.addMethod(method, metaMethod);
                    } else {
                        metaMethod = (MetaMethod)MetaMethod.class.cast(meta);
                    }
                    index = metaConstraint.getIndex();
                    if (index != null && index >= 0) {
                        param = metaMethod.getParameter(index);
                        if (param == null) {
                            param = new MetaParameter((MetaInvocable)metaMethod, index);
                            metaMethod.addParameter(index.intValue(), param);
                        }
                        param.addAnnotation(metaConstraint.getAnnotation());
                        continue;
                    }
                    metaMethod.addAnnotation(metaConstraint.getAnnotation());
                    continue;
                }
                if (access.getElementType() == ElementType.CONSTRUCTOR) {
                    MetaConstructor metaConstructor;
                    Constructor constructor = (Constructor)Constructor.class.cast(metaConstraint.getMember());
                    meta = metabean.getConstructor(constructor);
                    if (meta == null) {
                        meta = new MetaConstructor(metabean, constructor);
                        metaConstructor = (MetaConstructor)MetaConstructor.class.cast(meta);
                        metabean.addConstructor(constructor, metaConstructor);
                    } else {
                        metaConstructor = (MetaConstructor)MetaConstructor.class.cast(meta);
                    }
                    index = metaConstraint.getIndex();
                    if (index != null && index >= 0) {
                        param = metaConstructor.getParameter(index);
                        if (param == null) {
                            param = new MetaParameter((MetaInvocable)metaConstructor, index);
                            metaConstructor.addParameter(index.intValue(), param);
                        }
                        param.addAnnotation(metaConstraint.getAnnotation());
                        continue;
                    }
                    metaConstructor.addAnnotation(metaConstraint.getAnnotation());
                    continue;
                }
                meta = metabean.getProperty(access.getPropertyName());
                boolean bl = create = meta == null;
                if (create) {
                    meta = JsrMetaBeanFactory.addMetaProperty(metabean, access);
                }
            }
            if (this.annotationProcessor.processAnnotation(metaConstraint.getAnnotation(), (Meta)meta, beanClass, metaConstraint.getAccessStrategy(), new AppendValidationToMeta((FeaturesCapable)(meta == null ? metabean : meta)), false) || !create) continue;
            metabean.putProperty(access.getPropertyName(), null);
        }
        for (AccessStrategy access : this.factory.getValidAccesses(beanClass)) {
            boolean create;
            if (access.getElementType() == ElementType.PARAMETER) continue;
            MetaProperty metaProperty = metabean.getProperty(access.getPropertyName());
            boolean bl = create = metaProperty == null;
            if (create) {
                metaProperty = JsrMetaBeanFactory.addMetaProperty(metabean, access);
            }
            if (this.annotationProcessor.addAccessStrategy((Meta)metaProperty, access) || !create) continue;
            metabean.putProperty(access.getPropertyName(), null);
        }
    }

    private void processGroupSequence(Class<?> beanClass, MetaBean metabean) {
        this.processGroupSequence(beanClass, metabean, "GroupSequence");
    }

    private void processGroupSequence(Class<?> beanClass, MetaBean metabean, String key) {
        Class<?>[] groupClasses;
        GroupSequence annotation = beanClass.getAnnotation(GroupSequence.class);
        List groupSeq = (List)metabean.getFeature(key);
        if (groupSeq == null) {
            groupSeq = (List)metabean.initFeature(key, new ArrayList(annotation == null ? 1 : annotation.value().length));
        }
        if ((groupClasses = this.factory.getDefaultSequence(beanClass)) == null || groupClasses.length == 0) {
            if (annotation == null) {
                groupSeq.add(Group.DEFAULT);
                return;
            }
            groupClasses = annotation.value();
        }
        boolean containsDefault = false;
        for (Class<?> groupClass : groupClasses) {
            if (groupClass.getName().equals(beanClass.getName())) {
                groupSeq.add(Group.DEFAULT);
                containsDefault = true;
                continue;
            }
            if (groupClass.getName().equals(Default.class.getName())) {
                throw new GroupDefinitionException("'Default.class' must not appear in @GroupSequence! Use '" + beanClass.getSimpleName() + ".class' instead.");
            }
            groupSeq.add(new Group(groupClass));
        }
        if (!containsDefault) {
            throw new GroupDefinitionException("Redefined default group sequence must contain " + beanClass.getName());
        }
        log.log(Level.FINEST, String.format("Default group sequence for bean %s is: %s", beanClass.getName(), groupSeq));
    }

    public static MetaProperty addMetaProperty(MetaBean parentMetaBean, AccessStrategy access) {
        MetaProperty result = new MetaProperty();
        String name = access.getPropertyName();
        result.setName(name);
        result.setType(access.getJavaType());
        parentMetaBean.putProperty(name, result);
        return result;
    }

    private static void __privileged_clinit0() {
        log = Logger.getLogger(JsrMetaBeanFactory.class.getName());
    }

    static {
        JsrMetaBeanFactory.__privileged_clinit0();
    }
}

