/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.localfile;

import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.localfile.LocalFileColumnHandle;
import com.facebook.presto.localfile.LocalFileRecordCursor;
import com.facebook.presto.localfile.LocalFileSplit;
import com.facebook.presto.localfile.LocalFileTables;
import com.facebook.presto.spi.HostAddress;
import com.facebook.presto.spi.RecordCursor;
import com.facebook.presto.spi.RecordSet;
import com.facebook.presto.spi.SchemaTableName;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Objects;

public class LocalFileRecordSet
implements RecordSet {
    private final List<LocalFileColumnHandle> columns;
    private final List<Type> columnTypes;
    private final HostAddress address;
    private final TupleDomain<LocalFileColumnHandle> effectivePredicate;
    private final SchemaTableName tableName;
    private final LocalFileTables localFileTables;

    public LocalFileRecordSet(LocalFileTables localFileTables, LocalFileSplit split, List<LocalFileColumnHandle> columns) {
        this.columns = Objects.requireNonNull(columns, "column handles is null");
        Objects.requireNonNull(split, "split is null");
        ImmutableList.Builder types = ImmutableList.builder();
        for (LocalFileColumnHandle column : columns) {
            types.add((Object)column.getColumnType());
        }
        this.columnTypes = types.build();
        this.address = (HostAddress)Iterables.getOnlyElement(split.getAddresses());
        this.effectivePredicate = split.getEffectivePredicate();
        this.tableName = split.getTableName();
        this.localFileTables = Objects.requireNonNull(localFileTables, "localFileTables is null");
    }

    public List<Type> getColumnTypes() {
        return this.columnTypes;
    }

    public RecordCursor cursor() {
        return new LocalFileRecordCursor(this.localFileTables, this.columns, this.tableName, this.address, this.effectivePredicate);
    }
}

