/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.localfile;

import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.localfile.LocalFileColumnHandle;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.HostAddress;
import com.facebook.presto.spi.NodeProvider;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.schedule.NodeSelectionStrategy;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;

public class LocalFileSplit
implements ConnectorSplit {
    private final HostAddress address;
    private final SchemaTableName tableName;
    private final TupleDomain<LocalFileColumnHandle> effectivePredicate;

    @JsonCreator
    public LocalFileSplit(@JsonProperty(value="address") HostAddress address, @JsonProperty(value="tableName") SchemaTableName tableName, @JsonProperty(value="effectivePredicate") TupleDomain<LocalFileColumnHandle> effectivePredicate) {
        this.address = Objects.requireNonNull(address, "address is null");
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        this.effectivePredicate = Objects.requireNonNull(effectivePredicate, "effectivePredicate is null");
    }

    @JsonProperty
    public HostAddress getAddress() {
        return this.address;
    }

    @JsonProperty
    public SchemaTableName getTableName() {
        return this.tableName;
    }

    @JsonProperty
    public TupleDomain<LocalFileColumnHandle> getEffectivePredicate() {
        return this.effectivePredicate;
    }

    public NodeSelectionStrategy getNodeSelectionStrategy() {
        return NodeSelectionStrategy.HARD_AFFINITY;
    }

    public List<HostAddress> getPreferredNodes(NodeProvider nodeProvider) {
        return ImmutableList.of((Object)this.address);
    }

    public List<HostAddress> getAddresses() {
        return ImmutableList.of((Object)this.address);
    }

    public Object getInfo() {
        return this;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("address", (Object)this.address).add("tableName", (Object)this.tableName).toString();
    }
}

