/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.block;

import com.facebook.presto.common.block.ArrayBlock;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.block.DictionaryBlock;
import com.facebook.presto.common.block.DictionaryId;
import com.facebook.presto.common.block.MethodHandleUtil;
import com.facebook.presto.common.block.RowBlock;
import com.facebook.presto.common.block.RowBlockBuilder;
import com.facebook.presto.common.block.RunLengthEncodedBlock;
import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.DateType;
import com.facebook.presto.common.type.DecimalType;
import com.facebook.presto.common.type.Decimals;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.MapType;
import com.facebook.presto.common.type.RealType;
import com.facebook.presto.common.type.RowType;
import com.facebook.presto.common.type.SmallintType;
import com.facebook.presto.common.type.TimestampType;
import com.facebook.presto.common.type.TimestampWithTimeZoneType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarbinaryType;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.testing.TestingConnectorSession;
import com.facebook.presto.testing.TestingEnvironment;
import com.facebook.presto.type.ColorType;
import com.facebook.presto.util.StructuralTestUtil;
import com.google.common.base.Preconditions;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.lang.invoke.MethodHandle;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.StreamSupport;
import org.testng.Assert;

public final class BlockAssertions {
    private static final int ENTRY_SIZE = 4;
    private static final int MAX_STRING_SIZE = 50;

    private BlockAssertions() {
    }

    public static Object getOnlyValue(Type type, Block block) {
        Assert.assertEquals((int)block.getPositionCount(), (int)1, (String)"Block positions");
        return type.getObjectValue(TestingConnectorSession.SESSION.getSqlFunctionProperties(), block, 0);
    }

    public static List<Object> toValues(Type type, Iterable<Block> blocks) {
        ArrayList<Object> values = new ArrayList<Object>();
        for (Block block : blocks) {
            for (int position = 0; position < block.getPositionCount(); ++position) {
                values.add(type.getObjectValue(TestingConnectorSession.SESSION.getSqlFunctionProperties(), block, position));
            }
        }
        return Collections.unmodifiableList(values);
    }

    public static List<Object> toValues(Type type, Block block) {
        ArrayList<Object> values = new ArrayList<Object>();
        for (int position = 0; position < block.getPositionCount(); ++position) {
            values.add(type.getObjectValue(TestingConnectorSession.SESSION.getSqlFunctionProperties(), block, position));
        }
        return Collections.unmodifiableList(values);
    }

    public static void assertBlockEquals(Type type, Block actual, Block expected) {
        Assert.assertEquals((int)actual.getPositionCount(), (int)expected.getPositionCount());
        for (int position = 0; position < actual.getPositionCount(); ++position) {
            Assert.assertEquals((Object)type.getObjectValue(TestingConnectorSession.SESSION.getSqlFunctionProperties(), actual, position), (Object)type.getObjectValue(TestingConnectorSession.SESSION.getSqlFunctionProperties(), expected, position));
        }
    }

    public static Block createEmptyBlock(Type type) {
        return BlockAssertions.createAllNullsBlock(type, 0);
    }

    public static Block createAllNullsBlock(Type type, int positionCount) {
        BlockBuilder blockBuilder = type.createBlockBuilder(null, 1);
        for (int i = 0; i < positionCount; ++i) {
            blockBuilder.appendNull();
        }
        return blockBuilder.build();
    }

    public static Block createStringsBlock(String ... values) {
        Objects.requireNonNull(values, "varargs 'values' is null");
        return BlockAssertions.createStringsBlock(Arrays.asList(values));
    }

    public static Block createStringsBlock(Iterable<String> values) {
        BlockBuilder builder = VarcharType.VARCHAR.createBlockBuilder(null, (int)StreamSupport.stream(values.spliterator(), false).count());
        for (String value : values) {
            if (value == null) {
                builder.appendNull();
                continue;
            }
            VarcharType.VARCHAR.writeString(builder, value);
        }
        return builder.build();
    }

    public static Block createRandomStringBlock(int positionCount, float nullRate, int maxStringLength) {
        ValuesWithNullsGenerator generator = new ValuesWithNullsGenerator(nullRate, () -> BlockAssertions.generateRandomStringWithLength(maxStringLength));
        return BlockAssertions.createStringsBlock(IntStream.range(0, positionCount).mapToObj(i -> (String)generator.next()).collect(Collectors.toList()));
    }

    public static Block createSlicesBlock(Slice ... values) {
        Objects.requireNonNull(values, "varargs 'values' is null");
        return BlockAssertions.createSlicesBlock(Arrays.asList(values));
    }

    public static Block createSlicesBlock(Iterable<Slice> values) {
        BlockBuilder builder = VarbinaryType.VARBINARY.createBlockBuilder(null, 100);
        for (Slice value : values) {
            if (value == null) {
                builder.appendNull();
                continue;
            }
            VarbinaryType.VARBINARY.writeSlice(builder, value);
        }
        return builder.build();
    }

    public static Block createStringSequenceBlock(int start, int end) {
        BlockBuilder builder = VarcharType.VARCHAR.createBlockBuilder(null, 100);
        for (int i = start; i < end; ++i) {
            VarcharType.VARCHAR.writeString(builder, String.valueOf(i));
        }
        return builder.build();
    }

    public static Block createStringDictionaryBlock(int start, int length) {
        Preconditions.checkArgument((length > 5 ? 1 : 0) != 0, (Object)"block must have more than 5 entries");
        int dictionarySize = length / 5;
        BlockBuilder builder = VarcharType.VARCHAR.createBlockBuilder(null, dictionarySize);
        for (int i = start; i < start + dictionarySize; ++i) {
            VarcharType.VARCHAR.writeString(builder, String.valueOf(i));
        }
        int[] ids = new int[length];
        for (int i = 0; i < length; ++i) {
            ids[i] = i % dictionarySize;
        }
        return new DictionaryBlock(builder.build(), ids);
    }

    public static Block createStringArraysBlock(Iterable<? extends Iterable<String>> values) {
        ArrayType arrayType = new ArrayType((Type)VarcharType.VARCHAR);
        BlockBuilder builder = arrayType.createBlockBuilder(null, 100);
        for (Iterable<String> iterable : values) {
            if (iterable == null) {
                builder.appendNull();
                continue;
            }
            arrayType.writeObject(builder, (Object)BlockAssertions.createStringsBlock(iterable));
        }
        return builder.build();
    }

    public static <K, V> Block createMapBlock(MapType type, Map<K, V> map) {
        BlockBuilder blockBuilder = type.createBlockBuilder(null, map.size());
        for (Map.Entry<K, V> entry : map.entrySet()) {
            BlockBuilder entryBuilder = blockBuilder.beginBlockEntry();
            StructuralTestUtil.appendToBlockBuilder(type.getKeyType(), entry.getKey(), entryBuilder);
            StructuralTestUtil.appendToBlockBuilder(type.getValueType(), entry.getValue(), entryBuilder);
            blockBuilder.closeEntry();
        }
        return blockBuilder.build();
    }

    public static Block createBooleansBlock(Boolean ... values) {
        Objects.requireNonNull(values, "varargs 'values' is null");
        return BlockAssertions.createBooleansBlock(Arrays.asList(values));
    }

    public static Block createBooleansBlock(Boolean value, int count) {
        return BlockAssertions.createBooleansBlock(Collections.nCopies(count, value));
    }

    public static Block createBooleansBlock(Iterable<Boolean> values) {
        BlockBuilder builder = BooleanType.BOOLEAN.createBlockBuilder(null, 100);
        for (Boolean value : values) {
            if (value == null) {
                builder.appendNull();
                continue;
            }
            BooleanType.BOOLEAN.writeBoolean(builder, value.booleanValue());
        }
        return builder.build();
    }

    public static Block createRandomBooleansBlock(int positionCount, float nullRate) {
        ValuesWithNullsGenerator generator = new ValuesWithNullsGenerator(nullRate, () -> ThreadLocalRandom.current().nextBoolean());
        return BlockAssertions.createBooleansBlock(IntStream.range(0, positionCount).mapToObj(i -> (Boolean)generator.next()).collect(Collectors.toList()));
    }

    public static Block createShortDecimalsBlock(String ... values) {
        Objects.requireNonNull(values, "varargs 'values' is null");
        return BlockAssertions.createShortDecimalsBlock(Arrays.asList(values));
    }

    public static Block createShortDecimalsBlock(Iterable<String> values) {
        DecimalType shortDecimalType = DecimalType.createDecimalType((int)1);
        BlockBuilder builder = shortDecimalType.createBlockBuilder(null, 100);
        for (String value : values) {
            if (value == null) {
                builder.appendNull();
                continue;
            }
            shortDecimalType.writeLong(builder, new BigDecimal(value).unscaledValue().longValue());
        }
        return builder.build();
    }

    public static Block createRandomShortDecimalsBlock(int positionCount, float nullRate) {
        ValuesWithNullsGenerator generator = new ValuesWithNullsGenerator(nullRate, () -> Double.toString(ThreadLocalRandom.current().nextDouble() * (double)ThreadLocalRandom.current().nextInt()));
        return BlockAssertions.createShortDecimalsBlock(IntStream.range(0, positionCount).mapToObj(i -> (String)generator.next()).collect(Collectors.toList()));
    }

    public static Block createLongDecimalsBlock(String ... values) {
        Objects.requireNonNull(values, "varargs 'values' is null");
        return BlockAssertions.createLongDecimalsBlock(Arrays.asList(values));
    }

    public static Block createLongDecimalsBlock(Iterable<String> values) {
        DecimalType longDecimalType = DecimalType.createDecimalType((int)19);
        BlockBuilder builder = longDecimalType.createBlockBuilder(null, 100);
        for (String value : values) {
            if (value == null) {
                builder.appendNull();
                continue;
            }
            Decimals.writeBigDecimal((DecimalType)longDecimalType, (BlockBuilder)builder, (BigDecimal)new BigDecimal(value));
        }
        return builder.build();
    }

    public static Block createRandomLongDecimalsBlock(int positionCount, float nullRate) {
        ValuesWithNullsGenerator generator = new ValuesWithNullsGenerator(nullRate, () -> Double.toString(ThreadLocalRandom.current().nextDouble() * (double)ThreadLocalRandom.current().nextInt()));
        return BlockAssertions.createLongDecimalsBlock(IntStream.range(0, positionCount).mapToObj(i -> (String)generator.next()).collect(Collectors.toList()));
    }

    public static Block createIntsBlock(Integer ... values) {
        Objects.requireNonNull(values, "varargs 'values' is null");
        return BlockAssertions.createIntsBlock(Arrays.asList(values));
    }

    public static Block createIntsBlock(Iterable<Integer> values) {
        BlockBuilder builder = IntegerType.INTEGER.createBlockBuilder(null, 100);
        for (Integer value : values) {
            if (value == null) {
                builder.appendNull();
                continue;
            }
            IntegerType.INTEGER.writeLong(builder, (long)value.intValue());
        }
        return builder.build();
    }

    public static Block createRowBlock(List<Type> fieldTypes, Object[] ... rows) {
        RowBlockBuilder rowBlockBuilder = new RowBlockBuilder(fieldTypes, null, 1);
        for (Object[] row : rows) {
            if (row == null) {
                rowBlockBuilder.appendNull();
                continue;
            }
            BlockBuilder singleRowBlockWriter = rowBlockBuilder.beginBlockEntry();
            for (Object fieldValue : row) {
                if (fieldValue == null) {
                    singleRowBlockWriter.appendNull();
                    continue;
                }
                if (fieldValue instanceof String) {
                    VarcharType.VARCHAR.writeSlice(singleRowBlockWriter, Slices.utf8Slice((String)((String)fieldValue)));
                    continue;
                }
                if (fieldValue instanceof Slice) {
                    VarbinaryType.VARBINARY.writeSlice(singleRowBlockWriter, (Slice)fieldValue);
                    continue;
                }
                if (fieldValue instanceof Double) {
                    DoubleType.DOUBLE.writeDouble(singleRowBlockWriter, ((Double)fieldValue).doubleValue());
                    continue;
                }
                if (fieldValue instanceof Long) {
                    BigintType.BIGINT.writeLong(singleRowBlockWriter, ((Long)fieldValue).longValue());
                    continue;
                }
                if (fieldValue instanceof Boolean) {
                    BooleanType.BOOLEAN.writeBoolean(singleRowBlockWriter, ((Boolean)fieldValue).booleanValue());
                    continue;
                }
                if (fieldValue instanceof Block) {
                    singleRowBlockWriter.appendStructure((Block)fieldValue);
                    continue;
                }
                if (fieldValue instanceof Integer) {
                    IntegerType.INTEGER.writeLong(singleRowBlockWriter, (long)((Integer)fieldValue).intValue());
                    continue;
                }
                throw new IllegalArgumentException();
            }
            rowBlockBuilder.closeEntry();
        }
        return rowBlockBuilder.build();
    }

    public static Block createRandomIntsBlock(int positionCount, float nullRate) {
        ValuesWithNullsGenerator generator = new ValuesWithNullsGenerator(nullRate, () -> ThreadLocalRandom.current().nextInt());
        return BlockAssertions.createIntsBlock(IntStream.range(0, positionCount).mapToObj(i -> (Integer)generator.next()).collect(Collectors.toList()));
    }

    public static Block createEmptyLongsBlock() {
        return BigintType.BIGINT.createFixedSizeBlockBuilder(0).build();
    }

    public static Block createLongsBlock(int ... values) {
        BlockBuilder builder = BigintType.BIGINT.createBlockBuilder(null, 100);
        for (int value : values) {
            BigintType.BIGINT.writeLong(builder, (long)value);
        }
        return builder.build();
    }

    public static Block createLongsBlock(Long ... values) {
        Objects.requireNonNull(values, "varargs 'values' is null");
        return BlockAssertions.createLongsBlock(Arrays.asList(values));
    }

    public static Block createLongsBlock(Iterable<Long> values) {
        return BlockAssertions.createTypedLongsBlock((Type)BigintType.BIGINT, values);
    }

    public static Block createRandomLongsBlock(int positionCount, float nullRate) {
        ValuesWithNullsGenerator generator = new ValuesWithNullsGenerator(nullRate, () -> ThreadLocalRandom.current().nextLong());
        return BlockAssertions.createLongsBlock(IntStream.range(0, positionCount).mapToObj(i -> (Long)generator.next()).collect(Collectors.toList()));
    }

    public static Block createTypedLongsBlock(Type type, Iterable<Long> values) {
        BlockBuilder builder = type.createBlockBuilder(null, 100);
        for (Long value : values) {
            if (value == null) {
                builder.appendNull();
                continue;
            }
            type.writeLong(builder, value.longValue());
        }
        return builder.build();
    }

    public static Block createRandomSmallintsBlock(int positionCount, float nullRate) {
        ValuesWithNullsGenerator generator = new ValuesWithNullsGenerator(nullRate, () -> ThreadLocalRandom.current().nextLong() % -32768L);
        return BlockAssertions.createTypedLongsBlock((Type)SmallintType.SMALLINT, IntStream.range(0, positionCount).mapToObj(i -> (Long)generator.next()).collect(Collectors.toList()));
    }

    public static Block createLongSequenceBlock(int start, int end) {
        BlockBuilder builder = BigintType.BIGINT.createFixedSizeBlockBuilder(end - start);
        for (int i = start; i < end; ++i) {
            BigintType.BIGINT.writeLong(builder, (long)i);
        }
        return builder.build();
    }

    public static Block createLongDictionaryBlock(int start, int length) {
        Preconditions.checkArgument((length > 5 ? 1 : 0) != 0, (Object)"block must have more than 5 entries");
        int dictionarySize = length / 5;
        BlockBuilder builder = BigintType.BIGINT.createBlockBuilder(null, dictionarySize);
        for (int i = start; i < start + dictionarySize; ++i) {
            BigintType.BIGINT.writeLong(builder, (long)i);
        }
        int[] ids = new int[length];
        for (int i = 0; i < length; ++i) {
            ids[i] = i % dictionarySize;
        }
        return new DictionaryBlock(builder.build(), ids);
    }

    public static Block createLongRepeatBlock(int value, int length) {
        BlockBuilder builder = BigintType.BIGINT.createFixedSizeBlockBuilder(length);
        for (int i = 0; i < length; ++i) {
            BigintType.BIGINT.writeLong(builder, (long)value);
        }
        return builder.build();
    }

    public static Block createDoubleRepeatBlock(double value, int length) {
        BlockBuilder builder = DoubleType.DOUBLE.createFixedSizeBlockBuilder(length);
        for (int i = 0; i < length; ++i) {
            DoubleType.DOUBLE.writeDouble(builder, value);
        }
        return builder.build();
    }

    public static Block createTimestampsWithTimezoneBlock(Long ... values) {
        BlockBuilder builder = TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE.createFixedSizeBlockBuilder(values.length);
        Long[] longArray = values;
        int n = longArray.length;
        for (int i = 0; i < n; ++i) {
            long value = longArray[i];
            TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE.writeLong(builder, value);
        }
        return builder.build();
    }

    public static Block createBooleanSequenceBlock(int start, int end) {
        BlockBuilder builder = BooleanType.BOOLEAN.createFixedSizeBlockBuilder(end - start);
        for (int i = start; i < end; ++i) {
            BooleanType.BOOLEAN.writeBoolean(builder, i % 2 == 0);
        }
        return builder.build();
    }

    public static Block createBlockOfReals(Float ... values) {
        Objects.requireNonNull(values, "varargs 'values' is null");
        return BlockAssertions.createBlockOfReals(Arrays.asList(values));
    }

    public static Block createBlockOfReals(Iterable<Float> values) {
        BlockBuilder builder = RealType.REAL.createBlockBuilder(null, 100);
        for (Float value : values) {
            if (value == null) {
                builder.appendNull();
                continue;
            }
            RealType.REAL.writeLong(builder, (long)Float.floatToRawIntBits(value.floatValue()));
        }
        return builder.build();
    }

    public static Block createSequenceBlockOfReal(int start, int end) {
        BlockBuilder builder = RealType.REAL.createFixedSizeBlockBuilder(end - start);
        for (int i = start; i < end; ++i) {
            RealType.REAL.writeLong(builder, (long)Float.floatToRawIntBits(i));
        }
        return builder.build();
    }

    public static Block createDoublesBlock(Double ... values) {
        Objects.requireNonNull(values, "varargs 'values' is null");
        return BlockAssertions.createDoublesBlock(Arrays.asList(values));
    }

    public static Block createDoublesBlock(Iterable<Double> values) {
        BlockBuilder builder = DoubleType.DOUBLE.createBlockBuilder(null, 100);
        for (Double value : values) {
            if (value == null) {
                builder.appendNull();
                continue;
            }
            DoubleType.DOUBLE.writeDouble(builder, value.doubleValue());
        }
        return builder.build();
    }

    public static Block createDoubleSequenceBlock(int start, int end) {
        BlockBuilder builder = DoubleType.DOUBLE.createFixedSizeBlockBuilder(end - start);
        for (int i = start; i < end; ++i) {
            DoubleType.DOUBLE.writeDouble(builder, (double)i);
        }
        return builder.build();
    }

    public static Block createArrayBigintBlock(Iterable<? extends Iterable<Long>> values) {
        ArrayType arrayType = new ArrayType((Type)BigintType.BIGINT);
        BlockBuilder builder = arrayType.createBlockBuilder(null, 100);
        for (Iterable<Long> iterable : values) {
            if (iterable == null) {
                builder.appendNull();
                continue;
            }
            arrayType.writeObject(builder, (Object)BlockAssertions.createLongsBlock(iterable));
        }
        return builder.build();
    }

    public static Block createDateSequenceBlock(int start, int end) {
        BlockBuilder builder = DateType.DATE.createFixedSizeBlockBuilder(end - start);
        for (int i = start; i < end; ++i) {
            DateType.DATE.writeLong(builder, (long)i);
        }
        return builder.build();
    }

    public static Block createTimestampSequenceBlock(int start, int end) {
        BlockBuilder builder = TimestampType.TIMESTAMP.createFixedSizeBlockBuilder(end - start);
        for (int i = start; i < end; ++i) {
            TimestampType.TIMESTAMP.writeLong(builder, (long)i);
        }
        return builder.build();
    }

    public static Block createShortDecimalSequenceBlock(int start, int end, DecimalType type) {
        BlockBuilder builder = type.createFixedSizeBlockBuilder(end - start);
        long base = BigInteger.TEN.pow(type.getScale()).longValue();
        for (int i = start; i < end; ++i) {
            type.writeLong(builder, base * (long)i);
        }
        return builder.build();
    }

    public static Block createLongDecimalSequenceBlock(int start, int end, DecimalType type) {
        BlockBuilder builder = type.createFixedSizeBlockBuilder(end - start);
        BigInteger base = BigInteger.TEN.pow(type.getScale());
        for (int i = start; i < end; ++i) {
            type.writeSlice(builder, Decimals.encodeUnscaledValue((BigInteger)BigInteger.valueOf(i).multiply(base)));
        }
        return builder.build();
    }

    public static Block createColorRepeatBlock(int value, int length) {
        BlockBuilder builder = ColorType.COLOR.createFixedSizeBlockBuilder(length);
        for (int i = 0; i < length; ++i) {
            ColorType.COLOR.writeLong(builder, (long)value);
        }
        return builder.build();
    }

    public static Block createColorSequenceBlock(int start, int end) {
        BlockBuilder builder = ColorType.COLOR.createBlockBuilder(null, end - start);
        for (int i = start; i < end; ++i) {
            ColorType.COLOR.writeLong(builder, (long)i);
        }
        return builder.build();
    }

    public static RunLengthEncodedBlock createRLEBlock(double value, int positionCount) {
        BlockBuilder blockBuilder = DoubleType.DOUBLE.createBlockBuilder(null, 1);
        DoubleType.DOUBLE.writeDouble(blockBuilder, value);
        return new RunLengthEncodedBlock(blockBuilder.build(), positionCount);
    }

    public static RunLengthEncodedBlock createRLEBlock(long value, int positionCount) {
        BlockBuilder blockBuilder = BigintType.BIGINT.createBlockBuilder(null, 1);
        BigintType.BIGINT.writeLong(blockBuilder, value);
        return new RunLengthEncodedBlock(blockBuilder.build(), positionCount);
    }

    public static RunLengthEncodedBlock createRLEBlock(String value, int positionCount) {
        BlockBuilder blockBuilder = VarcharType.VARCHAR.createBlockBuilder(null, 1);
        VarcharType.VARCHAR.writeSlice(blockBuilder, Slices.wrappedBuffer((byte[])value.getBytes()));
        return new RunLengthEncodedBlock(blockBuilder.build(), positionCount);
    }

    public static RunLengthEncodedBlock createRleBlockWithRandomValue(Block block, int positionCount) {
        Preconditions.checkArgument((block.getPositionCount() > 0 ? 1 : 0) != 0, (Object)String.format("block positions %d is less than or equal to 0", block.getPositionCount()));
        return new RunLengthEncodedBlock(block.getRegion(block.getPositionCount() / 2, 1), positionCount);
    }

    public static DictionaryBlock createRandomDictionaryBlock(Block dictionary, int positionCount) {
        return BlockAssertions.createRandomDictionaryBlock(dictionary, positionCount, false);
    }

    public static DictionaryBlock createRandomDictionaryBlock(Block dictionary, int positionCount, boolean isView) {
        Preconditions.checkArgument((dictionary.getPositionCount() > 0 ? 1 : 0) != 0, (Object)String.format("dictionary's positionCount %d is less than or equal to 0", dictionary.getPositionCount()));
        int idsOffset = 0;
        if (isView) {
            idsOffset = Math.min(ThreadLocalRandom.current().nextInt(dictionary.getPositionCount()), 1);
        }
        int[] ids = IntStream.range(0, positionCount + idsOffset).map(i -> ThreadLocalRandom.current().nextInt(Math.max(dictionary.getPositionCount() / 10, 1))).toArray();
        return new DictionaryBlock(idsOffset, positionCount, dictionary, ids, false, DictionaryId.randomDictionaryId());
    }

    public static Block createRandomBlockForType(Type type, int positionCount, float primitiveNullRate, float nestedNullRate, boolean createView, List<Encoding> wrappings) {
        BlockAssertions.verifyNullRate(primitiveNullRate);
        BlockAssertions.verifyNullRate(nestedNullRate);
        Block block = null;
        if (createView) {
            positionCount *= 2;
        }
        if (type == BooleanType.BOOLEAN) {
            block = BlockAssertions.createRandomBooleansBlock(positionCount, primitiveNullRate);
        } else if (type == BigintType.BIGINT) {
            block = BlockAssertions.createRandomLongsBlock(positionCount, primitiveNullRate);
        } else if (type == IntegerType.INTEGER || type.equals(RealType.REAL)) {
            block = BlockAssertions.createRandomIntsBlock(positionCount, primitiveNullRate);
        } else if (type == SmallintType.SMALLINT) {
            block = BlockAssertions.createRandomSmallintsBlock(positionCount, primitiveNullRate);
        } else if (type instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)type;
            block = decimalType.isShort() ? BlockAssertions.createRandomLongsBlock(positionCount, primitiveNullRate) : BlockAssertions.createRandomLongDecimalsBlock(positionCount, primitiveNullRate);
        } else if (type == VarcharType.VARCHAR) {
            block = BlockAssertions.createRandomStringBlock(positionCount, primitiveNullRate, 50);
        } else {
            boolean[] isNull = null;
            if (nestedNullRate > 0.0f) {
                isNull = new boolean[positionCount];
            }
            int[] offsets = new int[positionCount + 1];
            for (int position = 0; position < positionCount; ++position) {
                if (nestedNullRate > 0.0f && ThreadLocalRandom.current().nextDouble(1.0) < (double)nestedNullRate) {
                    isNull[position] = true;
                    offsets[position + 1] = offsets[position];
                    continue;
                }
                offsets[position + 1] = offsets[position] + (type instanceof RowType ? 1 : ThreadLocalRandom.current().nextInt(4) + 1);
            }
            if (type instanceof ArrayType) {
                Block valuesBlock = BlockAssertions.createRandomBlockForType(((ArrayType)type).getElementType(), offsets[positionCount], primitiveNullRate, nestedNullRate, createView, wrappings);
                block = ArrayBlock.fromElementBlock((int)positionCount, Optional.ofNullable(isNull), (int[])offsets, (Block)valuesBlock);
            } else if (type instanceof MapType) {
                MapType mapType = (MapType)type;
                Block keyBlock = BlockAssertions.createRandomBlockForType(mapType.getKeyType(), offsets[positionCount], 0.0f, 0.0f, createView, wrappings);
                Block valueBlock = BlockAssertions.createRandomBlockForType(mapType.getValueType(), offsets[positionCount], primitiveNullRate, nestedNullRate, createView, wrappings);
                block = mapType.createBlockFromKeyValue(positionCount, Optional.ofNullable(isNull), offsets, keyBlock, valueBlock);
            } else if (type instanceof RowType) {
                List fieldTypes = type.getTypeParameters();
                Block[] fieldBlocks = new Block[fieldTypes.size()];
                for (int i = 0; i < fieldBlocks.length; ++i) {
                    fieldBlocks[i] = BlockAssertions.createRandomBlockForType((Type)fieldTypes.get(i), positionCount, primitiveNullRate, nestedNullRate, createView, wrappings);
                }
                block = RowBlock.fromFieldBlocks((int)positionCount, Optional.ofNullable(isNull), (Block[])fieldBlocks);
            } else {
                throw new IllegalArgumentException(String.format("type %s is not supported.", type));
            }
        }
        if (createView) {
            int offset = (positionCount /= 2) / 2;
            block = block.getRegion(offset, positionCount);
        }
        if (!wrappings.isEmpty()) {
            block = BlockAssertions.wrapBlock(block, positionCount, wrappings);
        }
        return block;
    }

    public static Block wrapBlock(Block block, int positionCount, List<Encoding> wrappings) {
        Preconditions.checkArgument((!wrappings.isEmpty() ? 1 : 0) != 0, (Object)"wrappings is empty");
        Block wrappedBlock = block;
        block4: for (int i = wrappings.size() - 1; i >= 0; --i) {
            switch (wrappings.get(i)) {
                case DICTIONARY: {
                    wrappedBlock = BlockAssertions.createRandomDictionaryBlock(wrappedBlock, positionCount, true);
                    continue block4;
                }
                case RUN_LENGTH: {
                    wrappedBlock = BlockAssertions.createRleBlockWithRandomValue(wrappedBlock, positionCount);
                    continue block4;
                }
                default: {
                    throw new IllegalArgumentException(String.format("wrappings %s is incorrect", wrappings));
                }
            }
        }
        return wrappedBlock;
    }

    public static MapType createMapType(Type keyType, Type valueType) {
        MethodHandle keyNativeEquals = TestingEnvironment.getOperatorMethodHandle((OperatorType)OperatorType.EQUAL, (Type[])new Type[]{keyType, keyType});
        MethodHandle keyBlockEquals = MethodHandleUtil.compose((MethodHandle)keyNativeEquals, (MethodHandle)MethodHandleUtil.nativeValueGetter((Type)keyType), (MethodHandle)MethodHandleUtil.nativeValueGetter((Type)keyType));
        MethodHandle keyNativeHashCode = TestingEnvironment.getOperatorMethodHandle((OperatorType)OperatorType.HASH_CODE, (Type[])new Type[]{keyType});
        MethodHandle keyBlockHashCode = MethodHandleUtil.compose((MethodHandle)keyNativeHashCode, (MethodHandle)MethodHandleUtil.nativeValueGetter((Type)keyType));
        return new MapType(keyType, valueType, keyBlockEquals, keyBlockHashCode);
    }

    private static String generateRandomStringWithLength(int length) {
        byte[] array = new byte[length];
        ThreadLocalRandom.current().nextBytes(array);
        return new String(array, StandardCharsets.UTF_8);
    }

    private static void verifyNullRate(float nullRate) {
        if (nullRate < 0.0f || nullRate > 1.0f) {
            throw new IllegalArgumentException(String.format("nullRate %f is not valid.", Float.valueOf(nullRate)));
        }
    }

    private static final class ValuesWithNullsGenerator<T> {
        private final float nullRate;
        private final Supplier<T> supplier;

        private ValuesWithNullsGenerator(float nullRate, Supplier<T> supplier) {
            BlockAssertions.verifyNullRate(nullRate);
            this.nullRate = nullRate;
            this.supplier = Objects.requireNonNull(supplier, "supplier is null");
        }

        public T next() {
            return (T)(this.nullRate > 0.0f && ThreadLocalRandom.current().nextDouble(1.0) < (double)this.nullRate ? null : this.supplier.get());
        }
    }

    public static enum Encoding {
        DICTIONARY,
        RUN_LENGTH;

    }
}

