/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.block;

import com.facebook.presto.block.BlockAssertions;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.MapType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.testing.TestngUtils;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.BasicSliceInput;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestRowBasedSerialization {
    private FunctionAndTypeManager functionAndTypeManager;

    @BeforeClass
    public void setUp() {
        MetadataManager metadata = MetadataManager.createTestMetadataManager();
        this.functionAndTypeManager = metadata.getFunctionAndTypeManager();
    }

    @AfterClass
    public void tearDown() {
        this.functionAndTypeManager = null;
    }

    @Test
    public void testFixedLength() {
        TestRowBasedSerialization.assertRoundTrip((List<Type>)ImmutableList.of((Object)BigintType.BIGINT), (List<Block>)ImmutableList.of((Object)BlockAssertions.createLongsBlock(Collections.emptyList())));
        TestRowBasedSerialization.assertRoundTrip((List<Type>)ImmutableList.of((Object)BigintType.BIGINT), (List<Block>)ImmutableList.of((Object)BlockAssertions.createLongsBlock(Collections.singletonList(null))));
        TestRowBasedSerialization.assertRoundTrip((List<Type>)ImmutableList.of((Object)BigintType.BIGINT), (List<Block>)ImmutableList.of((Object)BlockAssertions.createLongsBlock(Arrays.asList(null, 1L, null, 3L))));
        TestRowBasedSerialization.assertRoundTrip((List<Type>)ImmutableList.of((Object)BigintType.BIGINT), (List<Block>)ImmutableList.of((Object)BlockAssertions.createLongsBlock(Arrays.asList(0L, null, 1L, null, 3L))));
        TestRowBasedSerialization.assertRoundTrip((List<Type>)ImmutableList.of((Object)BigintType.BIGINT), (List<Block>)ImmutableList.of((Object)BlockAssertions.createLongSequenceBlock(-100, 100)));
    }

    @Test
    public void testVariableLength() {
        TestRowBasedSerialization.assertRoundTrip((List<Type>)ImmutableList.of((Object)VarcharType.VARCHAR), (List<Block>)ImmutableList.of((Object)BlockAssertions.createStringsBlock(new String[0])));
        TestRowBasedSerialization.assertRoundTrip((List<Type>)ImmutableList.of((Object)VarcharType.VARCHAR), (List<Block>)ImmutableList.of((Object)BlockAssertions.createStringsBlock(new String[]{null})));
        TestRowBasedSerialization.assertRoundTrip((List<Type>)ImmutableList.of((Object)VarcharType.VARCHAR), (List<Block>)ImmutableList.of((Object)BlockAssertions.createStringsBlock(null, "abc")));
        TestRowBasedSerialization.assertRoundTrip((List<Type>)ImmutableList.of((Object)VarcharType.VARCHAR), (List<Block>)ImmutableList.of((Object)BlockAssertions.createStringsBlock("bc", null, "abc")));
        TestRowBasedSerialization.assertRoundTrip((List<Type>)ImmutableList.of((Object)VarcharType.VARCHAR), (List<Block>)ImmutableList.of((Object)BlockAssertions.createStringSequenceBlock(1, 100)));
    }

    @Test
    public void testArray() {
        TestRowBasedSerialization.assertRoundTrip((List<Type>)ImmutableList.of((Object)new ArrayType((Type)VarcharType.VARCHAR)), (List<Block>)ImmutableList.of((Object)BlockAssertions.createStringArraysBlock(Collections.emptyList())));
        TestRowBasedSerialization.assertRoundTrip((List<Type>)ImmutableList.of((Object)new ArrayType((Type)VarcharType.VARCHAR)), (List<Block>)ImmutableList.of((Object)BlockAssertions.createStringArraysBlock(Collections.singletonList(Collections.emptyList()))));
        TestRowBasedSerialization.assertRoundTrip((List<Type>)ImmutableList.of((Object)new ArrayType((Type)VarcharType.VARCHAR)), (List<Block>)ImmutableList.of((Object)BlockAssertions.createStringArraysBlock(Collections.singletonList(null))));
        TestRowBasedSerialization.assertRoundTrip((List<Type>)ImmutableList.of((Object)new ArrayType((Type)VarcharType.VARCHAR)), (List<Block>)ImmutableList.of((Object)BlockAssertions.createStringArraysBlock(Collections.singletonList(Collections.singletonList(null)))));
        TestRowBasedSerialization.assertRoundTrip((List<Type>)ImmutableList.of((Object)new ArrayType((Type)VarcharType.VARCHAR)), (List<Block>)ImmutableList.of((Object)BlockAssertions.createStringArraysBlock(Arrays.asList(null, Collections.singletonList(null)))));
        TestRowBasedSerialization.assertRoundTrip((List<Type>)ImmutableList.of((Object)new ArrayType((Type)VarcharType.VARCHAR)), (List<Block>)ImmutableList.of((Object)BlockAssertions.createStringArraysBlock(Arrays.asList(null, Arrays.asList("a", null)))));
        TestRowBasedSerialization.assertRoundTrip((List<Type>)ImmutableList.of((Object)new ArrayType((Type)VarcharType.VARCHAR)), (List<Block>)ImmutableList.of((Object)BlockAssertions.createStringArraysBlock(Arrays.asList(Arrays.asList(null, "b"), Arrays.asList("a", null)))));
        TestRowBasedSerialization.assertRoundTrip((List<Type>)ImmutableList.of((Object)new ArrayType((Type)VarcharType.VARCHAR)), (List<Block>)ImmutableList.of((Object)BlockAssertions.createStringArraysBlock(Arrays.asList(Arrays.asList("b", "b"), Arrays.asList("a", "c")))));
    }

    @Test
    public void testMap() {
        MapType mapType = BlockAssertions.createMapType((Type)BigintType.BIGINT, (Type)BigintType.BIGINT);
        TestRowBasedSerialization.assertRoundTrip((List<Type>)ImmutableList.of((Object)mapType), (List<Block>)ImmutableList.of((Object)BlockAssertions.createMapBlock(mapType, ImmutableMap.of((Object)312L, (Object)123L))));
        TestRowBasedSerialization.assertRoundTrip((List<Type>)ImmutableList.of((Object)mapType), (List<Block>)ImmutableList.of((Object)BlockAssertions.createMapBlock(mapType, Collections.singletonMap(312L, null))));
        HashMap<Long, Long> map = new HashMap<Long, Long>();
        map.put(1L, null);
        map.put(2L, 2L);
        map.put(3L, null);
        map.put(4L, 4L);
        TestRowBasedSerialization.assertRoundTrip((List<Type>)ImmutableList.of((Object)mapType), (List<Block>)ImmutableList.of((Object)BlockAssertions.createMapBlock(mapType, map)));
    }

    @Test
    public void testRow() {
        Type rowType = this.functionAndTypeManager.getType(TypeSignature.parseTypeSignature((String)"row(x BIGINT, y VARCHAR)"));
        TestRowBasedSerialization.assertRoundTrip((List<Type>)ImmutableList.of((Object)rowType), (List<Block>)ImmutableList.of((Object)BlockAssertions.createRowBlock(rowType.getTypeParameters(), new Object[0][])));
        TestRowBasedSerialization.assertRoundTrip((List<Type>)ImmutableList.of((Object)rowType), (List<Block>)ImmutableList.of((Object)BlockAssertions.createRowBlock(rowType.getTypeParameters(), new Object[][]{null})));
        TestRowBasedSerialization.assertRoundTrip((List<Type>)ImmutableList.of((Object)rowType), (List<Block>)ImmutableList.of((Object)BlockAssertions.createRowBlock(rowType.getTypeParameters(), new Object[][]{{null, null}})));
        TestRowBasedSerialization.assertRoundTrip((List<Type>)ImmutableList.of((Object)rowType), (List<Block>)ImmutableList.of((Object)BlockAssertions.createRowBlock(rowType.getTypeParameters(), new Object[][]{{null, "string"}})));
        TestRowBasedSerialization.assertRoundTrip((List<Type>)ImmutableList.of((Object)rowType), (List<Block>)ImmutableList.of((Object)BlockAssertions.createRowBlock(rowType.getTypeParameters(), new Object[][]{{123L, "string"}})));
        TestRowBasedSerialization.assertRoundTrip((List<Type>)ImmutableList.of((Object)rowType), (List<Block>)ImmutableList.of((Object)BlockAssertions.createRowBlock(rowType.getTypeParameters(), new Object[][]{{123L, null}})));
        TestRowBasedSerialization.assertRoundTrip((List<Type>)ImmutableList.of((Object)rowType), (List<Block>)ImmutableList.of((Object)BlockAssertions.createRowBlock(rowType.getTypeParameters(), {123L, null}, {123L, "string"}, null, {null, "string"}, {null, null}, null)));
    }

    @DataProvider
    public Object[][] getTypeSignatures() {
        return (Object[][])ImmutableList.of((Object)"boolean", (Object)"smallint", (Object)"integer", (Object)"bigint", (Object)"varchar", (Object)"decimal(2,1)", (Object)"decimal(30,2)", (Object)"array(bigint)", (Object)"array(decimal(30,2))", (Object)"array(varchar)", (Object)"map(bigint, decimal(30,2))", (Object)"map(decimal(30,2), bigint)", (Object[])new String[]{"map(varchar, decimal(30,2))", "map(decimal(30,2), varchar)", "map(varchar, bigint)", "map(bigint, varchar)", "map(varchar, varchar)", "row(x BIGINT)", "row(x VARCHAR)", "row(x BIGINT, y INTEGER)", "row(x BIGINT, y INTEGER, z VARCHAR)", "row(x VARCHAR, y INTEGER, z decimal(30,2))", "array(map(bigint, decimal(30,2)))", "map(array(varchar), bigint)", "map(array(varchar), array(array(varchar)))", "row(x array(varchar), y map(varchar, varchar), z row(x BIGINT))", "row(x array(varchar), y map(varchar, array(row(x BIGINT))), z row(x map(varchar, bigint)))"}).stream().collect(TestngUtils.toDataProvider());
    }

    @Test(dataProvider="getTypeSignatures")
    public void testAllNulls(String typeSignature) {
        Type type = this.functionAndTypeManager.getType(TypeSignature.parseTypeSignature((String)typeSignature));
        ImmutableList types = ImmutableList.of((Object)type);
        TestRowBasedSerialization.assertRoundTrip((List<Type>)types, (List<Block>)ImmutableList.of((Object)BlockAssertions.createAllNullsBlock(type, 0)));
        TestRowBasedSerialization.assertRoundTrip((List<Type>)types, (List<Block>)ImmutableList.of((Object)BlockAssertions.createAllNullsBlock(type, 1)));
        TestRowBasedSerialization.assertRoundTrip((List<Type>)types, (List<Block>)ImmutableList.of((Object)BlockAssertions.createAllNullsBlock(type, 2)));
        TestRowBasedSerialization.assertRoundTrip((List<Type>)types, (List<Block>)ImmutableList.of((Object)BlockAssertions.createAllNullsBlock(type, 11)));
    }

    @Test(dataProvider="getTypeSignatures")
    public void testRandom(String typeSignature) {
        Type type = this.functionAndTypeManager.getType(TypeSignature.parseTypeSignature((String)typeSignature));
        TestRowBasedSerialization.testRandomBlocks(type, (List<BlockAssertions.Encoding>)ImmutableList.of());
    }

    @Test(dataProvider="getTypeSignatures")
    public void testRle(String typeSignature) {
        Type type = this.functionAndTypeManager.getType(TypeSignature.parseTypeSignature((String)typeSignature));
        TestRowBasedSerialization.testRandomBlocks(type, (List<BlockAssertions.Encoding>)ImmutableList.of((Object)((Object)BlockAssertions.Encoding.RUN_LENGTH)));
        TestRowBasedSerialization.testRandomBlocks(type, (List<BlockAssertions.Encoding>)ImmutableList.of((Object)((Object)BlockAssertions.Encoding.RUN_LENGTH), (Object)((Object)BlockAssertions.Encoding.RUN_LENGTH)));
        TestRowBasedSerialization.testRandomBlocks(type, (List<BlockAssertions.Encoding>)ImmutableList.of((Object)((Object)BlockAssertions.Encoding.RUN_LENGTH), (Object)((Object)BlockAssertions.Encoding.RUN_LENGTH), (Object)((Object)BlockAssertions.Encoding.RUN_LENGTH)));
    }

    @Test(dataProvider="getTypeSignatures")
    public void testDictionary(String typeSignature) {
        Type type = this.functionAndTypeManager.getType(TypeSignature.parseTypeSignature((String)typeSignature));
        TestRowBasedSerialization.testRandomBlocks(type, (List<BlockAssertions.Encoding>)ImmutableList.of((Object)((Object)BlockAssertions.Encoding.DICTIONARY)));
        TestRowBasedSerialization.testRandomBlocks(type, (List<BlockAssertions.Encoding>)ImmutableList.of((Object)((Object)BlockAssertions.Encoding.DICTIONARY), (Object)((Object)BlockAssertions.Encoding.DICTIONARY)));
        TestRowBasedSerialization.testRandomBlocks(type, (List<BlockAssertions.Encoding>)ImmutableList.of((Object)((Object)BlockAssertions.Encoding.DICTIONARY), (Object)((Object)BlockAssertions.Encoding.DICTIONARY), (Object)((Object)BlockAssertions.Encoding.DICTIONARY)));
    }

    @Test(dataProvider="getTypeSignatures")
    public void testMixedDictionaryAndRle(String typeSignature) {
        Type type = this.functionAndTypeManager.getType(TypeSignature.parseTypeSignature((String)typeSignature));
        TestRowBasedSerialization.testRandomBlocks(type, (List<BlockAssertions.Encoding>)ImmutableList.of((Object)((Object)BlockAssertions.Encoding.DICTIONARY), (Object)((Object)BlockAssertions.Encoding.RUN_LENGTH)));
        TestRowBasedSerialization.testRandomBlocks(type, (List<BlockAssertions.Encoding>)ImmutableList.of((Object)((Object)BlockAssertions.Encoding.RUN_LENGTH), (Object)((Object)BlockAssertions.Encoding.DICTIONARY)));
        TestRowBasedSerialization.testRandomBlocks(type, (List<BlockAssertions.Encoding>)ImmutableList.of((Object)((Object)BlockAssertions.Encoding.DICTIONARY), (Object)((Object)BlockAssertions.Encoding.RUN_LENGTH), (Object)((Object)BlockAssertions.Encoding.DICTIONARY)));
        TestRowBasedSerialization.testRandomBlocks(type, (List<BlockAssertions.Encoding>)ImmutableList.of((Object)((Object)BlockAssertions.Encoding.RUN_LENGTH), (Object)((Object)BlockAssertions.Encoding.DICTIONARY), (Object)((Object)BlockAssertions.Encoding.RUN_LENGTH), (Object)((Object)BlockAssertions.Encoding.DICTIONARY), (Object)((Object)BlockAssertions.Encoding.DICTIONARY)));
    }

    private static void testRandomBlocks(Type type, List<BlockAssertions.Encoding> wrappings) {
        ImmutableList types = ImmutableList.of((Object)type);
        TestRowBasedSerialization.assertRoundTrip((List<Type>)types, (List<Block>)ImmutableList.of((Object)BlockAssertions.createRandomBlockForType(type, 10, 0.0f, 0.0f, false, wrappings)));
        TestRowBasedSerialization.assertRoundTrip((List<Type>)types, (List<Block>)ImmutableList.of((Object)BlockAssertions.createRandomBlockForType(type, 11, 0.0f, 0.0f, false, wrappings)));
        TestRowBasedSerialization.assertRoundTrip((List<Type>)types, (List<Block>)ImmutableList.of((Object)BlockAssertions.createRandomBlockForType(type, 100, 0.5f, 0.0f, false, wrappings)));
        TestRowBasedSerialization.assertRoundTrip((List<Type>)types, (List<Block>)ImmutableList.of((Object)BlockAssertions.createRandomBlockForType(type, 33, 0.0f, 0.0f, false, wrappings)));
        TestRowBasedSerialization.assertRoundTrip((List<Type>)types, (List<Block>)ImmutableList.of((Object)BlockAssertions.createRandomBlockForType(type, 27, 0.5f, 0.0f, false, wrappings)));
        TestRowBasedSerialization.assertRoundTrip((List<Type>)types, (List<Block>)ImmutableList.of((Object)BlockAssertions.createRandomBlockForType(type, 100, 0.0f, 0.5f, false, wrappings)));
        TestRowBasedSerialization.assertRoundTrip((List<Type>)types, (List<Block>)ImmutableList.of((Object)BlockAssertions.createRandomBlockForType(type, 100, 0.5f, 0.5f, false, wrappings)));
    }

    private static void assertRoundTrip(List<Type> types, List<Block> blocks) {
        Assert.assertEquals((int)types.size(), (int)blocks.size());
        List<Slice> rows = TestRowBasedSerialization.serialize(blocks);
        List<Block> deserialized = TestRowBasedSerialization.deserialize(types, rows);
        Assert.assertEquals((int)blocks.size(), (int)deserialized.size());
        for (int i = 0; i < types.size(); ++i) {
            BlockAssertions.assertBlockEquals(types.get(i), deserialized.get(i), blocks.get(i));
        }
    }

    private static List<Slice> serialize(List<Block> blocks) {
        if (blocks.isEmpty()) {
            return ImmutableList.of();
        }
        int positions = blocks.get(0).getPositionCount();
        for (Block block : blocks) {
            Assert.assertEquals((int)block.getPositionCount(), (int)positions);
        }
        ImmutableList.Builder result = ImmutableList.builder();
        for (int position = 0; position < positions; ++position) {
            result.add((Object)TestRowBasedSerialization.serializePosition(position, blocks));
        }
        return result.build();
    }

    private static List<Block> deserialize(List<Type> types, List<Slice> rows) {
        if (types.isEmpty()) {
            Assert.assertTrue((boolean)rows.isEmpty());
            return ImmutableList.of();
        }
        List blockBuilders = (List)types.stream().map(type -> type.createBlockBuilder(null, rows.size())).collect(ImmutableList.toImmutableList());
        for (Slice row : rows) {
            TestRowBasedSerialization.appendRow(row, blockBuilders);
        }
        return (List)blockBuilders.stream().map(BlockBuilder::build).collect(ImmutableList.toImmutableList());
    }

    private static Slice serializePosition(int position, List<Block> blocks) {
        Slice slice;
        DynamicSliceOutput output = new DynamicSliceOutput(256);
        try {
            for (Block block : blocks) {
                block.writePositionTo(position, (SliceOutput)output);
            }
            output.close();
            slice = output.slice();
        }
        catch (Throwable throwable) {
            try {
                try {
                    output.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        output.close();
        return slice;
    }

    private static void appendRow(Slice row, List<BlockBuilder> blockBuilders) {
        try (BasicSliceInput input = new BasicSliceInput(row);){
            for (BlockBuilder blockBuilder : blockBuilders) {
                blockBuilder.readPositionFrom((SliceInput)input);
            }
        }
    }
}

