/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.connector.system;

import com.facebook.presto.Session;
import com.facebook.presto.common.transaction.TransactionId;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.connector.system.GlobalSystemTransactionHandle;
import com.facebook.presto.connector.system.SystemConnectorSessionUtil;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.security.ConnectorIdentity;
import com.facebook.presto.spi.session.PropertyMetadata;
import com.facebook.presto.testing.TestingConnectorSession;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.security.Principal;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestSystemSession {
    @Test
    public void testSystemSessionForExtraCredentials() {
        ImmutableMap extraCredentials = ImmutableMap.of((Object)"key1", (Object)"value1", (Object)"key2", (Object)"value2");
        String user = "user";
        String principal = "principal";
        GlobalSystemTransactionHandle transactionHandle = new GlobalSystemTransactionHandle("connector-id", new TransactionId(UUID.randomUUID()));
        ConnectorIdentity connectorIdentity = new ConnectorIdentity(user, Optional.of(() -> principal), Optional.empty(), (Map)extraCredentials, (Map)ImmutableMap.of(), Optional.of("selectedUserName"), Optional.of("reasonForSelection"));
        TestingConnectorSession testingConnectorSession = new TestingConnectorSession(connectorIdentity, (List)ImmutableList.of((Object)new PropertyMetadata("property-name", "This is a description", (Type)VarcharType.createUnboundedVarcharType(), String.class, (Object)"defaultValue", false, Object::toString, value -> value)));
        Session resultSession = SystemConnectorSessionUtil.toSession((ConnectorTransactionHandle)transactionHandle, (ConnectorSession)testingConnectorSession);
        Assert.assertNotNull((Object)resultSession);
        Assert.assertEquals((String)resultSession.getIdentity().getUser(), (String)"user");
        Assert.assertEquals((String)((Principal)resultSession.getIdentity().getPrincipal().get()).getName(), (String)principal);
        Assert.assertEquals((Map)resultSession.getIdentity().getExtraCredentials(), (Map)extraCredentials);
    }
}

