/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cost;

import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.QueryId;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.connector.ConnectorFactory;
import com.facebook.presto.spi.plan.PlanNodeWithHash;
import com.facebook.presto.spi.plan.TableScanNode;
import com.facebook.presto.spi.statistics.Estimate;
import com.facebook.presto.spi.statistics.HistoricalPlanStatistics;
import com.facebook.presto.spi.statistics.HistoricalPlanStatisticsEntry;
import com.facebook.presto.spi.statistics.HistoricalPlanStatisticsEntryInfo;
import com.facebook.presto.spi.statistics.HistoryBasedPlanStatisticsProvider;
import com.facebook.presto.spi.statistics.JoinNodeStatistics;
import com.facebook.presto.spi.statistics.PartialAggregationStatistics;
import com.facebook.presto.spi.statistics.PlanStatistics;
import com.facebook.presto.spi.statistics.TableWriterNodeStatistics;
import com.facebook.presto.sql.Optimizer;
import com.facebook.presto.sql.planner.Plan;
import com.facebook.presto.sql.planner.assertions.PlanAssert;
import com.facebook.presto.sql.planner.assertions.PlanMatchPattern;
import com.facebook.presto.testing.LocalQueryRunner;
import com.facebook.presto.testing.TestingSession;
import com.facebook.presto.tpch.TpchConnectorFactory;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.testng.annotations.Test;

public class TestHistoryBasedStatsProvider {
    private final LocalQueryRunner queryRunner = new LocalQueryRunner(TestingSession.testSessionBuilder().setSystemProperty("use_history_based_plan_statistics", "true").setSystemProperty("restrict_history_based_optimization_to_complex_query", "false").setCatalog("local").setSchema("tiny").setSystemProperty("task_concurrency", "1").build());

    public TestHistoryBasedStatsProvider() {
        this.queryRunner.createCatalog((String)this.queryRunner.getDefaultSession().getCatalog().get(), (ConnectorFactory)new TpchConnectorFactory(1), (Map)ImmutableMap.of());
        this.queryRunner.installPlugin(new Plugin(){

            public Iterable<HistoryBasedPlanStatisticsProvider> getHistoryBasedPlanStatisticsProviders() {
                return ImmutableList.of((Object)new TestHistoryBasedPlanStatisticsProvider());
            }
        });
    }

    @Test
    public void testHistoryBasedStatsCalculator() {
        this.assertPlan("SELECT orderstatus FROM orders", PlanMatchPattern.anyTree(PlanMatchPattern.node(TableScanNode.class, new PlanMatchPattern[0]).withOutputRowCount(100.0)));
        this.assertPlan("SELECT * FROM nation", PlanMatchPattern.anyTree(PlanMatchPattern.node(TableScanNode.class, new PlanMatchPattern[0]).withOutputRowCount(25.0)));
    }

    private void assertPlan(String sql, PlanMatchPattern pattern) {
        this.assertPlan(sql, Optimizer.PlanStage.OPTIMIZED_AND_VALIDATED, pattern);
    }

    private void assertPlan(String sql, Optimizer.PlanStage stage, PlanMatchPattern pattern) {
        this.queryRunner.inTransaction(transactionSession -> {
            Plan actualPlan = this.queryRunner.createPlan(transactionSession, sql, stage, WarningCollector.NOOP);
            PlanAssert.assertPlan(transactionSession, this.queryRunner.getMetadata(), this.queryRunner.getStatsCalculator(), actualPlan, pattern);
            return null;
        });
    }

    private static class TestHistoryBasedPlanStatisticsProvider
    implements HistoryBasedPlanStatisticsProvider {
        public String getName() {
            return "test";
        }

        public Map<PlanNodeWithHash, HistoricalPlanStatistics> getStats(List<PlanNodeWithHash> planNodeHashes, long timeoutInMilliSeconds) {
            return (Map)planNodeHashes.stream().collect(ImmutableMap.toImmutableMap(PlanNodeWithHash2 -> PlanNodeWithHash2, PlanNodeWithHash2 -> {
                TableScanNode node;
                if (PlanNodeWithHash2.getPlanNode() instanceof TableScanNode && (node = (TableScanNode)PlanNodeWithHash2.getPlanNode()).getTable().toString().contains("orders")) {
                    return new HistoricalPlanStatistics((List)ImmutableList.of((Object)new HistoricalPlanStatisticsEntry(new PlanStatistics(Estimate.of((double)100.0), Estimate.of((double)1000.0), 1.0, JoinNodeStatistics.empty(), TableWriterNodeStatistics.empty(), PartialAggregationStatistics.empty()), (List)ImmutableList.of((Object)new PlanStatistics(Estimate.of((double)15000.0), Estimate.unknown(), 1.0, JoinNodeStatistics.empty(), TableWriterNodeStatistics.empty(), PartialAggregationStatistics.empty())), new HistoricalPlanStatisticsEntryInfo(HistoricalPlanStatisticsEntryInfo.WorkerType.JAVA, QueryId.valueOf((String)"0"), "test"))));
                }
                return HistoricalPlanStatistics.empty();
            }));
        }

        public void putStats(Map<PlanNodeWithHash, HistoricalPlanStatistics> hashesAndStatistics) {
        }
    }
}

