/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cost;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.cost.BaseStatsCalculatorTest;
import com.facebook.presto.cost.ComposableStatsCalculator;
import com.facebook.presto.cost.FilterStatsCalculator;
import com.facebook.presto.cost.JoinStatsRule;
import com.facebook.presto.cost.PlanNodeStatsAssertion;
import com.facebook.presto.cost.PlanNodeStatsEstimate;
import com.facebook.presto.cost.ScalarStatsCalculator;
import com.facebook.presto.cost.StatsCalculatorTester;
import com.facebook.presto.cost.StatsNormalizer;
import com.facebook.presto.cost.VariableStatsEstimate;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.spi.plan.EquiJoinClause;
import com.facebook.presto.spi.plan.JoinType;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.ExpressionOptimizerProvider;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.InMemoryExpressionOptimizerProvider;
import com.facebook.presto.sql.relational.Expressions;
import com.facebook.presto.testing.TestingSession;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestJoinStatsRule
extends BaseStatsCalculatorTest {
    private static final VariableReferenceExpression LEFT_JOIN_COLUMN = new VariableReferenceExpression(Optional.empty(), "left_join_column", (Type)BigintType.BIGINT);
    private static final VariableReferenceExpression LEFT_JOIN_COLUMN_2 = new VariableReferenceExpression(Optional.empty(), "left_join_column_2", (Type)BigintType.BIGINT);
    private static final VariableReferenceExpression RIGHT_JOIN_COLUMN = new VariableReferenceExpression(Optional.empty(), "right_join_column", (Type)DoubleType.DOUBLE);
    private static final VariableReferenceExpression RIGHT_JOIN_COLUMN_2 = new VariableReferenceExpression(Optional.empty(), "right_join_column_2", (Type)DoubleType.DOUBLE);
    private static final VariableReferenceExpression LEFT_OTHER_COLUMN = new VariableReferenceExpression(Optional.empty(), "left_column", (Type)BigintType.BIGINT);
    private static final VariableReferenceExpression RIGHT_OTHER_COLUMN = new VariableReferenceExpression(Optional.empty(), "right_column", (Type)DoubleType.DOUBLE);
    private static final double LEFT_ROWS_COUNT = 500.0;
    private static final double RIGHT_ROWS_COUNT = 1000.0;
    private static final double TOTAL_ROWS_COUNT = 1500.0;
    private static final double LEFT_JOIN_COLUMN_NULLS = 0.3;
    private static final double LEFT_JOIN_COLUMN_2_NULLS = 0.4;
    private static final double LEFT_JOIN_COLUMN_NON_NULLS = 0.7;
    private static final double LEFT_JOIN_COLUMN_2_NON_NULLS = 0.6;
    private static final int LEFT_JOIN_COLUMN_NDV = 20;
    private static final int LEFT_JOIN_COLUMN_2_NDV = 50;
    private static final double RIGHT_JOIN_COLUMN_NULLS = 0.6;
    private static final double RIGHT_JOIN_COLUMN_2_NULLS = 0.8;
    private static final double RIGHT_JOIN_COLUMN_NON_NULLS = 0.4;
    private static final double RIGHT_JOIN_COLUMN_2_NON_NULLS = 0.19999999999999996;
    private static final int RIGHT_JOIN_COLUMN_NDV = 15;
    private static final int RIGHT_JOIN_COLUMN_2_NDV = 15;
    private static final VariableStatistics LEFT_JOIN_COLUMN_STATS = TestJoinStatsRule.variableStatistics(LEFT_JOIN_COLUMN, 0.0, 20.0, 0.3, 20.0);
    private static final VariableStatistics LEFT_JOIN_COLUMN_2_STATS = TestJoinStatsRule.variableStatistics(LEFT_JOIN_COLUMN_2, 0.0, 200.0, 0.4, 50.0);
    private static final VariableStatistics LEFT_OTHER_COLUMN_STATS = TestJoinStatsRule.variableStatistics(LEFT_OTHER_COLUMN, 42.0, 42.0, 0.42, 1.0);
    private static final VariableStatistics RIGHT_JOIN_COLUMN_STATS = TestJoinStatsRule.variableStatistics(RIGHT_JOIN_COLUMN, 5.0, 20.0, 0.6, 15.0);
    private static final VariableStatistics RIGHT_JOIN_COLUMN_2_STATS = TestJoinStatsRule.variableStatistics(RIGHT_JOIN_COLUMN_2, 100.0, 200.0, 0.8, 15.0);
    private static final VariableStatistics RIGHT_OTHER_COLUMN_STATS = TestJoinStatsRule.variableStatistics(RIGHT_OTHER_COLUMN, 24.0, 24.0, 0.24, 1.0);
    private static final PlanNodeStatsEstimate LEFT_STATS = TestJoinStatsRule.planNodeStats(500.0, LEFT_JOIN_COLUMN_STATS, LEFT_OTHER_COLUMN_STATS);
    private static final PlanNodeStatsEstimate RIGHT_STATS = TestJoinStatsRule.planNodeStats(1000.0, RIGHT_JOIN_COLUMN_STATS, RIGHT_OTHER_COLUMN_STATS);
    private static final MetadataManager METADATA = MetadataManager.createTestMetadataManager();
    private static final StatsNormalizer NORMALIZER = new StatsNormalizer();
    private static final ExpressionOptimizerProvider EXPRESSION_OPTIMIZER_PROVIDER = new InMemoryExpressionOptimizerProvider((Metadata)METADATA);
    private static final JoinStatsRule JOIN_STATS_RULE = new JoinStatsRule(new FilterStatsCalculator((Metadata)METADATA, new ScalarStatsCalculator((Metadata)METADATA, EXPRESSION_OPTIMIZER_PROVIDER), NORMALIZER), NORMALIZER, 1.0);
    private StatsCalculatorTester defaultJoinSelectivityEnabledTester;

    @BeforeClass
    public void setupClass() {
        this.defaultJoinSelectivityEnabledTester = new StatsCalculatorTester(this.getTestSession());
    }

    @AfterClass(alwaysRun=true)
    public void tearDownClass() {
        this.defaultJoinSelectivityEnabledTester.close();
        this.defaultJoinSelectivityEnabledTester = null;
    }

    @Test
    public void testStatsForInnerJoin() {
        double innerJoinRowCount = 7000.0;
        PlanNodeStatsEstimate innerJoinStats = TestJoinStatsRule.planNodeStats(innerJoinRowCount, TestJoinStatsRule.variableStatistics(LEFT_JOIN_COLUMN, 5.0, 20.0, 0.0, 15.0), TestJoinStatsRule.variableStatistics(RIGHT_JOIN_COLUMN, 5.0, 20.0, 0.0, 15.0), LEFT_OTHER_COLUMN_STATS, RIGHT_OTHER_COLUMN_STATS);
        this.assertJoinStats(JoinType.INNER, LEFT_STATS, RIGHT_STATS, innerJoinStats);
    }

    @Test
    public void testStatsForInnerJoinWithRepeatedClause() {
        double innerJoinRowCount = 6300.0;
        PlanNodeStatsEstimate innerJoinStats = TestJoinStatsRule.planNodeStats(innerJoinRowCount, TestJoinStatsRule.variableStatistics(LEFT_JOIN_COLUMN, 5.0, 20.0, 0.0, 15.0), TestJoinStatsRule.variableStatistics(RIGHT_JOIN_COLUMN, 5.0, 20.0, 0.0, 15.0), LEFT_OTHER_COLUMN_STATS, RIGHT_OTHER_COLUMN_STATS);
        this.tester().assertStatsFor(pb -> {
            VariableReferenceExpression leftJoinColumnVariable = pb.variable(LEFT_JOIN_COLUMN);
            VariableReferenceExpression rightJoinColumnVariable = pb.variable(RIGHT_JOIN_COLUMN);
            VariableReferenceExpression leftOtherColumnVariable = pb.variable(LEFT_OTHER_COLUMN);
            VariableReferenceExpression rightOtherColumnVariable = pb.variable(RIGHT_OTHER_COLUMN);
            return pb.join(JoinType.INNER, (PlanNode)pb.values(leftJoinColumnVariable, leftOtherColumnVariable), (PlanNode)pb.values(rightJoinColumnVariable, rightOtherColumnVariable), new EquiJoinClause(pb.variable(leftJoinColumnVariable), pb.variable(rightJoinColumnVariable)), new EquiJoinClause(pb.variable(leftJoinColumnVariable), pb.variable(rightJoinColumnVariable)));
        }).withSourceStats(0, LEFT_STATS).withSourceStats(1, RIGHT_STATS).check(stats -> stats.equalTo(innerJoinStats));
    }

    @Test
    public void testStatsForInnerJoinWithTwoEquiClauses() {
        double innerJoinRowCount = 1079.9999999999998;
        PlanNodeStatsEstimate innerJoinStats = TestJoinStatsRule.planNodeStats(innerJoinRowCount, TestJoinStatsRule.variableStatistics(LEFT_JOIN_COLUMN, 5.0, 20.0, 0.0, 15.0), TestJoinStatsRule.variableStatistics(RIGHT_JOIN_COLUMN, 5.0, 20.0, 0.0, 15.0), TestJoinStatsRule.variableStatistics(LEFT_JOIN_COLUMN_2, 100.0, 200.0, 0.0, 15.0), TestJoinStatsRule.variableStatistics(RIGHT_JOIN_COLUMN_2, 100.0, 200.0, 0.0, 15.0));
        this.tester().assertStatsFor(pb -> {
            VariableReferenceExpression leftJoinColumnVariable = pb.variable(LEFT_JOIN_COLUMN);
            VariableReferenceExpression rightJoinColumnVariable = pb.variable(RIGHT_JOIN_COLUMN);
            VariableReferenceExpression leftJoinColumnVariable2 = pb.variable(LEFT_JOIN_COLUMN_2);
            VariableReferenceExpression rightJoinColumnVariable2 = pb.variable(RIGHT_JOIN_COLUMN_2);
            return pb.join(JoinType.INNER, (PlanNode)pb.values(leftJoinColumnVariable, leftJoinColumnVariable2), (PlanNode)pb.values(rightJoinColumnVariable, rightJoinColumnVariable2), new EquiJoinClause(pb.variable(leftJoinColumnVariable2), pb.variable(rightJoinColumnVariable2)), new EquiJoinClause(pb.variable(leftJoinColumnVariable), pb.variable(rightJoinColumnVariable)));
        }).withSourceStats(0, TestJoinStatsRule.planNodeStats(500.0, LEFT_JOIN_COLUMN_STATS, LEFT_JOIN_COLUMN_2_STATS)).withSourceStats(1, TestJoinStatsRule.planNodeStats(1000.0, RIGHT_JOIN_COLUMN_STATS, RIGHT_JOIN_COLUMN_2_STATS)).check(stats -> stats.equalTo(innerJoinStats));
    }

    @Test
    public void testStatsForInnerJoinWithTwoEquiClausesAndNonEqualityFunction() {
        double innerJoinRowCount = 359.9999999639999;
        PlanNodeStatsEstimate innerJoinStats = TestJoinStatsRule.planNodeStats(innerJoinRowCount, TestJoinStatsRule.variableStatistics(LEFT_JOIN_COLUMN, 5.0, 10.0, 0.0, 4.9999999995), TestJoinStatsRule.variableStatistics(RIGHT_JOIN_COLUMN, 5.0, 20.0, 0.0, 15.0), TestJoinStatsRule.variableStatistics(LEFT_JOIN_COLUMN_2, 100.0, 200.0, 0.0, 15.0), TestJoinStatsRule.variableStatistics(RIGHT_JOIN_COLUMN_2, 100.0, 200.0, 0.0, 15.0));
        this.tester().assertStatsFor(pb -> {
            VariableReferenceExpression leftJoinColumn = pb.variable(LEFT_JOIN_COLUMN);
            VariableReferenceExpression rightJoinColumn = pb.variable(RIGHT_JOIN_COLUMN);
            VariableReferenceExpression leftJoinColumn2 = pb.variable(LEFT_JOIN_COLUMN_2);
            VariableReferenceExpression rightJoinColumn2 = pb.variable(RIGHT_JOIN_COLUMN_2);
            CallExpression leftJoinColumnLessThanTen = pb.comparison(OperatorType.LESS_THAN, (RowExpression)leftJoinColumn, (RowExpression)Expressions.constant((Object)10L, (Type)IntegerType.INTEGER));
            return pb.join(JoinType.INNER, (PlanNode)pb.values(leftJoinColumn, leftJoinColumn2), (PlanNode)pb.values(rightJoinColumn, rightJoinColumn2), (List<EquiJoinClause>)ImmutableList.of((Object)new EquiJoinClause(leftJoinColumn2, rightJoinColumn2), (Object)new EquiJoinClause(leftJoinColumn, rightJoinColumn)), (List<VariableReferenceExpression>)ImmutableList.of((Object)leftJoinColumn, (Object)leftJoinColumn2, (Object)rightJoinColumn, (Object)rightJoinColumn2), Optional.of(leftJoinColumnLessThanTen));
        }).withSourceStats(0, TestJoinStatsRule.planNodeStats(500.0, LEFT_JOIN_COLUMN_STATS, LEFT_JOIN_COLUMN_2_STATS)).withSourceStats(1, TestJoinStatsRule.planNodeStats(1000.0, RIGHT_JOIN_COLUMN_STATS, RIGHT_JOIN_COLUMN_2_STATS)).check(stats -> stats.equalTo(innerJoinStats));
    }

    @Test
    public void testJoinComplementStats() {
        PlanNodeStatsEstimate expected = TestJoinStatsRule.planNodeStats(237.5, TestJoinStatsRule.variableStatistics(LEFT_JOIN_COLUMN, 0.0, 20.0, 0.631578947368421, 5.0), LEFT_OTHER_COLUMN_STATS);
        PlanNodeStatsEstimate actual = JOIN_STATS_RULE.calculateJoinComplementStats(Optional.empty(), (List)ImmutableList.of((Object)new EquiJoinClause(LEFT_JOIN_COLUMN, RIGHT_JOIN_COLUMN)), LEFT_STATS, RIGHT_STATS);
        Assert.assertEquals((Object)actual, (Object)expected);
    }

    @Test
    public void testRightJoinComplementStats() {
        PlanNodeStatsEstimate expected = NORMALIZER.normalize(TestJoinStatsRule.planNodeStats(600.0, TestJoinStatsRule.variableStatistics(RIGHT_JOIN_COLUMN, Double.NaN, Double.NaN, 1.0, 0.0), RIGHT_OTHER_COLUMN_STATS));
        PlanNodeStatsEstimate actual = JOIN_STATS_RULE.calculateJoinComplementStats(Optional.empty(), (List)ImmutableList.of((Object)new EquiJoinClause(RIGHT_JOIN_COLUMN, LEFT_JOIN_COLUMN)), RIGHT_STATS, LEFT_STATS);
        Assert.assertEquals((Object)actual, (Object)expected);
    }

    @Test
    public void testLeftJoinComplementStatsWithNoClauses() {
        PlanNodeStatsEstimate expected = NORMALIZER.normalize(LEFT_STATS.mapOutputRowCount(rowCount -> 0.0));
        PlanNodeStatsEstimate actual = JOIN_STATS_RULE.calculateJoinComplementStats(Optional.empty(), (List)ImmutableList.of(), LEFT_STATS, RIGHT_STATS);
        Assert.assertEquals((Object)actual, (Object)expected);
    }

    @Test
    public void testLeftJoinComplementStatsWithMultipleClauses() {
        PlanNodeStatsEstimate expected = TestJoinStatsRule.planNodeStats(237.5, TestJoinStatsRule.variableStatistics(LEFT_JOIN_COLUMN, 0.0, 20.0, 0.631578947368421, 5.0), LEFT_OTHER_COLUMN_STATS).mapOutputRowCount(rowCount -> rowCount / 0.9);
        PlanNodeStatsEstimate actual = JOIN_STATS_RULE.calculateJoinComplementStats(Optional.empty(), (List)ImmutableList.of((Object)new EquiJoinClause(LEFT_JOIN_COLUMN, RIGHT_JOIN_COLUMN), (Object)new EquiJoinClause(LEFT_OTHER_COLUMN, RIGHT_OTHER_COLUMN)), LEFT_STATS, RIGHT_STATS);
        Assert.assertEquals((Object)actual, (Object)expected);
    }

    @Test
    public void testStatsForLeftAndRightJoin() {
        double innerJoinRowCount = 7000.0;
        double joinComplementRowCount = 237.5;
        double joinComplementColumnNulls = 0.631578947368421;
        double totalRowCount = innerJoinRowCount + joinComplementRowCount;
        PlanNodeStatsEstimate leftJoinStats = TestJoinStatsRule.planNodeStats(totalRowCount, TestJoinStatsRule.variableStatistics(LEFT_JOIN_COLUMN, 0.0, 20.0, joinComplementColumnNulls * joinComplementRowCount / totalRowCount, 20.0), LEFT_OTHER_COLUMN_STATS, TestJoinStatsRule.variableStatistics(RIGHT_JOIN_COLUMN, 5.0, 20.0, joinComplementRowCount / totalRowCount, 15.0), TestJoinStatsRule.variableStatistics(RIGHT_OTHER_COLUMN, 24.0, 24.0, (0.24 * innerJoinRowCount + joinComplementRowCount) / totalRowCount, 1.0));
        this.assertJoinStats(JoinType.LEFT, LEFT_STATS, RIGHT_STATS, leftJoinStats);
        this.assertJoinStats(JoinType.RIGHT, RIGHT_JOIN_COLUMN, RIGHT_OTHER_COLUMN, LEFT_JOIN_COLUMN, LEFT_OTHER_COLUMN, RIGHT_STATS, LEFT_STATS, leftJoinStats);
    }

    @Test
    public void testLeftJoinMissingStats() {
        PlanNodeStatsEstimate leftStats = TestJoinStatsRule.planNodeStats(1.0, new VariableStatistics(LEFT_JOIN_COLUMN, VariableStatsEstimate.unknown()), new VariableStatistics(LEFT_OTHER_COLUMN, VariableStatsEstimate.unknown()));
        PlanNodeStatsEstimate rightStats = TestJoinStatsRule.planNodeStats(1.0, new VariableStatistics(RIGHT_JOIN_COLUMN, VariableStatsEstimate.unknown()), new VariableStatistics(RIGHT_OTHER_COLUMN, VariableStatsEstimate.unknown()));
        this.assertJoinStats(JoinType.LEFT, leftStats, rightStats, PlanNodeStatsEstimate.unknown());
    }

    private Session getTestSession() {
        return TestingSession.testSessionBuilder().setSystemProperty("default_join_selectivity_coefficient", "0.1").build();
    }

    @Test
    public void testInnerJoinMissingColumnStats() {
        PlanNodeStatsEstimate leftStats = TestJoinStatsRule.planNodeStats(100.0, new VariableStatistics(LEFT_JOIN_COLUMN, VariableStatsEstimate.unknown()), new VariableStatistics(RIGHT_JOIN_COLUMN, VariableStatsEstimate.unknown()));
        PlanNodeStatsEstimate rightStats = TestJoinStatsRule.planNodeStats(5.0, new VariableStatistics(LEFT_JOIN_COLUMN, VariableStatsEstimate.unknown()), new VariableStatistics(RIGHT_JOIN_COLUMN, VariableStatsEstimate.unknown()));
        double totalRowCount = leftStats.getOutputRowCount() * rightStats.getOutputRowCount() * SystemSessionProperties.getDefaultJoinSelectivityCoefficient((Session)this.getTestSession());
        PlanNodeStatsEstimate resultStats = TestJoinStatsRule.planNodeStats(totalRowCount, new VariableStatistics(LEFT_JOIN_COLUMN, VariableStatsEstimate.unknown()), new VariableStatistics(RIGHT_JOIN_COLUMN, VariableStatsEstimate.unknown()));
        this.assertJoinStats(JoinType.INNER, LEFT_JOIN_COLUMN, LEFT_OTHER_COLUMN, RIGHT_JOIN_COLUMN, RIGHT_OTHER_COLUMN, leftStats, rightStats, resultStats, this.defaultJoinSelectivityEnabledTester);
    }

    @Test
    public void testLeftJoinMissingColumnStats() {
        PlanNodeStatsEstimate leftStats = TestJoinStatsRule.planNodeStats(100.0, new VariableStatistics(LEFT_JOIN_COLUMN, VariableStatsEstimate.unknown()), new VariableStatistics(RIGHT_JOIN_COLUMN, VariableStatsEstimate.unknown()));
        PlanNodeStatsEstimate rightStats = TestJoinStatsRule.planNodeStats(5.0, new VariableStatistics(LEFT_JOIN_COLUMN, VariableStatsEstimate.unknown()), new VariableStatistics(RIGHT_JOIN_COLUMN, VariableStatsEstimate.unknown()));
        double totalRowCount = leftStats.getOutputRowCount() * rightStats.getOutputRowCount() * SystemSessionProperties.getDefaultJoinSelectivityCoefficient((Session)this.getTestSession());
        PlanNodeStatsEstimate resultStats = TestJoinStatsRule.planNodeStats(totalRowCount, new VariableStatistics(LEFT_JOIN_COLUMN, VariableStatsEstimate.unknown()), new VariableStatistics(RIGHT_JOIN_COLUMN, VariableStatsEstimate.unknown()));
        this.assertJoinStats(JoinType.LEFT, LEFT_JOIN_COLUMN, LEFT_OTHER_COLUMN, RIGHT_JOIN_COLUMN, RIGHT_OTHER_COLUMN, leftStats, rightStats, resultStats, this.defaultJoinSelectivityEnabledTester);
    }

    @Test
    public void testRightJoinMissingColumnStats() {
        PlanNodeStatsEstimate leftStats = TestJoinStatsRule.planNodeStats(100.0, new VariableStatistics(LEFT_JOIN_COLUMN, VariableStatsEstimate.unknown()), new VariableStatistics(RIGHT_JOIN_COLUMN, VariableStatsEstimate.unknown()));
        PlanNodeStatsEstimate rightStats = TestJoinStatsRule.planNodeStats(5.0, new VariableStatistics(LEFT_JOIN_COLUMN, VariableStatsEstimate.unknown()), new VariableStatistics(RIGHT_JOIN_COLUMN, VariableStatsEstimate.unknown()));
        double totalRowCount = leftStats.getOutputRowCount() * rightStats.getOutputRowCount() * SystemSessionProperties.getDefaultJoinSelectivityCoefficient((Session)this.getTestSession());
        PlanNodeStatsEstimate resultStats = TestJoinStatsRule.planNodeStats(totalRowCount, new VariableStatistics(LEFT_JOIN_COLUMN, VariableStatsEstimate.unknown()), new VariableStatistics(RIGHT_JOIN_COLUMN, VariableStatsEstimate.unknown()));
        this.assertJoinStats(JoinType.RIGHT, LEFT_JOIN_COLUMN, LEFT_OTHER_COLUMN, RIGHT_JOIN_COLUMN, RIGHT_OTHER_COLUMN, leftStats, rightStats, resultStats, this.defaultJoinSelectivityEnabledTester);
    }

    @Test
    public void testFullJoinMissingColumnStats() {
        PlanNodeStatsEstimate leftStats = TestJoinStatsRule.planNodeStats(100.0, new VariableStatistics(LEFT_JOIN_COLUMN, VariableStatsEstimate.unknown()), new VariableStatistics(RIGHT_JOIN_COLUMN, VariableStatsEstimate.unknown()));
        PlanNodeStatsEstimate rightStats = TestJoinStatsRule.planNodeStats(5.0, new VariableStatistics(LEFT_JOIN_COLUMN, VariableStatsEstimate.unknown()), new VariableStatistics(RIGHT_JOIN_COLUMN, VariableStatsEstimate.unknown()));
        double totalRowCount = leftStats.getOutputRowCount() * rightStats.getOutputRowCount() * SystemSessionProperties.getDefaultJoinSelectivityCoefficient((Session)this.getTestSession());
        PlanNodeStatsEstimate resultStats = TestJoinStatsRule.planNodeStats(totalRowCount, new VariableStatistics(LEFT_JOIN_COLUMN, VariableStatsEstimate.unknown()), new VariableStatistics(RIGHT_JOIN_COLUMN, VariableStatsEstimate.unknown()));
        this.assertJoinStats(JoinType.FULL, LEFT_JOIN_COLUMN, LEFT_OTHER_COLUMN, RIGHT_JOIN_COLUMN, RIGHT_OTHER_COLUMN, leftStats, rightStats, resultStats, this.defaultJoinSelectivityEnabledTester);
    }

    @Test
    public void testStatsForFullJoin() {
        double innerJoinRowCount = 7000.0;
        double leftJoinComplementRowCount = 237.5;
        double leftJoinComplementColumnNulls = 0.631578947368421;
        double rightJoinComplementRowCount = 600.0;
        double rightJoinComplementColumnNulls = 1.0;
        double totalRowCount = innerJoinRowCount + leftJoinComplementRowCount + rightJoinComplementRowCount;
        PlanNodeStatsEstimate leftJoinStats = TestJoinStatsRule.planNodeStats(totalRowCount, TestJoinStatsRule.variableStatistics(LEFT_JOIN_COLUMN, 0.0, 20.0, (leftJoinComplementColumnNulls * leftJoinComplementRowCount + rightJoinComplementRowCount) / totalRowCount, 20.0), TestJoinStatsRule.variableStatistics(LEFT_OTHER_COLUMN, 42.0, 42.0, (0.42 * (innerJoinRowCount + leftJoinComplementRowCount) + rightJoinComplementRowCount) / totalRowCount, 1.0), TestJoinStatsRule.variableStatistics(RIGHT_JOIN_COLUMN, 5.0, 20.0, (rightJoinComplementColumnNulls * rightJoinComplementRowCount + leftJoinComplementRowCount) / totalRowCount, 15.0), TestJoinStatsRule.variableStatistics(RIGHT_OTHER_COLUMN, 24.0, 24.0, (0.24 * (innerJoinRowCount + rightJoinComplementRowCount) + leftJoinComplementRowCount) / totalRowCount, 1.0));
        this.assertJoinStats(JoinType.FULL, LEFT_STATS, RIGHT_STATS, leftJoinStats);
    }

    @Test
    public void testAddJoinComplementStats() {
        double statsToAddNdv = 5.0;
        PlanNodeStatsEstimate statsToAdd = TestJoinStatsRule.planNodeStats(1000.0, TestJoinStatsRule.variableStatistics(LEFT_JOIN_COLUMN, 0.0, 5.0, 0.2, statsToAddNdv));
        PlanNodeStatsEstimate addedStats = TestJoinStatsRule.planNodeStats(1500.0, TestJoinStatsRule.variableStatistics(LEFT_JOIN_COLUMN, 0.0, 20.0, 0.23333333333333334, 20.0), TestJoinStatsRule.variableStatistics(LEFT_OTHER_COLUMN, 42.0, 42.0, 0.8066666666666666, 1.0));
        PlanNodeStatsAssertion.assertThat(JOIN_STATS_RULE.addJoinComplementStats(LEFT_STATS, LEFT_STATS, statsToAdd)).equalTo(addedStats);
    }

    private void assertJoinStats(JoinType joinType, PlanNodeStatsEstimate leftStats, PlanNodeStatsEstimate rightStats, PlanNodeStatsEstimate resultStats) {
        this.assertJoinStats(joinType, LEFT_JOIN_COLUMN, LEFT_OTHER_COLUMN, RIGHT_JOIN_COLUMN, RIGHT_OTHER_COLUMN, leftStats, rightStats, resultStats);
    }

    private void assertJoinStats(JoinType joinType, VariableReferenceExpression leftJoinColumn, VariableReferenceExpression leftOtherColumn, VariableReferenceExpression rightJoinColumn, VariableReferenceExpression rightOtherColumn, PlanNodeStatsEstimate leftStats, PlanNodeStatsEstimate rightStats, PlanNodeStatsEstimate resultStats) {
        this.assertJoinStats(joinType, leftJoinColumn, leftOtherColumn, rightJoinColumn, rightOtherColumn, leftStats, rightStats, resultStats, this.tester());
    }

    private void assertJoinStats(JoinType joinType, VariableReferenceExpression leftJoinColumn, VariableReferenceExpression leftOtherColumn, VariableReferenceExpression rightJoinColumn, VariableReferenceExpression rightOtherColumn, PlanNodeStatsEstimate leftStats, PlanNodeStatsEstimate rightStats, PlanNodeStatsEstimate resultStats, StatsCalculatorTester tester) {
        tester.assertStatsFor(pb -> {
            VariableReferenceExpression leftJoinColumnVariable = pb.variable(leftJoinColumn);
            VariableReferenceExpression rightJoinColumnVariable = pb.variable(rightJoinColumn);
            VariableReferenceExpression leftOtherColumnVariable = pb.variable(leftOtherColumn);
            VariableReferenceExpression rightOtherColumnVariable = pb.variable(rightOtherColumn);
            return pb.join(joinType, (PlanNode)pb.values(leftJoinColumnVariable, leftOtherColumnVariable), (PlanNode)pb.values(rightJoinColumnVariable, rightOtherColumnVariable), new EquiJoinClause(leftJoinColumnVariable, rightJoinColumnVariable));
        }).withSourceStats(0, leftStats).withSourceStats(1, rightStats).check((ComposableStatsCalculator.Rule<?>)JOIN_STATS_RULE, stats -> stats.equalTo(resultStats));
    }

    private static PlanNodeStatsEstimate planNodeStats(double rowCount, VariableStatistics ... variableStatistics) {
        PlanNodeStatsEstimate.Builder builder = PlanNodeStatsEstimate.builder().setOutputRowCount(rowCount);
        for (VariableStatistics symbolStatistic : variableStatistics) {
            builder.addVariableStatistics(symbolStatistic.variable, symbolStatistic.estimate);
        }
        return builder.build();
    }

    private static VariableStatistics variableStatistics(VariableReferenceExpression variable, double low, double high, double nullsFraction, double ndv) {
        return new VariableStatistics(variable, VariableStatsEstimate.builder().setLowValue(low).setHighValue(high).setNullsFraction(nullsFraction).setDistinctValuesCount(ndv).build());
    }

    private static class VariableStatistics {
        final VariableReferenceExpression variable;
        final VariableStatsEstimate estimate;

        VariableStatistics(String variableName, VariableStatsEstimate estimate) {
            this(new VariableReferenceExpression(Optional.empty(), variableName, (Type)BigintType.BIGINT), estimate);
        }

        VariableStatistics(VariableReferenceExpression variable, VariableStatsEstimate estimate) {
            this.variable = variable;
            this.estimate = estimate;
        }
    }
}

