/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cost;

import com.facebook.presto.cost.EstimateAssertion;
import com.facebook.presto.cost.StatisticRange;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestStatisticRange {
    @Test
    public void testOverlapPercentWith() {
        StatisticRange zeroToTen = TestStatisticRange.range(0.0, 10.0, 10.0);
        StatisticRange empty = StatisticRange.empty();
        TestStatisticRange.assertOverlap(zeroToTen, TestStatisticRange.range(0.0, 10.0, 5.0), 1.0);
        TestStatisticRange.assertOverlap(zeroToTen, TestStatisticRange.range(0.0, 10.0, 20.0), 1.0);
        TestStatisticRange.assertOverlap(zeroToTen, TestStatisticRange.range(0.0, 10.0, 20.0), 1.0);
        TestStatisticRange.assertOverlap(zeroToTen, TestStatisticRange.range(5.0, 3000.0, 3.0), 0.5);
        TestStatisticRange.assertOverlap(zeroToTen, TestStatisticRange.range(3.0, 3.0, 1.0), 1.0 / zeroToTen.getDistinctValuesCount());
        TestStatisticRange.assertOverlap(zeroToTen, TestStatisticRange.range(10.0, 100.0, 357.0), 1.0 / zeroToTen.getDistinctValuesCount());
        TestStatisticRange.assertOverlap(zeroToTen, TestStatisticRange.range(20.0, 30.0, 10.0), 0.0);
        TestStatisticRange.assertOverlap(zeroToTen, empty, 0.0);
        TestStatisticRange.assertOverlap(empty, zeroToTen, 0.0);
        TestStatisticRange.assertOverlap(TestStatisticRange.unboundedRange(10.0), empty, 0.0);
        TestStatisticRange.assertOverlap(TestStatisticRange.unboundedRange(10.0), TestStatisticRange.unboundedRange(20.0), 1.0);
        TestStatisticRange.assertOverlap(TestStatisticRange.unboundedRange(20.0), TestStatisticRange.unboundedRange(10.0), 0.5);
        TestStatisticRange.assertOverlap(TestStatisticRange.unboundedRange(0.1), TestStatisticRange.unboundedRange(1.0), 1.0);
        TestStatisticRange.assertOverlap(TestStatisticRange.unboundedRange(0.0), TestStatisticRange.unboundedRange(1.0), 0.0);
        TestStatisticRange.assertOverlap(TestStatisticRange.unboundedRange(0.0), TestStatisticRange.unboundedRange(0.0), 0.0);
    }

    @Test
    public void testIntersect() {
        StatisticRange zeroToTen = TestStatisticRange.range(0.0, 10.0, 10.0);
        StatisticRange fiveToFifteen = TestStatisticRange.range(5.0, 15.0, 60.0);
        Assert.assertEquals((Object)zeroToTen.intersect(fiveToFifteen), (Object)TestStatisticRange.range(5.0, 10.0, 10.0));
    }

    @Test
    public void testAddAndSumDistinctValues() {
        Assert.assertEquals((Object)TestStatisticRange.unboundedRange(Double.NaN).addAndSumDistinctValues(TestStatisticRange.unboundedRange(Double.NaN)), (Object)TestStatisticRange.unboundedRange(Double.NaN));
        Assert.assertEquals((Object)TestStatisticRange.unboundedRange(Double.NaN).addAndSumDistinctValues(TestStatisticRange.unboundedRange(1.0)), (Object)TestStatisticRange.unboundedRange(Double.NaN));
        Assert.assertEquals((Object)TestStatisticRange.unboundedRange(1.0).addAndSumDistinctValues(TestStatisticRange.unboundedRange(Double.NaN)), (Object)TestStatisticRange.unboundedRange(Double.NaN));
        Assert.assertEquals((Object)TestStatisticRange.unboundedRange(1.0).addAndSumDistinctValues(TestStatisticRange.unboundedRange(2.0)), (Object)TestStatisticRange.unboundedRange(3.0));
        Assert.assertEquals((Object)StatisticRange.empty().addAndSumDistinctValues(StatisticRange.empty()), (Object)StatisticRange.empty());
        Assert.assertEquals((Object)TestStatisticRange.range(0.0, 1.0, 1.0).addAndSumDistinctValues(StatisticRange.empty()), (Object)TestStatisticRange.range(0.0, 1.0, 1.0));
        Assert.assertEquals((Object)TestStatisticRange.range(0.0, 1.0, 1.0).addAndSumDistinctValues(TestStatisticRange.range(1.0, 2.0, 1.0)), (Object)TestStatisticRange.range(0.0, 2.0, 2.0));
    }

    @Test
    public void testAddAndMaxDistinctValues() {
        Assert.assertEquals((Object)TestStatisticRange.unboundedRange(Double.NaN).addAndMaxDistinctValues(TestStatisticRange.unboundedRange(Double.NaN)), (Object)TestStatisticRange.unboundedRange(Double.NaN));
        Assert.assertEquals((Object)TestStatisticRange.unboundedRange(Double.NaN).addAndMaxDistinctValues(TestStatisticRange.unboundedRange(1.0)), (Object)TestStatisticRange.unboundedRange(Double.NaN));
        Assert.assertEquals((Object)TestStatisticRange.unboundedRange(1.0).addAndMaxDistinctValues(TestStatisticRange.unboundedRange(Double.NaN)), (Object)TestStatisticRange.unboundedRange(Double.NaN));
        Assert.assertEquals((Object)TestStatisticRange.unboundedRange(1.0).addAndMaxDistinctValues(TestStatisticRange.unboundedRange(2.0)), (Object)TestStatisticRange.unboundedRange(2.0));
        Assert.assertEquals((Object)StatisticRange.empty().addAndMaxDistinctValues(StatisticRange.empty()), (Object)StatisticRange.empty());
        Assert.assertEquals((Object)TestStatisticRange.range(0.0, 1.0, 1.0).addAndMaxDistinctValues(StatisticRange.empty()), (Object)TestStatisticRange.range(0.0, 1.0, 1.0));
        Assert.assertEquals((Object)TestStatisticRange.range(0.0, 1.0, 1.0).addAndMaxDistinctValues(TestStatisticRange.range(1.0, 2.0, 1.0)), (Object)TestStatisticRange.range(0.0, 2.0, 1.0));
    }

    @Test
    public void testAddAndCollapseDistinctValues() {
        Assert.assertEquals((Object)TestStatisticRange.unboundedRange(Double.NaN).addAndCollapseDistinctValues(TestStatisticRange.unboundedRange(Double.NaN)), (Object)TestStatisticRange.unboundedRange(Double.NaN));
        Assert.assertEquals((Object)TestStatisticRange.unboundedRange(Double.NaN).addAndCollapseDistinctValues(TestStatisticRange.unboundedRange(1.0)), (Object)TestStatisticRange.unboundedRange(Double.NaN));
        Assert.assertEquals((Object)TestStatisticRange.unboundedRange(1.0).addAndCollapseDistinctValues(TestStatisticRange.unboundedRange(Double.NaN)), (Object)TestStatisticRange.unboundedRange(Double.NaN));
        Assert.assertEquals((Object)TestStatisticRange.unboundedRange(1.0).addAndCollapseDistinctValues(TestStatisticRange.unboundedRange(2.0)), (Object)TestStatisticRange.unboundedRange(2.0));
        Assert.assertEquals((Object)StatisticRange.empty().addAndCollapseDistinctValues(StatisticRange.empty()), (Object)StatisticRange.empty());
        Assert.assertEquals((Object)TestStatisticRange.range(0.0, 1.0, 1.0).addAndCollapseDistinctValues(StatisticRange.empty()), (Object)TestStatisticRange.range(0.0, 1.0, 1.0));
        Assert.assertEquals((Object)TestStatisticRange.range(0.0, 1.0, 1.0).addAndCollapseDistinctValues(TestStatisticRange.range(1.0, 2.0, 1.0)), (Object)TestStatisticRange.range(0.0, 2.0, 1.0));
        Assert.assertEquals((Object)TestStatisticRange.range(0.0, 3.0, 3.0).addAndCollapseDistinctValues(TestStatisticRange.range(2.0, 6.0, 4.0)), (Object)TestStatisticRange.range(0.0, 6.0, 6.0));
    }

    @Test
    public void testIntersectOpenness() {
        StatisticRange first = TestStatisticRange.range(0.0, true, 10.0, true, 10.0);
        StatisticRange second = TestStatisticRange.range(0.0, true, 5.0, true, 5.0);
        StatisticRange intersect = first.intersect(second);
        Assert.assertTrue((boolean)intersect.getOpenLow());
        Assert.assertTrue((boolean)intersect.getOpenHigh());
        intersect = second.intersect(first);
        Assert.assertTrue((boolean)intersect.getOpenLow());
        Assert.assertTrue((boolean)intersect.getOpenHigh());
        second = TestStatisticRange.range(-1.0, true, 5.0, false, 5.0);
        intersect = first.intersect(second);
        Assert.assertTrue((boolean)intersect.getOpenLow());
        Assert.assertFalse((boolean)intersect.getOpenHigh());
        intersect = second.intersect(first);
        Assert.assertTrue((boolean)intersect.getOpenLow());
        Assert.assertFalse((boolean)intersect.getOpenHigh());
        second = TestStatisticRange.range(1.0, false, 5.0, false, 5.0);
        intersect = first.intersect(second);
        Assert.assertFalse((boolean)intersect.getOpenLow());
        Assert.assertFalse((boolean)intersect.getOpenHigh());
        intersect = second.intersect(first);
        Assert.assertFalse((boolean)intersect.getOpenLow());
        Assert.assertFalse((boolean)intersect.getOpenHigh());
        second = TestStatisticRange.range(1.0, false, 5.0, true, 5.0);
        intersect = first.intersect(second);
        Assert.assertFalse((boolean)intersect.getOpenLow());
        Assert.assertTrue((boolean)intersect.getOpenHigh());
        intersect = second.intersect(first);
        Assert.assertFalse((boolean)intersect.getOpenLow());
        Assert.assertTrue((boolean)intersect.getOpenHigh());
        first = TestStatisticRange.range(0.0, false, 5.0, false, 5.0);
        second = TestStatisticRange.range(0.0, true, 5.0, true, 5.0);
        intersect = first.intersect(second);
        Assert.assertTrue((boolean)intersect.getOpenLow());
        Assert.assertTrue((boolean)intersect.getOpenHigh());
        intersect = second.intersect(first);
        Assert.assertTrue((boolean)intersect.getOpenLow());
        Assert.assertTrue((boolean)intersect.getOpenHigh());
    }

    private static StatisticRange range(double low, double high, double distinctValues) {
        return new StatisticRange(low, high, distinctValues);
    }

    private static StatisticRange range(double low, boolean openLow, double high, boolean openHigh, double distinctValues) {
        return new StatisticRange(low, openLow, high, openHigh, distinctValues);
    }

    private static StatisticRange unboundedRange(double distinctValues) {
        return new StatisticRange(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, distinctValues);
    }

    private static void assertOverlap(StatisticRange a, StatisticRange b, double expected) {
        EstimateAssertion.assertEstimateEquals(a.overlapPercentWith(b), expected, "overlapPercentWith", new Object[0]);
    }
}

