/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cost;

import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.UnknownType;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.cost.BaseStatsCalculatorTest;
import com.facebook.presto.cost.PlanNodeStatsEstimate;
import com.facebook.presto.cost.VariableStatsEstimate;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.spi.statistics.SourceInfo;
import com.facebook.presto.sql.planner.iterative.rule.test.PlanBuilder;
import com.facebook.presto.sql.relational.Expressions;
import com.facebook.presto.sql.relational.FunctionResolution;
import com.facebook.presto.sql.tree.ArithmeticBinaryExpression;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slices;
import java.util.List;
import java.util.Optional;
import org.testng.annotations.Test;

public class TestValuesNodeStats
extends BaseStatsCalculatorTest {
    @Test
    public void testStatsForValuesNode() {
        FunctionResolution resolution = new FunctionResolution(this.tester().getMetadata().getFunctionAndTypeManager().getFunctionAndTypeResolver());
        this.tester().assertStatsFor(pb -> pb.values((List<VariableReferenceExpression>)ImmutableList.of((Object)pb.variable("a", (Type)BigintType.BIGINT), (Object)pb.variable("b", (Type)DoubleType.DOUBLE)), (List<List<RowExpression>>)ImmutableList.of((Object)ImmutableList.of((Object)Expressions.call((String)ArithmeticBinaryExpression.Operator.ADD.name(), (FunctionHandle)resolution.arithmeticFunction(ArithmeticBinaryExpression.Operator.ADD, (Type)BigintType.BIGINT, (Type)BigintType.BIGINT), (Type)BigintType.BIGINT, PlanBuilder.constantExpressions((Type)BigintType.BIGINT, 3L, 3L)), (Object)Expressions.constant((Object)13.5, (Type)DoubleType.DOUBLE)), (Object)ImmutableList.of((Object)Expressions.constant((Object)55L, (Type)BigintType.BIGINT), (Object)Expressions.constantNull((Type)DoubleType.DOUBLE)), (Object)ImmutableList.of((Object)Expressions.constant((Object)6L, (Type)BigintType.BIGINT), (Object)Expressions.constant((Object)13.5, (Type)DoubleType.DOUBLE))))).check(outputStats -> outputStats.equalTo(PlanNodeStatsEstimate.builder().setOutputRowCount(3.0).setConfidence(SourceInfo.ConfidenceLevel.FACT).addVariableStatistics(new VariableReferenceExpression(Optional.empty(), "a", (Type)BigintType.BIGINT), VariableStatsEstimate.builder().setNullsFraction(0.0).setLowValue(6.0).setHighValue(55.0).setDistinctValuesCount(2.0).build()).addVariableStatistics(new VariableReferenceExpression(Optional.empty(), "b", (Type)DoubleType.DOUBLE), VariableStatsEstimate.builder().setNullsFraction(0.3333333333333333).setLowValue(13.5).setHighValue(13.5).setDistinctValuesCount(1.0).build()).build()));
        this.tester().assertStatsFor(pb -> pb.values((List<VariableReferenceExpression>)ImmutableList.of((Object)pb.variable("v", (Type)VarcharType.createVarcharType((int)30))), (List<List<RowExpression>>)ImmutableList.of(PlanBuilder.constantExpressions((Type)VarcharType.VARCHAR, Slices.utf8Slice((String)"Alice")), PlanBuilder.constantExpressions((Type)VarcharType.VARCHAR, Slices.utf8Slice((String)"has")), PlanBuilder.constantExpressions((Type)VarcharType.VARCHAR, Slices.utf8Slice((String)"a cat")), (Object)ImmutableList.of((Object)Expressions.constantNull((Type)VarcharType.VARCHAR))))).check(outputStats -> outputStats.equalTo(PlanNodeStatsEstimate.builder().setOutputRowCount(4.0).setConfidence(SourceInfo.ConfidenceLevel.FACT).addVariableStatistics(new VariableReferenceExpression(Optional.empty(), "v", (Type)VarcharType.createVarcharType((int)30)), VariableStatsEstimate.builder().setNullsFraction(0.25).setDistinctValuesCount(3.0).build()).build()));
    }

    @Test
    public void testStatsForValuesNodeWithJustNulls() {
        FunctionResolution resolution = new FunctionResolution(this.tester().getMetadata().getFunctionAndTypeManager().getFunctionAndTypeResolver());
        PlanNodeStatsEstimate bigintNullAStats = PlanNodeStatsEstimate.builder().setOutputRowCount(1.0).setConfidence(SourceInfo.ConfidenceLevel.FACT).addVariableStatistics(new VariableReferenceExpression(Optional.empty(), "a", (Type)BigintType.BIGINT), VariableStatsEstimate.zero()).build();
        this.tester().assertStatsFor(pb -> pb.values((List<VariableReferenceExpression>)ImmutableList.of((Object)pb.variable("a", (Type)BigintType.BIGINT)), (List<List<RowExpression>>)ImmutableList.of((Object)ImmutableList.of((Object)Expressions.call((String)ArithmeticBinaryExpression.Operator.ADD.name(), (FunctionHandle)resolution.arithmeticFunction(ArithmeticBinaryExpression.Operator.ADD, (Type)BigintType.BIGINT, (Type)BigintType.BIGINT), (Type)BigintType.BIGINT, (RowExpression[])new RowExpression[]{Expressions.constant((Object)3L, (Type)BigintType.BIGINT), Expressions.constantNull((Type)BigintType.BIGINT)}))))).check(outputStats -> outputStats.equalTo(bigintNullAStats));
        this.tester().assertStatsFor(pb -> pb.values((List<VariableReferenceExpression>)ImmutableList.of((Object)pb.variable("a", (Type)BigintType.BIGINT)), (List<List<RowExpression>>)ImmutableList.of((Object)ImmutableList.of((Object)Expressions.constantNull((Type)BigintType.BIGINT))))).check(outputStats -> outputStats.equalTo(bigintNullAStats));
        PlanNodeStatsEstimate unknownNullAStats = PlanNodeStatsEstimate.builder().setOutputRowCount(1.0).setConfidence(SourceInfo.ConfidenceLevel.FACT).addVariableStatistics(new VariableReferenceExpression(Optional.empty(), "a", (Type)UnknownType.UNKNOWN), VariableStatsEstimate.zero()).build();
        this.tester().assertStatsFor(pb -> pb.values((List<VariableReferenceExpression>)ImmutableList.of((Object)pb.variable("a", (Type)UnknownType.UNKNOWN)), (List<List<RowExpression>>)ImmutableList.of((Object)ImmutableList.of((Object)Expressions.constantNull((Type)UnknownType.UNKNOWN))))).check(outputStats -> outputStats.equalTo(unknownNullAStats));
    }

    @Test
    public void testStatsForEmptyValues() {
        this.tester().assertStatsFor(pb -> pb.values((List<VariableReferenceExpression>)ImmutableList.of((Object)pb.variable("a", (Type)BigintType.BIGINT)), (List<List<RowExpression>>)ImmutableList.of())).check(outputStats -> outputStats.equalTo(PlanNodeStatsEstimate.builder().setOutputRowCount(0.0).setConfidence(SourceInfo.ConfidenceLevel.FACT).addVariableStatistics(new VariableReferenceExpression(Optional.empty(), "a", (Type)BigintType.BIGINT), VariableStatsEstimate.zero()).build()));
    }
}

