/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.airlift.json.JsonCodec;
import com.facebook.airlift.stats.GcMonitor;
import com.facebook.airlift.stats.TestingGcMonitor;
import com.facebook.presto.Session;
import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.cost.StatsAndCosts;
import com.facebook.presto.execution.Lifespan;
import com.facebook.presto.execution.NodeTaskMap;
import com.facebook.presto.execution.PartitionedSplitsInfo;
import com.facebook.presto.execution.RemoteTask;
import com.facebook.presto.execution.RemoteTaskFactory;
import com.facebook.presto.execution.SchedulerStatsTracker;
import com.facebook.presto.execution.StateMachine;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.execution.TaskInfo;
import com.facebook.presto.execution.TaskState;
import com.facebook.presto.execution.TaskStateMachine;
import com.facebook.presto.execution.TaskStatus;
import com.facebook.presto.execution.buffer.LazyOutputBuffer;
import com.facebook.presto.execution.buffer.OutputBuffer;
import com.facebook.presto.execution.buffer.OutputBuffers;
import com.facebook.presto.execution.buffer.SpoolingOutputBufferFactory;
import com.facebook.presto.execution.scheduler.TableWriteInfo;
import com.facebook.presto.memory.MemoryPool;
import com.facebook.presto.memory.QueryContext;
import com.facebook.presto.memory.context.AggregatedMemoryContext;
import com.facebook.presto.memory.context.SimpleLocalMemoryContext;
import com.facebook.presto.metadata.InternalNode;
import com.facebook.presto.metadata.MetadataUpdates;
import com.facebook.presto.metadata.Split;
import com.facebook.presto.operator.TaskContext;
import com.facebook.presto.operator.TaskMemoryReservationSummary;
import com.facebook.presto.operator.TaskStats;
import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.SplitWeight;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.memory.MemoryPoolId;
import com.facebook.presto.spi.plan.Partitioning;
import com.facebook.presto.spi.plan.PartitioningHandle;
import com.facebook.presto.spi.plan.PartitioningScheme;
import com.facebook.presto.spi.plan.PlanFragmentId;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.plan.StageExecutionDescriptor;
import com.facebook.presto.spi.plan.TableScanNode;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.spiller.SpillSpaceTracker;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.planner.PlanFragment;
import com.facebook.presto.sql.planner.SystemPartitioningHandle;
import com.facebook.presto.testing.TestingHandle;
import com.facebook.presto.testing.TestingMetadata;
import com.facebook.presto.testing.TestingTransactionHandle;
import com.facebook.presto.util.Failures;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import io.airlift.units.DataSize;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;
import javax.annotation.concurrent.GuardedBy;

public class MockRemoteTaskFactory
implements RemoteTaskFactory {
    private static final UUID TASK_INSTANCE_ID = UUID.randomUUID();
    private final Executor executor;
    private final ScheduledExecutorService scheduledExecutor;

    public MockRemoteTaskFactory(Executor executor, ScheduledExecutorService scheduledExecutor) {
        this.executor = executor;
        this.scheduledExecutor = scheduledExecutor;
    }

    public MockRemoteTask createTableScanTask(TaskId taskId, InternalNode newNode, List<Split> splits, NodeTaskMap.NodeStatsTracker nodeStatsTracker) {
        VariableReferenceExpression variable = new VariableReferenceExpression(Optional.empty(), "column", (Type)VarcharType.VARCHAR);
        PlanNodeId sourceId = new PlanNodeId("sourceId");
        PlanFragment testFragment = new PlanFragment(new PlanFragmentId(0), (PlanNode)new TableScanNode(Optional.empty(), sourceId, new TableHandle(new ConnectorId("test"), (ConnectorTableHandle)new TestingMetadata.TestingTableHandle(), (ConnectorTransactionHandle)TestingTransactionHandle.create(), Optional.of(TestingHandle.INSTANCE)), (List)ImmutableList.of((Object)variable), (Map)ImmutableMap.of((Object)variable, (Object)new TestingMetadata.TestingColumnHandle("column")), TupleDomain.all(), TupleDomain.all(), Optional.empty()), (Set)ImmutableSet.of((Object)variable), SystemPartitioningHandle.SOURCE_DISTRIBUTION, (List)ImmutableList.of((Object)sourceId), new PartitioningScheme(Partitioning.create((PartitioningHandle)SystemPartitioningHandle.SINGLE_DISTRIBUTION, (Collection)ImmutableList.of()), (List)ImmutableList.of((Object)variable)), StageExecutionDescriptor.ungroupedExecution(), false, Optional.of(StatsAndCosts.empty()), Optional.empty());
        ImmutableMultimap.Builder initialSplits = ImmutableMultimap.builder();
        for (Split sourceSplit : splits) {
            initialSplits.put((Object)sourceId, (Object)sourceSplit);
        }
        return this.createRemoteTask(SessionTestUtils.TEST_SESSION, taskId, newNode, testFragment, (Multimap)initialSplits.build(), OutputBuffers.createInitialEmptyOutputBuffers((OutputBuffers.BufferType)OutputBuffers.BufferType.BROADCAST), nodeStatsTracker, true, new TableWriteInfo(Optional.empty(), Optional.empty()), SchedulerStatsTracker.NOOP);
    }

    public MockRemoteTask createRemoteTask(Session session, TaskId taskId, InternalNode node, PlanFragment fragment, Multimap<PlanNodeId, Split> initialSplits, OutputBuffers outputBuffers, NodeTaskMap.NodeStatsTracker nodeStatsTracker, boolean summarizeTaskInfo, TableWriteInfo tableWriteInfo, SchedulerStatsTracker schedulerStatsTracker) {
        return new MockRemoteTask(taskId, fragment, node.getNodeIdentifier(), this.executor, this.scheduledExecutor, initialSplits, nodeStatsTracker);
    }

    public static final class MockRemoteTask
    implements RemoteTask {
        private final AtomicLong nextTaskInfoVersion = new AtomicLong(1L);
        private final AtomicLong nextAgeOffset = new AtomicLong(0L);
        private final URI location;
        private final TaskStateMachine taskStateMachine;
        private final TaskContext taskContext;
        private final OutputBuffer outputBuffer;
        private final String nodeId;
        private final PlanFragment fragment;
        @GuardedBy(value="this")
        private final Set<PlanNodeId> noMoreSplits = new HashSet<PlanNodeId>();
        @GuardedBy(value="this")
        private final Multimap<PlanNodeId, Split> splits = HashMultimap.create();
        @GuardedBy(value="this")
        private int runningDrivers;
        @GuardedBy(value="this")
        private int maxUnacknowledgedSplits = Integer.MAX_VALUE;
        @GuardedBy(value="this")
        private int unacknowledgedSplits;
        @GuardedBy(value="this")
        private SettableFuture<?> whenSplitQueueHasSpace = SettableFuture.create();
        private final NodeTaskMap.NodeStatsTracker nodeStatsTracker;

        public MockRemoteTask(TaskId taskId, PlanFragment fragment, String nodeId, Executor executor, ScheduledExecutorService scheduledExecutor, Multimap<PlanNodeId, Split> initialSplits, NodeTaskMap.NodeStatsTracker nodeStatsTracker) {
            this.taskStateMachine = new TaskStateMachine(Objects.requireNonNull(taskId, "taskId is null"), Objects.requireNonNull(executor, "executor is null"));
            MemoryPool memoryPool = new MemoryPool(new MemoryPoolId("test"), new DataSize(1.0, DataSize.Unit.GIGABYTE));
            SpillSpaceTracker spillSpaceTracker = new SpillSpaceTracker(new DataSize(1.0, DataSize.Unit.GIGABYTE));
            QueryContext queryContext = new QueryContext(taskId.getQueryId(), new DataSize(1.0, DataSize.Unit.MEGABYTE), new DataSize(2.0, DataSize.Unit.MEGABYTE), new DataSize(1.0, DataSize.Unit.MEGABYTE), new DataSize(1.0, DataSize.Unit.GIGABYTE), memoryPool, (GcMonitor)new TestingGcMonitor(), executor, scheduledExecutor, new DataSize(1.0, DataSize.Unit.MEGABYTE), spillSpaceTracker, JsonCodec.listJsonCodec(TaskMemoryReservationSummary.class));
            this.taskContext = queryContext.addTaskContext(this.taskStateMachine, SessionTestUtils.TEST_SESSION, Optional.of(fragment.getRoot()), true, true, true, true, false);
            this.location = URI.create("fake://task/" + taskId);
            this.outputBuffer = new LazyOutputBuffer(taskId, TASK_INSTANCE_ID.toString(), executor, 1L, () -> new SimpleLocalMemoryContext(AggregatedMemoryContext.newSimpleAggregatedMemoryContext(), "test"), new SpoolingOutputBufferFactory(new FeaturesConfig()));
            this.fragment = Objects.requireNonNull(fragment, "fragment is null");
            this.nodeId = Objects.requireNonNull(nodeId, "nodeId is null");
            this.splits.putAll(initialSplits);
            this.nodeStatsTracker = Objects.requireNonNull(nodeStatsTracker, "nodeStatsTracker is null");
            this.updateTaskStats();
            this.updateSplitQueueSpace();
        }

        public TaskId getTaskId() {
            return this.taskStateMachine.getTaskId();
        }

        public String getNodeId() {
            return this.nodeId;
        }

        public TaskInfo getTaskInfo() {
            TaskStats stats = this.taskContext.getTaskStats();
            TaskState state = this.taskStateMachine.getState();
            Object failures = ImmutableList.of();
            if (state == TaskState.FAILED) {
                failures = Failures.toFailures((Collection)this.taskStateMachine.getFailureCauses());
            }
            return new TaskInfo(this.taskStateMachine.getTaskId(), new TaskStatus(TASK_INSTANCE_ID.getLeastSignificantBits(), TASK_INSTANCE_ID.getMostSignificantBits(), this.nextTaskInfoVersion.getAndIncrement(), state, this.location, (Set)ImmutableSet.of(), (List)failures, 0, 0, 0.0, false, 0L, 0L, 0L, 0L, 0L, 0L, 0L, System.currentTimeMillis() + 100L - stats.getCreateTimeInMillis(), 0L, 0L), System.currentTimeMillis(), this.outputBuffer.getInfo(), (Set)ImmutableSet.of(), this.taskContext.getTaskStats(), true, MetadataUpdates.DEFAULT_METADATA_UPDATES, this.nodeId);
        }

        public URI getRemoteTaskLocation() {
            return this.location;
        }

        public TaskStatus getTaskStatus() {
            TaskStats stats = this.taskContext.getTaskStats();
            PartitionedSplitsInfo combinedSplitsInfo = this.getPartitionedSplitsInfo();
            PartitionedSplitsInfo queuedSplitsInfo = this.getQueuedPartitionedSplitsInfo();
            return new TaskStatus(TASK_INSTANCE_ID.getLeastSignificantBits(), TASK_INSTANCE_ID.getMostSignificantBits(), this.nextTaskInfoVersion.get(), this.taskStateMachine.getState(), this.location, (Set)ImmutableSet.of(), (List)ImmutableList.of(), queuedSplitsInfo.getCount(), combinedSplitsInfo.getCount() - queuedSplitsInfo.getCount(), 0.0, false, stats.getPhysicalWrittenDataSizeInBytes(), stats.getUserMemoryReservationInBytes(), stats.getSystemMemoryReservationInBytes(), stats.getPeakNodeTotalMemoryInBytes(), 0L, 0L, stats.getTotalCpuTimeInNanos(), System.currentTimeMillis() + 100L - stats.getCreateTimeInMillis(), queuedSplitsInfo.getWeightSum(), combinedSplitsInfo.getWeightSum() - queuedSplitsInfo.getWeightSum());
        }

        private void updateTaskStats() {
            TaskStatus taskStatus = this.getTaskStatus();
            if (taskStatus.getState().isDone()) {
                this.nodeStatsTracker.setPartitionedSplits(PartitionedSplitsInfo.forZeroSplits());
                this.nodeStatsTracker.setMemoryUsage(0L);
                this.nodeStatsTracker.setCpuUsage(taskStatus.getTaskAgeInMillis(), 0L);
            } else {
                this.nodeStatsTracker.setPartitionedSplits(this.getPartitionedSplitsInfo());
                this.nodeStatsTracker.setMemoryUsage(100L);
                long ageOffset = this.nextAgeOffset.addAndGet(1L);
                this.nodeStatsTracker.setCpuUsage(taskStatus.getTaskAgeInMillis() + ageOffset, taskStatus.getTaskAgeInMillis() + ageOffset);
            }
        }

        private synchronized void updateSplitQueueSpace() {
            if (this.unacknowledgedSplits < this.maxUnacknowledgedSplits && this.getQueuedPartitionedSplitsInfo().getWeightSum() < 900L) {
                if (!this.whenSplitQueueHasSpace.isDone()) {
                    this.whenSplitQueueHasSpace.set(null);
                }
            } else if (this.whenSplitQueueHasSpace.isDone()) {
                this.whenSplitQueueHasSpace = SettableFuture.create();
            }
        }

        public synchronized void finishSplits(int splits) {
            ArrayList<Map.Entry> toRemove = new ArrayList<Map.Entry>();
            Iterator iterator = this.splits.entries().iterator();
            while (toRemove.size() < splits && iterator.hasNext()) {
                toRemove.add((Map.Entry)iterator.next());
            }
            for (Map.Entry entry : toRemove) {
                this.splits.remove(entry.getKey(), entry.getValue());
            }
            this.updateSplitQueueSpace();
        }

        public synchronized void clearSplits() {
            this.unacknowledgedSplits = 0;
            this.splits.clear();
            this.updateTaskStats();
            this.runningDrivers = 0;
            this.updateSplitQueueSpace();
        }

        public synchronized void startSplits(int maxRunning) {
            this.runningDrivers = this.splits.size();
            this.runningDrivers = Math.min(this.runningDrivers, maxRunning);
            this.updateSplitQueueSpace();
        }

        public synchronized void setMaxUnacknowledgedSplits(int maxUnacknowledgedSplits) {
            Preconditions.checkArgument((maxUnacknowledgedSplits > 0 ? 1 : 0) != 0);
            this.maxUnacknowledgedSplits = maxUnacknowledgedSplits;
            this.updateSplitQueueSpace();
        }

        public synchronized void setUnacknowledgedSplits(int unacknowledgedSplits) {
            Preconditions.checkArgument((unacknowledgedSplits >= 0 ? 1 : 0) != 0);
            this.unacknowledgedSplits = unacknowledgedSplits;
            this.updateSplitQueueSpace();
        }

        public void start() {
            this.taskStateMachine.addStateChangeListener(newValue -> {
                if (newValue.isDone()) {
                    this.clearSplits();
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addSplits(Multimap<PlanNodeId, Split> splits) {
            MockRemoteTask mockRemoteTask = this;
            synchronized (mockRemoteTask) {
                this.splits.putAll(splits);
            }
            this.updateTaskStats();
            this.updateSplitQueueSpace();
        }

        public synchronized void noMoreSplits(PlanNodeId sourceId) {
            this.noMoreSplits.add(sourceId);
            boolean allSourcesComplete = Stream.concat(this.fragment.getTableScanSchedulingOrder().stream(), this.fragment.getRemoteSourceNodes().stream().map(PlanNode::getId)).allMatch(this.noMoreSplits::contains);
            if (allSourcesComplete) {
                this.taskStateMachine.finished();
            }
        }

        public void noMoreSplits(PlanNodeId sourceId, Lifespan lifespan) {
            throw new UnsupportedOperationException();
        }

        public void setOutputBuffers(OutputBuffers outputBuffers) {
            this.outputBuffer.setOutputBuffers(outputBuffers);
        }

        public ListenableFuture<?> removeRemoteSource(TaskId remoteSourceTaskId) {
            throw new UnsupportedOperationException();
        }

        public void addStateChangeListener(StateMachine.StateChangeListener<TaskStatus> stateChangeListener) {
            this.taskStateMachine.addStateChangeListener(newValue -> stateChangeListener.stateChanged((Object)this.getTaskStatus()));
        }

        public void addFinalTaskInfoListener(StateMachine.StateChangeListener<TaskInfo> stateChangeListener) {
            AtomicBoolean done = new AtomicBoolean();
            StateMachine.StateChangeListener fireOnceStateChangeListener = state -> {
                if (state.isDone() && done.compareAndSet(false, true)) {
                    stateChangeListener.stateChanged((Object)this.getTaskInfo());
                }
            };
            this.taskStateMachine.addStateChangeListener(fireOnceStateChangeListener);
            fireOnceStateChangeListener.stateChanged((Object)this.taskStateMachine.getState());
        }

        public synchronized ListenableFuture<?> whenSplitQueueHasSpace(long weightThreshold) {
            return Futures.nonCancellationPropagating(this.whenSplitQueueHasSpace);
        }

        public void cancel() {
            this.taskStateMachine.cancel();
        }

        public void abort() {
            this.taskStateMachine.abort();
            this.clearSplits();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public PartitionedSplitsInfo getPartitionedSplitsInfo() {
            if (this.taskStateMachine.getState().isDone()) {
                return PartitionedSplitsInfo.forZeroSplits();
            }
            MockRemoteTask mockRemoteTask = this;
            synchronized (mockRemoteTask) {
                int count = 0;
                long weight = 0L;
                for (PlanNodeId tableScanPlanNodeId : this.fragment.getTableScanSchedulingOrder()) {
                    Collection partitionedSplits = this.splits.get((Object)tableScanPlanNodeId);
                    count += partitionedSplits.size();
                    weight = Math.addExact(weight, SplitWeight.rawValueSum((Collection)partitionedSplits, Split::getSplitWeight));
                }
                return PartitionedSplitsInfo.forSplitCountAndWeightSum((int)count, (long)weight);
            }
        }

        public synchronized PartitionedSplitsInfo getQueuedPartitionedSplitsInfo() {
            if (this.taskStateMachine.getState().isDone()) {
                return PartitionedSplitsInfo.forZeroSplits();
            }
            int remainingRunning = this.runningDrivers;
            int queuedCount = 0;
            long queuedWeight = 0L;
            for (PlanNodeId tableScanPlanNodeId : this.fragment.getTableScanSchedulingOrder()) {
                for (Split split : this.splits.get((Object)tableScanPlanNodeId)) {
                    if (remainingRunning > 0) {
                        --remainingRunning;
                        continue;
                    }
                    ++queuedCount;
                    queuedWeight = Math.addExact(queuedWeight, split.getSplitWeight().getRawValue());
                }
            }
            return PartitionedSplitsInfo.forSplitCountAndWeightSum((int)queuedCount, (long)queuedWeight);
        }

        public synchronized int getUnacknowledgedPartitionedSplitCount() {
            return this.unacknowledgedSplits;
        }

        public PlanFragment getPlanFragment() {
            return this.fragment;
        }
    }
}

