/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.airlift.json.JsonCodec;
import com.facebook.airlift.json.JsonObjectMapperProvider;
import com.facebook.presto.Session;
import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.common.block.BlockEncodingManager;
import com.facebook.presto.common.block.BlockEncodingSerde;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.cost.StatsAndCosts;
import com.facebook.presto.dispatcher.NoOpQueryManager;
import com.facebook.presto.event.SplitMonitor;
import com.facebook.presto.eventlistener.EventListenerConfig;
import com.facebook.presto.eventlistener.EventListenerManager;
import com.facebook.presto.execution.NodeTaskMap;
import com.facebook.presto.execution.QueryManager;
import com.facebook.presto.execution.QueryStateMachine;
import com.facebook.presto.execution.ScheduledSplit;
import com.facebook.presto.execution.SqlTask;
import com.facebook.presto.execution.TaskInfo;
import com.facebook.presto.execution.TaskManagerConfig;
import com.facebook.presto.execution.TaskSource;
import com.facebook.presto.execution.TestingPageSourceProvider;
import com.facebook.presto.execution.buffer.OutputBuffers;
import com.facebook.presto.execution.scheduler.LegacyNetworkTopology;
import com.facebook.presto.execution.scheduler.NetworkTopology;
import com.facebook.presto.execution.scheduler.NodeScheduler;
import com.facebook.presto.execution.scheduler.NodeSchedulerConfig;
import com.facebook.presto.execution.scheduler.TableWriteInfo;
import com.facebook.presto.execution.scheduler.nodeSelection.NodeSelectionStats;
import com.facebook.presto.execution.scheduler.nodeSelection.SimpleTtlNodeSelectorConfig;
import com.facebook.presto.index.IndexManager;
import com.facebook.presto.memory.MemoryManagerConfig;
import com.facebook.presto.metadata.ConnectorMetadataUpdaterManager;
import com.facebook.presto.metadata.InMemoryNodeManager;
import com.facebook.presto.metadata.InternalNodeManager;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.metadata.Split;
import com.facebook.presto.operator.FragmentResultCacheManager;
import com.facebook.presto.operator.LookupJoinOperators;
import com.facebook.presto.operator.NoOpFragmentResultCacheManager;
import com.facebook.presto.operator.PagesIndex;
import com.facebook.presto.operator.TableCommitContext;
import com.facebook.presto.operator.index.IndexJoinLookupStats;
import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.connector.ConnectorPageSourceProvider;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.plan.Partitioning;
import com.facebook.presto.spi.plan.PartitioningHandle;
import com.facebook.presto.spi.plan.PartitioningScheme;
import com.facebook.presto.spi.plan.PlanFragmentId;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.plan.StageExecutionDescriptor;
import com.facebook.presto.spi.plan.TableScanNode;
import com.facebook.presto.spi.relation.DeterminismEvaluator;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.spi.resourceGroups.ResourceGroupId;
import com.facebook.presto.spi.security.AccessControl;
import com.facebook.presto.spi.security.AllowAllAccessControl;
import com.facebook.presto.spiller.GenericSpillerFactory;
import com.facebook.presto.spiller.SpillerFactory;
import com.facebook.presto.split.PageSinkManager;
import com.facebook.presto.split.PageSourceManager;
import com.facebook.presto.split.PageSourceProvider;
import com.facebook.presto.sql.analyzer.FunctionsConfig;
import com.facebook.presto.sql.gen.ExpressionCompiler;
import com.facebook.presto.sql.gen.JoinCompiler;
import com.facebook.presto.sql.gen.JoinFilterFunctionCompiler;
import com.facebook.presto.sql.gen.OrderingCompiler;
import com.facebook.presto.sql.gen.PageFunctionCompiler;
import com.facebook.presto.sql.planner.LocalExecutionPlanner;
import com.facebook.presto.sql.planner.NodePartitioningManager;
import com.facebook.presto.sql.planner.PartitioningProviderManager;
import com.facebook.presto.sql.planner.PlanFragment;
import com.facebook.presto.sql.planner.SystemPartitioningHandle;
import com.facebook.presto.sql.relational.RowExpressionDeterminismEvaluator;
import com.facebook.presto.testing.TestingMetadata;
import com.facebook.presto.testing.TestingSplit;
import com.facebook.presto.testing.TestingTransactionHandle;
import com.facebook.presto.transaction.TransactionManager;
import com.facebook.presto.ttl.nodettlfetchermanagers.NodeTtlFetcherManager;
import com.facebook.presto.ttl.nodettlfetchermanagers.ThrowingNodeTtlFetcherManager;
import com.facebook.presto.util.FinalizerService;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executor;

public final class TaskTestUtils {
    private static final ConnectorTransactionHandle TRANSACTION_HANDLE = TestingTransactionHandle.create();
    public static final PlanNodeId TABLE_SCAN_NODE_ID = new PlanNodeId("tableScan");
    private static final ConnectorId CONNECTOR_ID = new ConnectorId("test");
    public static final ScheduledSplit SPLIT = new ScheduledSplit(0L, TABLE_SCAN_NODE_ID, new Split(CONNECTOR_ID, TRANSACTION_HANDLE, (ConnectorSplit)TestingSplit.createLocalSplit()));
    public static final ImmutableList<TaskSource> EMPTY_SOURCES = ImmutableList.of();
    public static final VariableReferenceExpression VARIABLE = new VariableReferenceExpression(Optional.empty(), "column", (Type)BigintType.BIGINT);
    public static final PlanFragment PLAN_FRAGMENT = TaskTestUtils.createPlanFragment();

    private TaskTestUtils() {
    }

    public static PlanFragment createPlanFragment() {
        return new PlanFragment(new PlanFragmentId(0), (PlanNode)new TableScanNode(Optional.empty(), TABLE_SCAN_NODE_ID, new TableHandle(CONNECTOR_ID, (ConnectorTableHandle)new TestingMetadata.TestingTableHandle(), TRANSACTION_HANDLE, Optional.empty()), (List)ImmutableList.of((Object)VARIABLE), (Map)ImmutableMap.of((Object)VARIABLE, (Object)new TestingMetadata.TestingColumnHandle("column", 0, (Type)BigintType.BIGINT)), TupleDomain.all(), TupleDomain.all(), Optional.empty()), (Set)ImmutableSet.of((Object)VARIABLE), SystemPartitioningHandle.SOURCE_DISTRIBUTION, (List)ImmutableList.of((Object)TABLE_SCAN_NODE_ID), new PartitioningScheme(Partitioning.create((PartitioningHandle)SystemPartitioningHandle.SINGLE_DISTRIBUTION, (Collection)ImmutableList.of()), (List)ImmutableList.of((Object)VARIABLE)).withBucketToPartition(Optional.of(new int[1])), StageExecutionDescriptor.ungroupedExecution(), false, Optional.of(StatsAndCosts.empty()), Optional.empty());
    }

    public static LocalExecutionPlanner createTestingPlanner() {
        MetadataManager metadata = MetadataManager.createTestMetadataManager();
        PageSourceManager pageSourceManager = new PageSourceManager();
        pageSourceManager.addConnectorPageSourceProvider(CONNECTOR_ID, (ConnectorPageSourceProvider)new TestingPageSourceProvider());
        FinalizerService finalizerService = new FinalizerService();
        NodeScheduler nodeScheduler = new NodeScheduler((NetworkTopology)new LegacyNetworkTopology(), (InternalNodeManager)new InMemoryNodeManager(), new NodeSelectionStats(), new NodeSchedulerConfig().setIncludeCoordinator(true), new NodeTaskMap(finalizerService), (NodeTtlFetcherManager)new ThrowingNodeTtlFetcherManager(), (QueryManager)new NoOpQueryManager(), new SimpleTtlNodeSelectorConfig());
        PartitioningProviderManager partitioningProviderManager = new PartitioningProviderManager();
        NodePartitioningManager nodePartitioningManager = new NodePartitioningManager(nodeScheduler, partitioningProviderManager, new NodeSelectionStats());
        PageFunctionCompiler pageFunctionCompiler = new PageFunctionCompiler((Metadata)metadata, 0);
        return new LocalExecutionPlanner((Metadata)metadata, Optional.empty(), (PageSourceProvider)pageSourceManager, new IndexManager(), partitioningProviderManager, nodePartitioningManager, new PageSinkManager(), new ConnectorMetadataUpdaterManager(), new ExpressionCompiler((Metadata)metadata, pageFunctionCompiler), pageFunctionCompiler, new JoinFilterFunctionCompiler((Metadata)metadata), new IndexJoinLookupStats(), new TaskManagerConfig(), new MemoryManagerConfig(), new FunctionsConfig(), (SpillerFactory)new GenericSpillerFactory((types, spillContext, memoryContext) -> {
            throw new UnsupportedOperationException();
        }), (types, spillContext, memoryContext) -> {
            throw new UnsupportedOperationException();
        }, (types, partitionFunction, spillContext, memoryContext) -> {
            throw new UnsupportedOperationException();
        }, (BlockEncodingSerde)new BlockEncodingManager(), (PagesIndex.Factory)new PagesIndex.TestingFactory(false), new JoinCompiler((Metadata)MetadataManager.createTestMetadataManager()), new LookupJoinOperators(), new OrderingCompiler(), JsonCodec.jsonCodec(TableCommitContext.class), (DeterminismEvaluator)new RowExpressionDeterminismEvaluator((Metadata)metadata), (FragmentResultCacheManager)new NoOpFragmentResultCacheManager(), new ObjectMapper(), session -> {
            throw new UnsupportedOperationException();
        });
    }

    public static TaskInfo updateTask(SqlTask sqlTask, List<TaskSource> taskSources, OutputBuffers outputBuffers) {
        return sqlTask.updateTask(SessionTestUtils.TEST_SESSION, Optional.of(PLAN_FRAGMENT), taskSources, outputBuffers, Optional.of(new TableWriteInfo(Optional.empty(), Optional.empty())));
    }

    public static SplitMonitor createTestSplitMonitor() {
        return new SplitMonitor(new EventListenerManager(new EventListenerConfig()), new JsonObjectMapperProvider().get());
    }

    public static QueryStateMachine createQueryStateMachine(String sqlString, Session session, boolean transactionControl, TransactionManager tm, Executor executor, MetadataManager metadata) {
        return QueryStateMachine.begin((String)sqlString, Optional.empty(), (Session)session, (URI)URI.create("fake://uri"), (ResourceGroupId)new ResourceGroupId("test"), Optional.empty(), (boolean)transactionControl, (TransactionManager)tm, (AccessControl)new AllowAllAccessControl(), (Executor)executor, (Metadata)metadata, (WarningCollector)WarningCollector.NOOP);
    }
}

