/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.airlift.concurrent.MoreFutures;
import com.facebook.presto.client.NodeVersion;
import com.facebook.presto.execution.ClusterSizeMonitor;
import com.facebook.presto.metadata.InMemoryNodeManager;
import com.facebook.presto.metadata.InternalNode;
import com.facebook.presto.metadata.InternalNodeManager;
import com.facebook.presto.spi.ConnectorId;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.units.Duration;
import java.net.URI;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestClusterSizeMonitor {
    public static final ConnectorId CONNECTOR_ID = new ConnectorId("dummy");
    public static final int DESIRED_WORKER_COUNT = 10;
    public static final int DESIRED_COORDINATOR_COUNT = 3;
    public static final int DESIRED_COORDINATOR_COUNT_ACTIVE = 2;
    public static final int DESIRED_RESOURCE_MANAGER_COUNT_ACTIVE = 1;
    public static final int DESIRED_WORKER_COUNT_ACTIVE = 10;
    public static final int DESIRED_COORDINATOR_SIDECAR_COUNT = 1;
    private InMemoryNodeManager nodeManager;
    private ClusterSizeMonitor monitor;
    private CountDownLatch minWorkersLatch;
    private CountDownLatch minCoordinatorSidecarsLatch;
    private AtomicInteger numWorkers;
    private AtomicInteger numCoordinators;
    private AtomicInteger numResourceManagers;
    private AtomicInteger numCoordinatorSidecars;
    private AtomicBoolean workersTimeout;
    private AtomicBoolean coordinatorSidecarsTimeout;

    @BeforeMethod
    public void setUp() {
        this.numWorkers = new AtomicInteger(0);
        this.numCoordinators = new AtomicInteger(0);
        this.numResourceManagers = new AtomicInteger(0);
        this.numCoordinatorSidecars = new AtomicInteger(0);
        this.workersTimeout = new AtomicBoolean();
        this.coordinatorSidecarsTimeout = new AtomicBoolean();
        this.nodeManager = new InMemoryNodeManager();
        this.monitor = new ClusterSizeMonitor((InternalNodeManager)this.nodeManager, false, 10, 10, new Duration(4.0, TimeUnit.SECONDS), 3, 2, new Duration(4.0, TimeUnit.SECONDS), new Duration(4.0, TimeUnit.SECONDS), 1, true);
        this.minWorkersLatch = new CountDownLatch(1);
        this.minCoordinatorSidecarsLatch = new CountDownLatch(1);
        this.monitor.start();
    }

    @AfterMethod
    public void tearDown() {
        this.monitor.stop();
    }

    @Test(timeOut=60000L)
    public void testWaitForMinimumWorkers() throws InterruptedException {
        ListenableFuture<?> workersFuture = this.waitForMinimumWorkers();
        for (int i = this.numWorkers.get() + 1; i < 9; ++i) {
            Assert.assertFalse((boolean)this.workersTimeout.get());
            this.addWorker(this.nodeManager);
        }
        Assert.assertFalse((boolean)this.monitor.hasRequiredWorkers());
        Assert.assertFalse((boolean)this.workersTimeout.get());
        Assert.assertEquals((long)this.minWorkersLatch.getCount(), (long)1L);
        this.addWorker(this.nodeManager);
        this.minWorkersLatch.await(1L, TimeUnit.SECONDS);
        Assert.assertTrue((boolean)workersFuture.isDone());
        Assert.assertFalse((boolean)this.workersTimeout.get());
        Assert.assertTrue((boolean)this.monitor.hasRequiredWorkers());
    }

    @Test(timeOut=10000L)
    public void testTimeoutWaitingForWorkers() throws InterruptedException {
        this.waitForMinimumWorkers();
        Assert.assertFalse((boolean)this.workersTimeout.get());
        this.addWorker(this.nodeManager);
        Assert.assertFalse((boolean)this.workersTimeout.get());
        Assert.assertEquals((long)this.minWorkersLatch.getCount(), (long)1L);
        Thread.sleep(TimeUnit.SECONDS.toMillis(5L));
        Assert.assertTrue((boolean)this.workersTimeout.get());
        Assert.assertEquals((long)this.minWorkersLatch.getCount(), (long)0L);
    }

    @Test(timeOut=60000L)
    public void testWaitForMinimumCoordinatorSidecars() throws InterruptedException {
        ListenableFuture<?> coordinatorSidecarsFuture = this.waitForMinimumCoordinatorSidecars();
        Assert.assertFalse((boolean)this.monitor.hasRequiredCoordinatorSidecars());
        Assert.assertFalse((boolean)this.coordinatorSidecarsTimeout.get());
        Assert.assertEquals((long)this.minCoordinatorSidecarsLatch.getCount(), (long)1L);
        this.addCoordinatorSidecar(this.nodeManager);
        this.minCoordinatorSidecarsLatch.await(1L, TimeUnit.SECONDS);
        Assert.assertTrue((boolean)coordinatorSidecarsFuture.isDone());
        Assert.assertFalse((boolean)this.coordinatorSidecarsTimeout.get());
        Assert.assertTrue((boolean)this.monitor.hasRequiredCoordinatorSidecars());
    }

    @Test(timeOut=10000L)
    public void testTimeoutWaitingForCoordinatorSidecars() throws InterruptedException {
        this.waitForMinimumCoordinatorSidecars();
        Assert.assertFalse((boolean)this.coordinatorSidecarsTimeout.get());
        Assert.assertEquals((long)this.minCoordinatorSidecarsLatch.getCount(), (long)1L);
        Thread.sleep(TimeUnit.SECONDS.toMillis(5L));
        Assert.assertTrue((boolean)this.coordinatorSidecarsTimeout.get());
        Assert.assertEquals((long)this.minCoordinatorSidecarsLatch.getCount(), (long)0L);
    }

    @Test
    public void testHasRequiredCoordinatorSidecars() throws InterruptedException {
        Assert.assertFalse((boolean)this.monitor.hasRequiredCoordinatorSidecars());
        for (int i = this.numCoordinatorSidecars.get(); i < 1; ++i) {
            this.addCoordinatorSidecar(this.nodeManager);
        }
        Assert.assertTrue((boolean)this.monitor.hasRequiredCoordinatorSidecars());
    }

    @Test
    public void testHasRequiredCoordinatorSidecarsMoreThanOne() throws InterruptedException {
        Assert.assertFalse((boolean)this.monitor.hasRequiredCoordinatorSidecars());
        for (int i = this.numCoordinatorSidecars.get(); i < 2; ++i) {
            this.addCoordinatorSidecar(this.nodeManager);
        }
        Assert.assertTrue((boolean)this.monitor.hasRequiredCoordinatorSidecars());
    }

    @Test
    public void testHasRequiredResourceManagers() throws InterruptedException {
        Assert.assertFalse((boolean)this.monitor.hasRequiredResourceManagers());
        for (int i = this.numResourceManagers.get(); i < 1; ++i) {
            this.addResourceManager(this.nodeManager);
        }
        Assert.assertTrue((boolean)this.monitor.hasRequiredResourceManagers());
    }

    @Test
    public void testHasRequiredCoordinators() throws InterruptedException {
        Assert.assertFalse((boolean)this.monitor.hasRequiredCoordinators());
        for (int i = this.numResourceManagers.get(); i < 2; ++i) {
            this.addCoordinator(this.nodeManager);
        }
        Assert.assertTrue((boolean)this.monitor.hasRequiredCoordinators());
    }

    private ListenableFuture<?> waitForMinimumWorkers() {
        ListenableFuture workersFuture = this.monitor.waitForMinimumWorkers();
        MoreFutures.addSuccessCallback((ListenableFuture)workersFuture, () -> {
            Assert.assertFalse((boolean)this.workersTimeout.get());
            this.minWorkersLatch.countDown();
        });
        MoreFutures.addExceptionCallback((ListenableFuture)workersFuture, () -> {
            Assert.assertTrue((boolean)this.workersTimeout.compareAndSet(false, true));
            this.minWorkersLatch.countDown();
        });
        return workersFuture;
    }

    private ListenableFuture<?> waitForMinimumCoordinatorSidecars() {
        ListenableFuture coordinatorSidecarsFuture = this.monitor.waitForMinimumCoordinatorSidecars();
        MoreFutures.addSuccessCallback((ListenableFuture)coordinatorSidecarsFuture, () -> {
            Assert.assertFalse((boolean)this.coordinatorSidecarsTimeout.get());
            this.minCoordinatorSidecarsLatch.countDown();
            this.minCoordinatorSidecarsLatch.countDown();
        });
        MoreFutures.addExceptionCallback((ListenableFuture)coordinatorSidecarsFuture, () -> {
            Assert.assertTrue((boolean)this.coordinatorSidecarsTimeout.compareAndSet(false, true));
            this.minCoordinatorSidecarsLatch.countDown();
        });
        return coordinatorSidecarsFuture;
    }

    private void addWorker(InMemoryNodeManager nodeManager) {
        String identifier = "worker/" + this.numWorkers.incrementAndGet();
        nodeManager.addNode(CONNECTOR_ID, new InternalNode[]{new InternalNode(identifier, URI.create("localhost/" + identifier), new NodeVersion("1"), false)});
    }

    private void addCoordinator(InMemoryNodeManager nodeManager) {
        String identifier = "coordinator/" + this.numCoordinators.incrementAndGet();
        nodeManager.addNode(CONNECTOR_ID, new InternalNode[]{new InternalNode(identifier, URI.create("localhost/" + identifier), new NodeVersion("1"), true)});
    }

    private void addResourceManager(InMemoryNodeManager nodeManager) {
        String identifier = "resource_manager/" + this.numResourceManagers.incrementAndGet();
        nodeManager.addNode(CONNECTOR_ID, new InternalNode[]{new InternalNode(identifier, URI.create("localhost/" + identifier), new NodeVersion("1"), false, true, false, false)});
    }

    private void addCoordinatorSidecar(InMemoryNodeManager nodeManager) {
        String identifier = "coordinator_sidecar/" + this.numCoordinatorSidecars.incrementAndGet();
        nodeManager.addNode(CONNECTOR_ID, new InternalNode[]{new InternalNode(identifier, URI.create("localhost/" + identifier), new NodeVersion("1"), false, false, false, true)});
    }
}

