/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.airlift.concurrent.MoreFutures;
import com.facebook.airlift.concurrent.Threads;
import com.facebook.presto.Session;
import com.facebook.presto.common.CatalogSchemaName;
import com.facebook.presto.common.QualifiedObjectName;
import com.facebook.presto.common.block.BlockEncoding;
import com.facebook.presto.common.block.BlockEncodingSerde;
import com.facebook.presto.common.block.TestingBlockEncodingSerde;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.execution.CreateMaterializedViewTask;
import com.facebook.presto.execution.QueryStateMachine;
import com.facebook.presto.metadata.AbstractMockMetadata;
import com.facebook.presto.metadata.Catalog;
import com.facebook.presto.metadata.CatalogManager;
import com.facebook.presto.metadata.ColumnPropertyManager;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.TablePropertyManager;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.MaterializedViewDefinition;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.TableMetadata;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.analyzer.MetadataResolver;
import com.facebook.presto.spi.analyzer.ViewDefinition;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.resourceGroups.ResourceGroupId;
import com.facebook.presto.spi.security.AccessControl;
import com.facebook.presto.spi.security.AllowAllAccessControl;
import com.facebook.presto.spi.session.PropertyMetadata;
import com.facebook.presto.sql.parser.ParsingOptions;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.tree.CreateMaterializedView;
import com.facebook.presto.testing.TestingSession;
import com.facebook.presto.transaction.InMemoryTransactionManager;
import com.facebook.presto.transaction.TransactionManager;
import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestCreateMaterializedViewTask {
    private static final String CATALOG_NAME = "catalog";
    private static final String SCHEMA_NAME = "schema";
    private static final String MATERIALIZED_VIEW_A = "materialized_view_a";
    private static final String MATERIALIZED_VIEW_B = "materialized_view_b";
    private static final String TABLE_A = "table_a";
    private TransactionManager transactionManager;
    private Session testSession;
    private AccessControl accessControl;
    private ExecutorService executorService;
    private MockMetadata metadata;

    @BeforeMethod
    public void setUp() {
        CatalogManager catalogManager = new CatalogManager();
        Catalog testCatalog = TestingSession.createBogusTestingCatalog((String)CATALOG_NAME);
        catalogManager.registerCatalog(testCatalog);
        TablePropertyManager tablePropertyManager = new TablePropertyManager();
        tablePropertyManager.addProperties(testCatalog.getConnectorId(), (List)ImmutableList.of((Object)PropertyMetadata.stringProperty((String)"baz", (String)"test property", null, (boolean)false)));
        ColumnPropertyManager columnPropertyManager = new ColumnPropertyManager();
        columnPropertyManager.addProperties(testCatalog.getConnectorId(), (List)ImmutableList.of());
        FunctionAndTypeManager functionAndTypeManager = FunctionAndTypeManager.createTestFunctionAndTypeManager();
        this.transactionManager = InMemoryTransactionManager.createTestTransactionManager((CatalogManager)catalogManager);
        this.testSession = TestingSession.testSessionBuilder().setTransactionId(this.transactionManager.beginTransaction(false)).build();
        this.accessControl = new AllowAllAccessControl();
        this.executorService = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"test-%s"));
        this.metadata = new MockMetadata(functionAndTypeManager, tablePropertyManager, columnPropertyManager, testCatalog.getConnectorId());
    }

    @Test
    public void testCreateMaterializedViewNotExistsTrue() {
        SqlParser parser = new SqlParser();
        String sql = String.format("CREATE MATERIALIZED VIEW IF NOT EXISTS %s AS SELECT 2021 AS col_0 FROM %s", MATERIALIZED_VIEW_A, TABLE_A);
        CreateMaterializedView statement = (CreateMaterializedView)parser.createStatement(sql, ParsingOptions.builder().build());
        QueryStateMachine stateMachine = QueryStateMachine.begin((String)sql, Optional.empty(), (Session)this.testSession, (URI)URI.create("fake://uri"), (ResourceGroupId)new ResourceGroupId("test"), Optional.empty(), (boolean)false, (TransactionManager)this.transactionManager, (AccessControl)this.accessControl, (Executor)this.executorService, (Metadata)this.metadata, (WarningCollector)WarningCollector.NOOP);
        WarningCollector warningCollector = stateMachine.getWarningCollector();
        CreateMaterializedViewTask createMaterializedViewTask = new CreateMaterializedViewTask(parser);
        MoreFutures.getFutureValue((Future)createMaterializedViewTask.execute(statement, this.transactionManager, (Metadata)this.metadata, this.accessControl, this.testSession, Collections.emptyList(), warningCollector, sql));
        Assert.assertEquals((int)this.metadata.getCreateMaterializedViewCallCount(), (int)1);
    }

    @Test
    public void testCreateMaterializedViewExistsFalse() {
        SqlParser parser = new SqlParser();
        String sql = String.format("CREATE MATERIALIZED VIEW %s AS SELECT 2021 AS col_0 FROM %s", MATERIALIZED_VIEW_B, TABLE_A);
        CreateMaterializedView statement = (CreateMaterializedView)parser.createStatement(sql, ParsingOptions.builder().build());
        QueryStateMachine stateMachine = QueryStateMachine.begin((String)sql, Optional.empty(), (Session)this.testSession, (URI)URI.create("fake://uri"), (ResourceGroupId)new ResourceGroupId("test"), Optional.empty(), (boolean)false, (TransactionManager)this.transactionManager, (AccessControl)this.accessControl, (Executor)this.executorService, (Metadata)this.metadata, (WarningCollector)WarningCollector.NOOP);
        WarningCollector warningCollector = stateMachine.getWarningCollector();
        try {
            MoreFutures.getFutureValue((Future)new CreateMaterializedViewTask(parser).execute(statement, this.transactionManager, (Metadata)this.metadata, this.accessControl, this.testSession, Collections.emptyList(), warningCollector, sql));
            Assert.fail((String)"expected exception");
        }
        catch (RuntimeException e) {
            Assert.assertTrue((boolean)(e instanceof PrestoException));
            PrestoException prestoException = (PrestoException)((Object)e);
            Assert.assertEquals((Object)prestoException.getErrorCode(), (Object)StandardErrorCode.ALREADY_EXISTS.toErrorCode());
        }
        Assert.assertEquals((int)this.metadata.getCreateMaterializedViewCallCount(), (int)0);
    }

    private static class MockMetadata
    extends AbstractMockMetadata {
        private final FunctionAndTypeManager functionAndTypeManager;
        private final TablePropertyManager tablePropertyManager;
        private final ColumnPropertyManager columnPropertyManager;
        private final ConnectorId catalogHandle;
        private final List<ConnectorTableMetadata> materializedViews = new CopyOnWriteArrayList<ConnectorTableMetadata>();

        public MockMetadata(FunctionAndTypeManager functionAndTypeManager, TablePropertyManager tablePropertyManager, ColumnPropertyManager columnPropertyManager, ConnectorId catalogHandle) {
            this.functionAndTypeManager = Objects.requireNonNull(functionAndTypeManager, "functionAndTypeManager is null");
            this.tablePropertyManager = Objects.requireNonNull(tablePropertyManager, "tablePropertyManager is null");
            this.columnPropertyManager = Objects.requireNonNull(columnPropertyManager, "columnPropertyManager is null");
            this.catalogHandle = Objects.requireNonNull(catalogHandle, "catalogHandle is null");
        }

        @Override
        public void createMaterializedView(Session session, String catalogName, ConnectorTableMetadata viewMetadata, MaterializedViewDefinition viewDefinition, boolean ignoreExisting) {
            if (!ignoreExisting) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.ALREADY_EXISTS, "Materialized view already exists");
            }
            this.materializedViews.add(viewMetadata);
        }

        public int getCreateMaterializedViewCallCount() {
            return this.materializedViews.size();
        }

        @Override
        public TablePropertyManager getTablePropertyManager() {
            return this.tablePropertyManager;
        }

        @Override
        public ColumnPropertyManager getColumnPropertyManager() {
            return this.columnPropertyManager;
        }

        @Override
        public FunctionAndTypeManager getFunctionAndTypeManager() {
            return this.functionAndTypeManager;
        }

        @Override
        public Type getType(TypeSignature signature) {
            return this.functionAndTypeManager.getType(signature);
        }

        @Override
        public MetadataResolver getMetadataResolver(Session session) {
            return new MetadataResolver(){

                public boolean catalogExists(String catalogName) {
                    return false;
                }

                public boolean schemaExists(CatalogSchemaName schemaName) {
                    return false;
                }

                public Optional<TableHandle> getTableHandle(QualifiedObjectName tableName) {
                    return this.getOptionalTableHandle(tableName);
                }

                public List<ColumnMetadata> getColumns(TableHandle tableHandle) {
                    return Collections.emptyList();
                }

                public Map<String, ColumnHandle> getColumnHandles(TableHandle tableHandle) {
                    return Collections.emptyMap();
                }

                public Optional<ViewDefinition> getView(QualifiedObjectName viewName) {
                    return Optional.empty();
                }

                public Optional<MaterializedViewDefinition> getMaterializedView(QualifiedObjectName viewName) {
                    return Optional.empty();
                }
            };
        }

        private Optional<TableHandle> getOptionalTableHandle(QualifiedObjectName tableName) {
            if (tableName.getObjectName().equals(TestCreateMaterializedViewTask.MATERIALIZED_VIEW_A)) {
                return Optional.empty();
            }
            if (tableName.getObjectName().equals(TestCreateMaterializedViewTask.TABLE_A)) {
                return Optional.of(new TableHandle(this.catalogHandle, new ConnectorTableHandle(){}, new ConnectorTransactionHandle(){}, Optional.empty()));
            }
            return Optional.empty();
        }

        @Override
        public Map<String, ColumnHandle> getColumnHandles(Session session, TableHandle tableHandle) {
            return Collections.emptyMap();
        }

        @Override
        public TableMetadata getTableMetadata(Session session, TableHandle tableHandle) {
            return new TableMetadata(this.catalogHandle, new ConnectorTableMetadata(new SchemaTableName(TestCreateMaterializedViewTask.SCHEMA_NAME, TestCreateMaterializedViewTask.TABLE_A), Collections.emptyList()));
        }

        @Override
        public BlockEncodingSerde getBlockEncodingSerde() {
            return new TestingBlockEncodingSerde(new BlockEncoding[0]);
        }

        @Override
        public Optional<ConnectorId> getCatalogHandle(Session session, String catalogName) {
            if (this.catalogHandle.getCatalogName().equals(catalogName)) {
                return Optional.of(this.catalogHandle);
            }
            return Optional.empty();
        }
    }
}

