/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.airlift.concurrent.Threads;
import com.facebook.presto.Session;
import com.facebook.presto.client.NodeVersion;
import com.facebook.presto.dispatcher.NoOpQueryManager;
import com.facebook.presto.execution.MockRemoteTaskFactory;
import com.facebook.presto.execution.NodeTaskMap;
import com.facebook.presto.execution.PartitionedSplitsInfo;
import com.facebook.presto.execution.QueryManager;
import com.facebook.presto.execution.QueryState;
import com.facebook.presto.execution.RemoteTask;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.execution.scheduler.LegacyNetworkTopology;
import com.facebook.presto.execution.scheduler.ModularHashingNodeProvider;
import com.facebook.presto.execution.scheduler.NetworkLocation;
import com.facebook.presto.execution.scheduler.NetworkLocationCache;
import com.facebook.presto.execution.scheduler.NetworkTopology;
import com.facebook.presto.execution.scheduler.NodeScheduler;
import com.facebook.presto.execution.scheduler.NodeSchedulerConfig;
import com.facebook.presto.execution.scheduler.NodeSelectionHashStrategy;
import com.facebook.presto.execution.scheduler.SplitPlacementResult;
import com.facebook.presto.execution.scheduler.nodeSelection.NodeSelectionStats;
import com.facebook.presto.execution.scheduler.nodeSelection.NodeSelector;
import com.facebook.presto.execution.scheduler.nodeSelection.SimpleTtlNodeSelectorConfig;
import com.facebook.presto.metadata.InMemoryNodeManager;
import com.facebook.presto.metadata.InternalNode;
import com.facebook.presto.metadata.InternalNodeManager;
import com.facebook.presto.metadata.Split;
import com.facebook.presto.server.BasicQueryInfo;
import com.facebook.presto.server.BasicQueryStats;
import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.HostAddress;
import com.facebook.presto.spi.NodeProvider;
import com.facebook.presto.spi.QueryId;
import com.facebook.presto.spi.SplitWeight;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.schedule.NodeSelectionStrategy;
import com.facebook.presto.spi.ttl.ConfidenceBasedTtlInfo;
import com.facebook.presto.spi.ttl.NodeInfo;
import com.facebook.presto.spi.ttl.NodeTtl;
import com.facebook.presto.spi.ttl.NodeTtlFetcherFactory;
import com.facebook.presto.spi.ttl.TestingNodeTtlFetcherFactory;
import com.facebook.presto.testing.TestingSession;
import com.facebook.presto.testing.TestingTransactionHandle;
import com.facebook.presto.ttl.nodettlfetchermanagers.ConfidenceBasedNodeTtlFetcherManager;
import com.facebook.presto.ttl.nodettlfetchermanagers.NodeTtlFetcherManager;
import com.facebook.presto.ttl.nodettlfetchermanagers.NodeTtlFetcherManagerConfig;
import com.facebook.presto.ttl.nodettlfetchermanagers.ThrowingNodeTtlFetcherManager;
import com.facebook.presto.util.FinalizerService;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.net.URI;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.stream.IntStream;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestNodeScheduler {
    private static final ConnectorId CONNECTOR_ID = new ConnectorId("connector_id");
    private FinalizerService finalizerService;
    private NodeTaskMap nodeTaskMap;
    private InMemoryNodeManager nodeManager;
    private NodeSchedulerConfig nodeSchedulerConfig;
    private NodeScheduler nodeScheduler;
    private NodeSelector nodeSelector;
    private Map<InternalNode, RemoteTask> taskMap;
    private ExecutorService remoteTaskExecutor;
    private ScheduledExecutorService remoteTaskScheduledExecutor;
    private Session session;

    @BeforeMethod
    public void setUp() {
        this.session = TestingSession.testSessionBuilder().build();
        this.finalizerService = new FinalizerService();
        this.nodeTaskMap = new NodeTaskMap(this.finalizerService);
        this.nodeManager = new InMemoryNodeManager();
        ImmutableList.Builder nodeBuilder = ImmutableList.builder();
        nodeBuilder.add((Object)new InternalNode("other1", URI.create("http://127.0.0.1:11"), NodeVersion.UNKNOWN, false));
        nodeBuilder.add((Object)new InternalNode("other2", URI.create("http://127.0.0.1:12"), NodeVersion.UNKNOWN, false));
        nodeBuilder.add((Object)new InternalNode("other3", URI.create("http://127.0.0.1:13"), NodeVersion.UNKNOWN, false));
        ImmutableList nodes = nodeBuilder.build();
        this.nodeManager.addNode(CONNECTOR_ID, (Iterable)nodes);
        this.nodeSchedulerConfig = new NodeSchedulerConfig().setMaxSplitsPerNode(20).setIncludeCoordinator(false).setMaxPendingSplitsPerTask(10);
        this.nodeScheduler = new NodeScheduler((NetworkTopology)new LegacyNetworkTopology(), (InternalNodeManager)this.nodeManager, new NodeSelectionStats(), this.nodeSchedulerConfig, this.nodeTaskMap, (NodeTtlFetcherManager)new ThrowingNodeTtlFetcherManager(), (QueryManager)new NoOpQueryManager(), new SimpleTtlNodeSelectorConfig());
        this.taskMap = new HashMap<InternalNode, RemoteTask>();
        this.nodeSelector = this.nodeScheduler.createNodeSelector(this.session, CONNECTOR_ID);
        this.remoteTaskExecutor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"remoteTaskExecutor-%s"));
        this.remoteTaskScheduledExecutor = Executors.newScheduledThreadPool(2, Threads.daemonThreadsNamed((String)"remoteTaskScheduledExecutor-%s"));
        this.finalizerService.start();
    }

    @AfterMethod
    public void tearDown() {
        this.remoteTaskExecutor.shutdown();
        this.remoteTaskScheduledExecutor.shutdown();
        this.finalizerService.destroy();
        this.nodeSchedulerConfig = null;
        this.nodeScheduler = null;
        this.nodeSelector = null;
    }

    @Test
    public void testScheduleLocal() {
        Split split = new Split(CONNECTOR_ID, (ConnectorTransactionHandle)TestingTransactionHandle.create(), (ConnectorSplit)new TestSplitLocal());
        ImmutableSet splits = ImmutableSet.of((Object)split);
        Map.Entry assignment = (Map.Entry)Iterables.getOnlyElement((Iterable)this.nodeSelector.computeAssignments((Set)splits, (List)ImmutableList.copyOf(this.taskMap.values())).getAssignments().entries());
        ModularHashingNodeProvider modularHashingNodeProvider = new ModularHashingNodeProvider(this.nodeSelector.getAllNodes());
        Assert.assertEquals((Object)((InternalNode)assignment.getKey()).getHostAndPort(), split.getPreferredNodes(key -> modularHashingNodeProvider.get(key, 3)).get(0));
        Assert.assertEquals(assignment.getValue(), (Object)split);
    }

    @Test(timeOut=60000L)
    public void testTopologyAwareScheduling() throws Exception {
        int i;
        TestingTransactionHandle transactionHandle = TestingTransactionHandle.create();
        NodeTaskMap nodeTaskMap = new NodeTaskMap(this.finalizerService);
        InMemoryNodeManager nodeManager = new InMemoryNodeManager();
        ImmutableList.Builder nodeBuilder = ImmutableList.builder();
        nodeBuilder.add((Object)new InternalNode("node1", URI.create("http://host1.rack1:11"), NodeVersion.UNKNOWN, false));
        nodeBuilder.add((Object)new InternalNode("node2", URI.create("http://host2.rack1:12"), NodeVersion.UNKNOWN, false));
        nodeBuilder.add((Object)new InternalNode("node3", URI.create("http://host3.rack2:13"), NodeVersion.UNKNOWN, false));
        ImmutableList nodes = nodeBuilder.build();
        nodeManager.addNode(CONNECTOR_ID, (Iterable)nodes);
        HashMap<InternalNode, MockRemoteTaskFactory.MockRemoteTask> taskMap = new HashMap<InternalNode, MockRemoteTaskFactory.MockRemoteTask>();
        NodeSchedulerConfig nodeSchedulerConfig = new NodeSchedulerConfig().setMaxSplitsPerNode(25).setIncludeCoordinator(false).setNetworkTopology("test").setMaxPendingSplitsPerTask(20);
        final TestNetworkTopology topology = new TestNetworkTopology();
        NetworkLocationCache locationCache = new NetworkLocationCache(topology){

            public NetworkLocation get(HostAddress host) {
                if (host.getHostText().startsWith("host")) {
                    return topology.locate(host);
                }
                return super.get(host);
            }
        };
        NodeScheduler nodeScheduler = new NodeScheduler(locationCache, (NetworkTopology)topology, (InternalNodeManager)nodeManager, new NodeSelectionStats(), nodeSchedulerConfig, nodeTaskMap, new Duration(5.0, TimeUnit.SECONDS), (NodeTtlFetcherManager)new ThrowingNodeTtlFetcherManager(), (QueryManager)new NoOpQueryManager(), new SimpleTtlNodeSelectorConfig());
        NodeSelector nodeSelector = nodeScheduler.createNodeSelector(this.session, CONNECTOR_ID);
        ImmutableSet.Builder nonRackLocalBuilder = ImmutableSet.builder();
        for (int i2 = 0; i2 < 108; ++i2) {
            nonRackLocalBuilder.add((Object)new Split(CONNECTOR_ID, (ConnectorTransactionHandle)transactionHandle, (ConnectorSplit)new TestSplitRemote(HostAddress.fromParts((String)"data.other_rack", (int)1))));
        }
        ImmutableSet nonRackLocalSplits = nonRackLocalBuilder.build();
        Multimap assignments = nodeSelector.computeAssignments((Set)nonRackLocalSplits, (List)ImmutableList.copyOf(taskMap.values())).getAssignments();
        MockRemoteTaskFactory remoteTaskFactory = new MockRemoteTaskFactory(this.remoteTaskExecutor, this.remoteTaskScheduledExecutor);
        int task = 0;
        for (InternalNode node : assignments.keySet()) {
            TaskId taskId = new TaskId("test", 1, 0, task, 0);
            ++task;
            MockRemoteTaskFactory.MockRemoteTask remoteTask = remoteTaskFactory.createTableScanTask(taskId, node, (List<Split>)ImmutableList.copyOf((Collection)assignments.get((Object)node)), nodeTaskMap.createTaskStatsTracker(node, taskId));
            remoteTask.startSplits(25);
            nodeTaskMap.addTask(node, (RemoteTask)remoteTask);
            taskMap.put(node, remoteTask);
        }
        nonRackLocalSplits = Sets.difference((Set)nonRackLocalSplits, new HashSet(assignments.values()));
        assignments = nodeSelector.computeAssignments((Set)nonRackLocalSplits, (List)ImmutableList.copyOf(taskMap.values())).getAssignments();
        for (InternalNode node : assignments.keySet()) {
            RemoteTask remoteTask = (RemoteTask)taskMap.get(node);
            remoteTask.addSplits((Multimap)ImmutableMultimap.builder().putAll((Object)new PlanNodeId("sourceId"), (Iterable)assignments.get((Object)node)).build());
        }
        nonRackLocalSplits = Sets.difference((Set)nonRackLocalSplits, new HashSet(assignments.values()));
        Assert.assertEquals((int)nonRackLocalSplits.size(), (int)3);
        ImmutableSet.Builder rackLocalSplits = ImmutableSet.builder();
        HostAddress dataHost1 = HostAddress.fromParts((String)"data.rack1", (int)1);
        HostAddress dataHost2 = HostAddress.fromParts((String)"data.rack2", (int)1);
        for (i = 0; i < 12; ++i) {
            rackLocalSplits.add((Object)new Split(CONNECTOR_ID, (ConnectorTransactionHandle)transactionHandle, (ConnectorSplit)new TestSplitRemote(dataHost1)));
        }
        for (i = 0; i < 6; ++i) {
            rackLocalSplits.add((Object)new Split(CONNECTOR_ID, (ConnectorTransactionHandle)transactionHandle, (ConnectorSplit)new TestSplitRemote(dataHost2)));
        }
        assignments = nodeSelector.computeAssignments((Set)rackLocalSplits.build(), (List)ImmutableList.copyOf(taskMap.values())).getAssignments();
        for (InternalNode node : assignments.keySet()) {
            RemoteTask remoteTask = (RemoteTask)taskMap.get(node);
            remoteTask.addSplits((Multimap)ImmutableMultimap.builder().putAll((Object)new PlanNodeId("sourceId"), (Iterable)assignments.get((Object)node)).build());
        }
        Sets.SetView unassigned = Sets.difference((Set)rackLocalSplits.build(), new HashSet(assignments.values()));
        boolean cacheRefreshed = false;
        while (!cacheRefreshed) {
            cacheRefreshed = true;
            if (locationCache.get(dataHost1).equals((Object)NetworkLocation.ROOT_LOCATION)) {
                cacheRefreshed = false;
            }
            if (locationCache.get(dataHost2).equals((Object)NetworkLocation.ROOT_LOCATION)) {
                cacheRefreshed = false;
            }
            TimeUnit.MILLISECONDS.sleep(10L);
        }
        assignments = nodeSelector.computeAssignments((Set)unassigned, (List)ImmutableList.copyOf(taskMap.values())).getAssignments();
        for (InternalNode node : assignments.keySet()) {
            RemoteTask remoteTask = (RemoteTask)taskMap.get(node);
            remoteTask.addSplits((Multimap)ImmutableMultimap.builder().putAll((Object)new PlanNodeId("sourceId"), (Iterable)assignments.get((Object)node)).build());
        }
        unassigned = Sets.difference((Set)unassigned, new HashSet(assignments.values()));
        Assert.assertEquals((int)unassigned.size(), (int)3);
        ModularHashingNodeProvider modularHashingNodeProvider = new ModularHashingNodeProvider(nodeSelector.getAllNodes());
        int rack1 = 0;
        int rack2 = 0;
        block16: for (Split split : unassigned) {
            String rack;
            switch (rack = (String)topology.locate((HostAddress)split.getPreferredNodes(key -> modularHashingNodeProvider.get(key, 2)).get(0)).getSegments().get(0)) {
                case "rack1": {
                    ++rack1;
                    continue block16;
                }
                case "rack2": {
                    ++rack2;
                    continue block16;
                }
            }
            Assert.fail();
        }
        Assert.assertEquals((int)rack1, (int)2);
        Assert.assertEquals((int)rack2, (int)1);
        ImmutableSet.Builder localSplits = ImmutableSet.builder();
        localSplits.add((Object)new Split(CONNECTOR_ID, (ConnectorTransactionHandle)transactionHandle, (ConnectorSplit)new TestSplitRemote(HostAddress.fromParts((String)"host1.rack1", (int)1))));
        localSplits.add((Object)new Split(CONNECTOR_ID, (ConnectorTransactionHandle)transactionHandle, (ConnectorSplit)new TestSplitRemote(HostAddress.fromParts((String)"host2.rack1", (int)1))));
        localSplits.add((Object)new Split(CONNECTOR_ID, (ConnectorTransactionHandle)transactionHandle, (ConnectorSplit)new TestSplitRemote(HostAddress.fromParts((String)"host3.rack2", (int)1))));
        assignments = nodeSelector.computeAssignments((Set)localSplits.build(), (List)ImmutableList.copyOf(taskMap.values())).getAssignments();
        Assert.assertEquals((int)assignments.size(), (int)3);
        Assert.assertEquals((int)assignments.keySet().size(), (int)3);
    }

    @Test
    public void testTtlAwareScheduling() {
        int i;
        InMemoryNodeManager nodeManager = new InMemoryNodeManager();
        InternalNode node1 = new InternalNode("other1", URI.create("http://127.0.0.1:11"), NodeVersion.UNKNOWN, false);
        InternalNode node2 = new InternalNode("other2", URI.create("http://127.0.0.1:12"), NodeVersion.UNKNOWN, false);
        InternalNode node3 = new InternalNode("other3", URI.create("http://127.0.0.1:13"), NodeVersion.UNKNOWN, false);
        ImmutableList nodes = ImmutableList.of((Object)node1, (Object)node2, (Object)node3);
        nodeManager.addNode(CONNECTOR_ID, (Iterable)nodes);
        NodeSchedulerConfig nodeSchedulerConfig = new NodeSchedulerConfig().setMaxSplitsPerNode(20).setIncludeCoordinator(false).setMaxPendingSplitsPerTask(10);
        Instant currentInstant = Instant.now();
        NodeTtl ttl1 = new NodeTtl((Set)ImmutableSet.of((Object)new ConfidenceBasedTtlInfo(currentInstant.plus(5L, ChronoUnit.MINUTES).getEpochSecond(), 100.0)));
        NodeTtl ttl2 = new NodeTtl((Set)ImmutableSet.of((Object)new ConfidenceBasedTtlInfo(currentInstant.plus(30L, ChronoUnit.MINUTES).getEpochSecond(), 100.0)));
        NodeTtl ttl3 = new NodeTtl((Set)ImmutableSet.of((Object)new ConfidenceBasedTtlInfo(currentInstant.plus(2L, ChronoUnit.HOURS).getEpochSecond(), 100.0)));
        ImmutableMap nodeToTtl = ImmutableMap.of((Object)new NodeInfo(node1.getNodeIdentifier(), node1.getHost()), (Object)ttl1, (Object)new NodeInfo(node2.getNodeIdentifier(), node2.getHost()), (Object)ttl2, (Object)new NodeInfo(node3.getNodeIdentifier(), node3.getHost()), (Object)ttl3);
        ConfidenceBasedNodeTtlFetcherManager nodeTtlFetcherManager = new ConfidenceBasedNodeTtlFetcherManager((InternalNodeManager)nodeManager, new NodeSchedulerConfig(), new NodeTtlFetcherManagerConfig());
        TestingNodeTtlFetcherFactory nodeTtlFetcherFactory = new TestingNodeTtlFetcherFactory((Map)nodeToTtl);
        nodeTtlFetcherManager.addNodeTtlFetcherFactory((NodeTtlFetcherFactory)nodeTtlFetcherFactory);
        nodeTtlFetcherManager.load(nodeTtlFetcherFactory.getName(), (Map)ImmutableMap.of());
        nodeTtlFetcherManager.refreshTtlInfo();
        TestingQueryManager queryManager = new TestingQueryManager();
        NodeScheduler fallbackEnabledNodeScheduler = new NodeScheduler((NetworkTopology)new LegacyNetworkTopology(), (InternalNodeManager)nodeManager, new NodeSelectionStats(), nodeSchedulerConfig, this.nodeTaskMap, (NodeTtlFetcherManager)nodeTtlFetcherManager, (QueryManager)queryManager, new SimpleTtlNodeSelectorConfig().setFallbackToSimpleNodeSelection(true));
        NodeScheduler fallbackDisabledNodeScheduler = new NodeScheduler((NetworkTopology)new LegacyNetworkTopology(), (InternalNodeManager)nodeManager, new NodeSelectionStats(), nodeSchedulerConfig, this.nodeTaskMap, (NodeTtlFetcherManager)nodeTtlFetcherManager, (QueryManager)queryManager, new SimpleTtlNodeSelectorConfig().setFallbackToSimpleNodeSelection(false));
        Session session = TestNodeScheduler.sessionWithTtlAwareSchedulingStrategyAndEstimatedExecutionTime(new Duration(20.0, TimeUnit.MINUTES));
        NodeSelector nodeSelector = fallbackEnabledNodeScheduler.createNodeSelector(session, CONNECTOR_ID);
        queryManager.setExecutionTime(new Duration(3.0, TimeUnit.MINUTES));
        Assert.assertEquals((Set)ImmutableSet.copyOf((Collection)nodeSelector.selectRandomNodes(3)), (Set)ImmutableSet.of((Object)node2, (Object)node3));
        session = TestNodeScheduler.sessionWithTtlAwareSchedulingStrategyAndEstimatedExecutionTime(new Duration(5.0, TimeUnit.HOURS));
        nodeSelector = fallbackEnabledNodeScheduler.createNodeSelector(session, CONNECTOR_ID);
        queryManager.setExecutionTime(new Duration(1.0, TimeUnit.HOURS));
        Assert.assertEquals((Set)ImmutableSet.copyOf((Collection)nodeSelector.selectRandomNodes(3)), (Set)ImmutableSet.of((Object)node1, (Object)node2, (Object)node3));
        session = TestNodeScheduler.sessionWithTtlAwareSchedulingStrategyAndEstimatedExecutionTime(new Duration(5.0, TimeUnit.HOURS));
        nodeSelector = fallbackDisabledNodeScheduler.createNodeSelector(session, CONNECTOR_ID);
        queryManager.setExecutionTime(new Duration(1.0, TimeUnit.HOURS));
        Assert.assertEquals((Set)ImmutableSet.copyOf((Collection)nodeSelector.selectRandomNodes(3, (Set)ImmutableSet.of((Object)node2, (Object)node3))), (Set)ImmutableSet.of());
        session = TestNodeScheduler.sessionWithTtlAwareSchedulingStrategyAndEstimatedExecutionTime(new Duration(1.0, TimeUnit.HOURS));
        nodeSelector = fallbackEnabledNodeScheduler.createNodeSelector(session, CONNECTOR_ID);
        queryManager.setExecutionTime(new Duration(45.0, TimeUnit.MINUTES));
        HashSet<Split> splits = new HashSet<Split>();
        for (int i2 = 0; i2 < 2; ++i2) {
            splits.add(new Split(CONNECTOR_ID, (ConnectorTransactionHandle)TestingTransactionHandle.create(), (ConnectorSplit)new TestSplitRemote()));
        }
        Multimap assignments = nodeSelector.computeAssignments(splits, (List)ImmutableList.copyOf(this.taskMap.values())).getAssignments();
        Assert.assertEquals((int)assignments.size(), (int)2);
        Assert.assertTrue((boolean)assignments.keySet().contains(node2));
        Assert.assertTrue((boolean)assignments.keySet().contains(node3));
        session = TestNodeScheduler.sessionWithTtlAwareSchedulingStrategyAndEstimatedExecutionTime(new Duration(5.0, TimeUnit.HOURS));
        nodeSelector = fallbackEnabledNodeScheduler.createNodeSelector(session, CONNECTOR_ID);
        queryManager.setExecutionTime(new Duration(1.0, TimeUnit.HOURS));
        splits.clear();
        for (i = 0; i < 3; ++i) {
            splits.add(new Split(CONNECTOR_ID, (ConnectorTransactionHandle)TestingTransactionHandle.create(), (ConnectorSplit)new TestSplitRemote()));
        }
        assignments = nodeSelector.computeAssignments(splits, (List)ImmutableList.copyOf(this.taskMap.values())).getAssignments();
        Assert.assertEquals((int)assignments.size(), (int)3);
        Assert.assertEquals((int)assignments.keySet().size(), (int)3);
        Assert.assertTrue((boolean)assignments.keySet().contains(node1));
        Assert.assertTrue((boolean)assignments.keySet().contains(node2));
        Assert.assertTrue((boolean)assignments.keySet().contains(node3));
        session = TestNodeScheduler.sessionWithTtlAwareSchedulingStrategyAndEstimatedExecutionTime(new Duration(1.0, TimeUnit.HOURS));
        nodeSelector = fallbackEnabledNodeScheduler.createNodeSelector(session, CONNECTOR_ID);
        queryManager.setExecutionTime(new Duration(20.0, TimeUnit.MINUTES));
        splits.clear();
        for (i = 0; i < 2; ++i) {
            splits.add(new Split(CONNECTOR_ID, (ConnectorTransactionHandle)TestingTransactionHandle.create(), (ConnectorSplit)new TestSplitRemote()));
        }
        assignments = nodeSelector.computeAssignments(splits, (List)ImmutableList.copyOf(this.taskMap.values())).getAssignments();
        Assert.assertEquals((int)assignments.size(), (int)2);
        Assert.assertEquals((int)assignments.keySet().size(), (int)1);
        Assert.assertTrue((boolean)assignments.keySet().contains(node3));
    }

    @Test
    public void testScheduleRemote() {
        HashSet<Split> splits = new HashSet<Split>();
        splits.add(new Split(CONNECTOR_ID, (ConnectorTransactionHandle)TestingTransactionHandle.create(), (ConnectorSplit)new TestSplitRemote()));
        Multimap assignments = this.nodeSelector.computeAssignments(splits, (List)ImmutableList.copyOf(this.taskMap.values())).getAssignments();
        Assert.assertEquals((int)assignments.size(), (int)1);
    }

    @Test
    public void testBasicAssignment() {
        HashSet<Split> splits = new HashSet<Split>();
        for (int i = 0; i < 3; ++i) {
            splits.add(new Split(CONNECTOR_ID, (ConnectorTransactionHandle)TestingTransactionHandle.create(), (ConnectorSplit)new TestSplitRemote()));
        }
        Multimap assignments = this.nodeSelector.computeAssignments(splits, (List)ImmutableList.copyOf(this.taskMap.values())).getAssignments();
        Assert.assertEquals((int)assignments.entries().size(), (int)3);
        for (InternalNode node : this.nodeManager.getActiveConnectorNodes(CONNECTOR_ID)) {
            Assert.assertTrue((boolean)assignments.keySet().contains(node));
        }
    }

    @Test
    public void testBasicAssignmentMaxUnacknowledgedSplitsPerTask() {
        this.nodeSelector = this.nodeScheduler.createNodeSelector(TestNodeScheduler.sessionWithMaxUnacknowledgedSplitsPerTask(1), CONNECTOR_ID, Integer.MAX_VALUE);
        int nodeCount = this.nodeManager.getActiveConnectorNodes(CONNECTOR_ID).size();
        int splitCount = nodeCount + 1;
        HashSet<Split> splits = new HashSet<Split>();
        for (int i = 0; i < splitCount; ++i) {
            splits.add(new Split(CONNECTOR_ID, (ConnectorTransactionHandle)TestingTransactionHandle.create(), (ConnectorSplit)new TestSplitRemote()));
        }
        Multimap assignments = this.nodeSelector.computeAssignments(splits, (List)ImmutableList.copyOf(this.taskMap.values())).getAssignments();
        Assert.assertEquals((int)assignments.entries().size(), (int)nodeCount);
        for (InternalNode node : this.nodeManager.getActiveConnectorNodes(CONNECTOR_ID)) {
            Assert.assertTrue((boolean)assignments.keySet().contains(node));
        }
    }

    @Test
    public void testAffinityAssignmentNotSupported() {
        NodeTaskMap nodeTaskMap = new NodeTaskMap(this.finalizerService);
        TestingTransactionHandle transactionHandle = TestingTransactionHandle.create();
        NodeSchedulerConfig nodeSchedulerConfig = new NodeSchedulerConfig().setMaxSplitsPerNode(20).setIncludeCoordinator(false).setMaxPendingSplitsPerTask(10);
        LegacyNetworkTopology legacyNetworkTopology = new LegacyNetworkTopology();
        NodeScheduler nodeScheduler = new NodeScheduler(new NetworkLocationCache((NetworkTopology)legacyNetworkTopology), (NetworkTopology)legacyNetworkTopology, (InternalNodeManager)this.nodeManager, new NodeSelectionStats(), nodeSchedulerConfig, nodeTaskMap, new Duration(0.0, TimeUnit.SECONDS), (NodeTtlFetcherManager)new ThrowingNodeTtlFetcherManager(), (QueryManager)new NoOpQueryManager(), new SimpleTtlNodeSelectorConfig());
        NodeSelector nodeSelector = nodeScheduler.createNodeSelector(this.session, CONNECTOR_ID, 2);
        HashSet<Split> splits = new HashSet<Split>();
        splits.add(new Split(CONNECTOR_ID, (ConnectorTransactionHandle)transactionHandle, (ConnectorSplit)new TestSplitRemote(HostAddress.fromString((String)"127.0.0.1:10"))));
        splits.add(new Split(CONNECTOR_ID, (ConnectorTransactionHandle)transactionHandle, (ConnectorSplit)new TestSplitRemote(HostAddress.fromString((String)"127.0.0.1:10"))));
        SplitPlacementResult splitPlacementResult = nodeSelector.computeAssignments(splits, (List)ImmutableList.of());
        Set internalNodes = splitPlacementResult.getAssignments().keySet();
        Assert.assertEquals((int)internalNodes.size(), (int)2);
    }

    @Test
    public void testAffinityAssignmentWithModularHashing() {
        NodeTaskMap nodeTaskMap = new NodeTaskMap(this.finalizerService);
        TestingTransactionHandle transactionHandle = TestingTransactionHandle.create();
        NodeSchedulerConfig nodeSchedulerConfig = new NodeSchedulerConfig().setMaxSplitsPerNode(20).setIncludeCoordinator(false).setMaxPendingSplitsPerTask(10);
        NodeScheduler nodeScheduler = new NodeScheduler((NetworkTopology)new LegacyNetworkTopology(), (InternalNodeManager)this.nodeManager, new NodeSelectionStats(), nodeSchedulerConfig, nodeTaskMap, (NodeTtlFetcherManager)new ThrowingNodeTtlFetcherManager(), (QueryManager)new NoOpQueryManager(), new SimpleTtlNodeSelectorConfig());
        NodeSelector nodeSelector = nodeScheduler.createNodeSelector(this.session, CONNECTOR_ID, 3);
        HashSet<Split> splits = new HashSet<Split>();
        splits.add(new Split(CONNECTOR_ID, (ConnectorTransactionHandle)transactionHandle, (ConnectorSplit)new TestAffinitySplitRemote(1)));
        SplitPlacementResult splitPlacementResult = nodeSelector.computeAssignments(splits, (List)ImmutableList.of());
        Set internalNodes = splitPlacementResult.getAssignments().keySet();
        Assert.assertEquals((int)internalNodes.size(), (int)1);
        splits.add(new Split(CONNECTOR_ID, (ConnectorTransactionHandle)transactionHandle, (ConnectorSplit)new TestAffinitySplitRemote(2)));
        splitPlacementResult = nodeSelector.computeAssignments(splits, this.getRemoteTableScanTask(splitPlacementResult));
        Set internalNodesSecondCall = splitPlacementResult.getAssignments().keySet();
        Assert.assertEquals((int)internalNodesSecondCall.size(), (int)2);
        splits.add(new Split(CONNECTOR_ID, (ConnectorTransactionHandle)transactionHandle, (ConnectorSplit)new TestAffinitySplitRemote(4)));
        splitPlacementResult = nodeSelector.computeAssignments(splits, this.getRemoteTableScanTask(splitPlacementResult));
        Assert.assertEquals((int)splitPlacementResult.getAssignments().keySet().size(), (int)2);
        splits.add(new Split(CONNECTOR_ID, (ConnectorTransactionHandle)transactionHandle, (ConnectorSplit)new TestAffinitySplitRemote(3)));
        splitPlacementResult = nodeSelector.computeAssignments(splits, this.getRemoteTableScanTask(splitPlacementResult));
        Assert.assertEquals((int)splitPlacementResult.getAssignments().keySet().size(), (int)3);
    }

    @Test
    public void testAffinityAssignmentWithConsistentHashing() {
        NodeTaskMap nodeTaskMap = new NodeTaskMap(this.finalizerService);
        TestingTransactionHandle transactionHandle = TestingTransactionHandle.create();
        NodeSchedulerConfig nodeSchedulerConfig = new NodeSchedulerConfig().setNodeSelectionHashStrategy(NodeSelectionHashStrategy.CONSISTENT_HASHING).setMinVirtualNodeCount(3).setMaxSplitsPerNode(20).setIncludeCoordinator(false).setMaxPendingSplitsPerTask(10);
        NodeScheduler nodeScheduler = new NodeScheduler((NetworkTopology)new LegacyNetworkTopology(), (InternalNodeManager)this.nodeManager, new NodeSelectionStats(), nodeSchedulerConfig, nodeTaskMap, (NodeTtlFetcherManager)new ThrowingNodeTtlFetcherManager(), (QueryManager)new NoOpQueryManager(), new SimpleTtlNodeSelectorConfig());
        NodeSelector nodeSelector = nodeScheduler.createNodeSelector(this.session, CONNECTOR_ID, 3);
        HashSet splits = new HashSet();
        IntStream.range(0, 10).forEach(i -> splits.add(new Split(CONNECTOR_ID, (ConnectorTransactionHandle)transactionHandle, (ConnectorSplit)new TestAffinitySplitRemote(i))));
        InternalNode node1 = new InternalNode("other1", URI.create("http://127.0.0.1:11"), NodeVersion.UNKNOWN, false);
        InternalNode node2 = new InternalNode("other2", URI.create("http://127.0.0.1:12"), NodeVersion.UNKNOWN, false);
        InternalNode node3 = new InternalNode("other3", URI.create("http://127.0.0.1:13"), NodeVersion.UNKNOWN, false);
        InternalNode node4 = new InternalNode("other4", URI.create("http://127.0.0.1:14"), NodeVersion.UNKNOWN, false);
        SplitPlacementResult splitPlacementResult = nodeSelector.computeAssignments(splits, (List)ImmutableList.of());
        Assert.assertEquals((int)splitPlacementResult.getAssignments().keySet().size(), (int)3);
        Collection node1Splits = (Collection)splitPlacementResult.getAssignments().get((Object)node1).stream().map(Split::getConnectorSplit).collect(ImmutableSet.toImmutableSet());
        Collection node2Splits = (Collection)splitPlacementResult.getAssignments().get((Object)node2).stream().map(Split::getConnectorSplit).collect(ImmutableSet.toImmutableSet());
        Collection node3Splits = (Collection)splitPlacementResult.getAssignments().get((Object)node3).stream().map(Split::getConnectorSplit).collect(ImmutableSet.toImmutableSet());
        nodeSelector = nodeScheduler.createNodeSelector(this.session, CONNECTOR_ID, 3);
        splitPlacementResult = nodeSelector.computeAssignments(splits, (List)ImmutableList.of());
        Assert.assertEquals((Collection)((Collection)splitPlacementResult.getAssignments().get((Object)node1).stream().map(Split::getConnectorSplit).collect(ImmutableSet.toImmutableSet())), (Collection)node1Splits);
        Assert.assertEquals((Collection)((Collection)splitPlacementResult.getAssignments().get((Object)node2).stream().map(Split::getConnectorSplit).collect(ImmutableSet.toImmutableSet())), (Collection)node2Splits);
        Assert.assertEquals((Collection)((Collection)splitPlacementResult.getAssignments().get((Object)node3).stream().map(Split::getConnectorSplit).collect(ImmutableSet.toImmutableSet())), (Collection)node3Splits);
        this.nodeManager.addNode(CONNECTOR_ID, new InternalNode[]{node4});
        nodeSelector = nodeScheduler.createNodeSelector(this.session, CONNECTOR_ID, 3);
        splitPlacementResult = nodeSelector.computeAssignments(splits, (List)ImmutableList.of());
        Assert.assertEquals((int)splitPlacementResult.getAssignments().keySet().size(), (int)3);
        Assert.assertEquals((Collection)splitPlacementResult.getAssignments().get((Object)node1), (Collection)ImmutableList.of());
        Assert.assertEquals((Collection)((Collection)splitPlacementResult.getAssignments().get((Object)node2).stream().map(Split::getConnectorSplit).collect(ImmutableSet.toImmutableSet())), (Collection)node2Splits);
        Assert.assertEquals((Collection)((Collection)splitPlacementResult.getAssignments().get((Object)node3).stream().map(Split::getConnectorSplit).collect(ImmutableSet.toImmutableSet())), (Collection)node3Splits);
        Assert.assertEquals((Collection)((Collection)splitPlacementResult.getAssignments().get((Object)node4).stream().map(Split::getConnectorSplit).collect(ImmutableSet.toImmutableSet())), (Collection)node1Splits);
    }

    @Test
    public void testAffinityAssignmentWithConsistentHashingWithVirtualNodes() {
        NodeTaskMap nodeTaskMap = new NodeTaskMap(this.finalizerService);
        TestingTransactionHandle transactionHandle = TestingTransactionHandle.create();
        NodeSchedulerConfig nodeSchedulerConfig = new NodeSchedulerConfig().setNodeSelectionHashStrategy(NodeSelectionHashStrategy.CONSISTENT_HASHING).setMinVirtualNodeCount(5).setMaxSplitsPerNode(20).setIncludeCoordinator(false).setMaxPendingSplitsPerTask(10);
        NodeScheduler nodeScheduler = new NodeScheduler((NetworkTopology)new LegacyNetworkTopology(), (InternalNodeManager)this.nodeManager, new NodeSelectionStats(), nodeSchedulerConfig, nodeTaskMap, (NodeTtlFetcherManager)new ThrowingNodeTtlFetcherManager(), (QueryManager)new NoOpQueryManager(), new SimpleTtlNodeSelectorConfig());
        NodeSelector nodeSelector = nodeScheduler.createNodeSelector(this.session, CONNECTOR_ID, 3);
        HashSet splits = new HashSet();
        IntStream.range(0, 10).forEach(i -> splits.add(new Split(CONNECTOR_ID, (ConnectorTransactionHandle)transactionHandle, (ConnectorSplit)new TestAffinitySplitRemote(i))));
        InternalNode node1 = new InternalNode("other1", URI.create("http://127.0.0.1:11"), NodeVersion.UNKNOWN, false);
        InternalNode node2 = new InternalNode("other2", URI.create("http://127.0.0.1:12"), NodeVersion.UNKNOWN, false);
        InternalNode node3 = new InternalNode("other3", URI.create("http://127.0.0.1:13"), NodeVersion.UNKNOWN, false);
        InternalNode node4 = new InternalNode("other4", URI.create("http://127.0.0.1:14"), NodeVersion.UNKNOWN, false);
        SplitPlacementResult splitPlacementResult = nodeSelector.computeAssignments(splits, (List)ImmutableList.of());
        Assert.assertEquals((int)splitPlacementResult.getAssignments().keySet().size(), (int)3);
        Collection node1Splits = (Collection)splitPlacementResult.getAssignments().get((Object)node1).stream().map(Split::getConnectorSplit).collect(ImmutableSet.toImmutableSet());
        Collection node2Splits = (Collection)splitPlacementResult.getAssignments().get((Object)node2).stream().map(Split::getConnectorSplit).collect(ImmutableSet.toImmutableSet());
        Collection node3Splits = (Collection)splitPlacementResult.getAssignments().get((Object)node3).stream().map(Split::getConnectorSplit).collect(ImmutableSet.toImmutableSet());
        nodeSelector = nodeScheduler.createNodeSelector(this.session, CONNECTOR_ID, 3);
        splitPlacementResult = nodeSelector.computeAssignments(splits, (List)ImmutableList.of());
        Assert.assertEquals((Collection)((Collection)splitPlacementResult.getAssignments().get((Object)node1).stream().map(Split::getConnectorSplit).collect(ImmutableSet.toImmutableSet())), (Collection)node1Splits);
        Assert.assertEquals((Collection)((Collection)splitPlacementResult.getAssignments().get((Object)node2).stream().map(Split::getConnectorSplit).collect(ImmutableSet.toImmutableSet())), (Collection)node2Splits);
        Assert.assertEquals((Collection)((Collection)splitPlacementResult.getAssignments().get((Object)node3).stream().map(Split::getConnectorSplit).collect(ImmutableSet.toImmutableSet())), (Collection)node3Splits);
        this.nodeManager.addNode(CONNECTOR_ID, new InternalNode[]{node4});
        nodeSelector = nodeScheduler.createNodeSelector(this.session, CONNECTOR_ID, 3);
        splitPlacementResult = nodeSelector.computeAssignments(splits, (List)ImmutableList.of());
        Assert.assertEquals((int)splitPlacementResult.getAssignments().keySet().size(), (int)4);
        Assert.assertEquals((Set)((Set)splitPlacementResult.getAssignments().get((Object)node1).stream().map(Split::getConnectorSplit).map(ConnectorSplit::getSplitIdentifier).collect(ImmutableSet.toImmutableSet())), (Set)ImmutableSet.of((Object)4));
        Assert.assertEquals((Collection)((Collection)splitPlacementResult.getAssignments().get((Object)node2).stream().map(Split::getConnectorSplit).collect(ImmutableSet.toImmutableSet())), (Collection)node2Splits);
        Assert.assertEquals((Set)((Set)splitPlacementResult.getAssignments().get((Object)node3).stream().map(Split::getConnectorSplit).map(ConnectorSplit::getSplitIdentifier).collect(ImmutableSet.toImmutableSet())), (Set)ImmutableSet.of((Object)1, (Object)2, (Object)3, (Object)7, (Object)9));
        Assert.assertEquals((Set)((Set)splitPlacementResult.getAssignments().get((Object)node4).stream().map(Split::getConnectorSplit).map(ConnectorSplit::getSplitIdentifier).collect(ImmutableSet.toImmutableSet())), (Set)ImmutableSet.of((Object)5, (Object)6, (Object)8));
    }

    @Test
    public void testHardAffinityAssignment() {
        NodeTaskMap nodeTaskMap = new NodeTaskMap(this.finalizerService);
        TestingTransactionHandle transactionHandle = TestingTransactionHandle.create();
        NodeSchedulerConfig nodeSchedulerConfig = new NodeSchedulerConfig().setMaxSplitsPerNode(20).setIncludeCoordinator(false).setMaxPendingSplitsPerTask(10);
        NodeScheduler nodeScheduler = new NodeScheduler((NetworkTopology)new LegacyNetworkTopology(), (InternalNodeManager)this.nodeManager, new NodeSelectionStats(), nodeSchedulerConfig, nodeTaskMap, (NodeTtlFetcherManager)new ThrowingNodeTtlFetcherManager(), (QueryManager)new NoOpQueryManager(), new SimpleTtlNodeSelectorConfig());
        NodeSelector nodeSelector = nodeScheduler.createNodeSelector(this.session, CONNECTOR_ID, 3);
        HashSet<Split> splits = new HashSet<Split>();
        splits.add(new Split(CONNECTOR_ID, (ConnectorTransactionHandle)transactionHandle, (ConnectorSplit)new TestHardAffinitySplitRemote()));
        splits.add(new Split(CONNECTOR_ID, (ConnectorTransactionHandle)transactionHandle, (ConnectorSplit)new TestHardAffinitySplitRemote()));
        splits.add(new Split(CONNECTOR_ID, (ConnectorTransactionHandle)transactionHandle, (ConnectorSplit)new TestHardAffinitySplitRemote()));
        SplitPlacementResult splitPlacementResult = nodeSelector.computeAssignments(splits, (List)ImmutableList.of());
        for (Split split : splitPlacementResult.getAssignments().values()) {
            Assert.assertTrue((boolean)split.getSplitContext().isCacheable());
        }
    }

    @Test
    public void testMaxSplitsPerNode() {
        TestingTransactionHandle transactionHandle = TestingTransactionHandle.create();
        InternalNode newNode = new InternalNode("other4", URI.create("http://127.0.0.1:14"), NodeVersion.UNKNOWN, false);
        this.nodeManager.addNode(CONNECTOR_ID, new InternalNode[]{newNode});
        ImmutableList.Builder initialSplits = ImmutableList.builder();
        for (int i = 0; i < 10; ++i) {
            initialSplits.add((Object)new Split(CONNECTOR_ID, (ConnectorTransactionHandle)transactionHandle, (ConnectorSplit)new TestSplitRemote()));
        }
        MockRemoteTaskFactory remoteTaskFactory = new MockRemoteTaskFactory(this.remoteTaskExecutor, this.remoteTaskScheduledExecutor);
        TaskId taskId1 = new TaskId("test", 1, 0, 1, 0);
        MockRemoteTaskFactory.MockRemoteTask remoteTask1 = remoteTaskFactory.createTableScanTask(taskId1, newNode, (List<Split>)initialSplits.build(), this.nodeTaskMap.createTaskStatsTracker(newNode, taskId1));
        this.nodeTaskMap.addTask(newNode, (RemoteTask)remoteTask1);
        TaskId taskId2 = new TaskId("test", 1, 0, 2, 0);
        MockRemoteTaskFactory.MockRemoteTask remoteTask2 = remoteTaskFactory.createTableScanTask(taskId2, newNode, (List<Split>)initialSplits.build(), this.nodeTaskMap.createTaskStatsTracker(newNode, taskId2));
        this.nodeTaskMap.addTask(newNode, (RemoteTask)remoteTask2);
        HashSet<Split> splits = new HashSet<Split>();
        for (int i = 0; i < 5; ++i) {
            splits.add(new Split(CONNECTOR_ID, (ConnectorTransactionHandle)transactionHandle, (ConnectorSplit)new TestSplitRemote()));
        }
        Multimap assignments = this.nodeSelector.computeAssignments(splits, (List)ImmutableList.copyOf(this.taskMap.values())).getAssignments();
        Assert.assertFalse((boolean)assignments.keySet().contains(newNode));
        remoteTask1.abort();
        remoteTask2.abort();
        Assert.assertEquals((Object)this.nodeTaskMap.getPartitionedSplitsOnNode(newNode), (Object)PartitionedSplitsInfo.forZeroSplits());
    }

    @Test
    public void testMaxSplitsPerNodePerTask() {
        TestingTransactionHandle transactionHandle = TestingTransactionHandle.create();
        InternalNode newNode = new InternalNode("other4", URI.create("http://127.0.0.1:14"), NodeVersion.UNKNOWN, false);
        this.nodeManager.addNode(CONNECTOR_ID, new InternalNode[]{newNode});
        ImmutableList.Builder initialSplits = ImmutableList.builder();
        for (int i = 0; i < 20; ++i) {
            initialSplits.add((Object)new Split(CONNECTOR_ID, (ConnectorTransactionHandle)transactionHandle, (ConnectorSplit)new TestSplitRemote()));
        }
        ArrayList<MockRemoteTaskFactory.MockRemoteTask> tasks = new ArrayList<MockRemoteTaskFactory.MockRemoteTask>();
        MockRemoteTaskFactory remoteTaskFactory = new MockRemoteTaskFactory(this.remoteTaskExecutor, this.remoteTaskScheduledExecutor);
        for (InternalNode node : this.nodeManager.getActiveConnectorNodes(CONNECTOR_ID)) {
            TaskId taskId = new TaskId("test", 1, 0, 1, 0);
            MockRemoteTaskFactory.MockRemoteTask remoteTask = remoteTaskFactory.createTableScanTask(taskId, node, (List<Split>)initialSplits.build(), this.nodeTaskMap.createTaskStatsTracker(node, taskId));
            this.nodeTaskMap.addTask(node, (RemoteTask)remoteTask);
            tasks.add(remoteTask);
        }
        TaskId taskId = new TaskId("test", 1, 0, 2, 0);
        MockRemoteTaskFactory.MockRemoteTask newRemoteTask = remoteTaskFactory.createTableScanTask(taskId, newNode, (List<Split>)initialSplits.build(), this.nodeTaskMap.createTaskStatsTracker(newNode, taskId));
        this.taskMap.put(newNode, newRemoteTask);
        this.nodeTaskMap.addTask(newNode, (RemoteTask)newRemoteTask);
        tasks.add(newRemoteTask);
        HashSet<Split> splits = new HashSet<Split>();
        for (int i = 0; i < 5; ++i) {
            splits.add(new Split(CONNECTOR_ID, (ConnectorTransactionHandle)transactionHandle, (ConnectorSplit)new TestSplitRemote()));
        }
        Multimap assignments = this.nodeSelector.computeAssignments(splits, (List)ImmutableList.copyOf(this.taskMap.values())).getAssignments();
        Assert.assertEquals((int)assignments.keySet().size(), (int)3);
        Assert.assertFalse((boolean)assignments.keySet().contains(newNode));
        for (RemoteTask remoteTask : tasks) {
            remoteTask.abort();
        }
        Assert.assertEquals((Object)this.nodeTaskMap.getPartitionedSplitsOnNode(newNode), (Object)PartitionedSplitsInfo.forZeroSplits());
    }

    @Test
    public void testMaxUnacknowledgedSplitsPerTask() {
        int maxUnacknowledgedSplitsPerTask = 5;
        this.nodeSelector = this.nodeScheduler.createNodeSelector(TestNodeScheduler.sessionWithMaxUnacknowledgedSplitsPerTask(maxUnacknowledgedSplitsPerTask), CONNECTOR_ID, Integer.MAX_VALUE);
        TestingTransactionHandle transactionHandle = TestingTransactionHandle.create();
        ImmutableList.Builder initialSplits = ImmutableList.builder();
        for (int i = 0; i < maxUnacknowledgedSplitsPerTask; ++i) {
            initialSplits.add((Object)new Split(CONNECTOR_ID, (ConnectorTransactionHandle)transactionHandle, (ConnectorSplit)new TestSplitRemote()));
        }
        ArrayList<InternalNode> nodes = new ArrayList<InternalNode>();
        ArrayList<MockRemoteTaskFactory.MockRemoteTask> tasks = new ArrayList<MockRemoteTaskFactory.MockRemoteTask>();
        MockRemoteTaskFactory remoteTaskFactory = new MockRemoteTaskFactory(this.remoteTaskExecutor, this.remoteTaskScheduledExecutor);
        int counter = 1;
        for (InternalNode node : this.nodeManager.getActiveConnectorNodes(CONNECTOR_ID)) {
            TaskId taskId = new TaskId("test", 1, 0, counter, 0);
            ++counter;
            MockRemoteTaskFactory.MockRemoteTask remoteTask = remoteTaskFactory.createTableScanTask(taskId, node, (List<Split>)initialSplits.build(), this.nodeTaskMap.createTaskStatsTracker(node, taskId));
            this.nodeTaskMap.addTask(node, (RemoteTask)remoteTask);
            remoteTask.setMaxUnacknowledgedSplits(maxUnacknowledgedSplitsPerTask);
            remoteTask.setUnacknowledgedSplits(maxUnacknowledgedSplitsPerTask);
            nodes.add(node);
            tasks.add(remoteTask);
        }
        HashSet<Split> splits = new HashSet<Split>();
        for (int i = 0; i < nodes.size(); ++i) {
            splits.add(new Split(CONNECTOR_ID, (ConnectorTransactionHandle)transactionHandle, (ConnectorSplit)new TestSplitRemote()));
        }
        SplitPlacementResult splitPlacements = this.nodeSelector.computeAssignments(splits, (List)ImmutableList.copyOf(tasks));
        Assert.assertEquals((int)splitPlacements.getAssignments().size(), (int)0);
        Assert.assertFalse((boolean)splitPlacements.getBlocked().isDone());
        MockRemoteTaskFactory.MockRemoteTask taskOne = (MockRemoteTaskFactory.MockRemoteTask)tasks.get(0);
        taskOne.finishSplits(1);
        taskOne.setUnacknowledgedSplits(taskOne.getUnacknowledgedPartitionedSplitCount() - 1);
        Assert.assertTrue((boolean)splitPlacements.getBlocked().isDone());
        splitPlacements = this.nodeSelector.computeAssignments(splits, (List)ImmutableList.copyOf(tasks));
        Assert.assertEquals((int)splitPlacements.getAssignments().size(), (int)1);
        Assert.assertTrue((boolean)splitPlacements.getAssignments().keySet().contains(nodes.get(0)));
        taskOne.clearSplits();
        tasks.forEach(task -> task.setUnacknowledgedSplits(maxUnacknowledgedSplitsPerTask - 1));
        splitPlacements = this.nodeSelector.computeAssignments(splits, (List)ImmutableList.copyOf(tasks));
        Assert.assertEquals((int)splitPlacements.getAssignments().size(), (int)nodes.size());
        Assert.assertTrue((boolean)splitPlacements.getAssignments().keySet().containsAll(nodes));
    }

    @Test
    public void testTaskCompletion() throws Exception {
        MockRemoteTaskFactory remoteTaskFactory = new MockRemoteTaskFactory(this.remoteTaskExecutor, this.remoteTaskScheduledExecutor);
        InternalNode chosenNode = (InternalNode)Iterables.get((Iterable)this.nodeManager.getActiveConnectorNodes(CONNECTOR_ID), (int)0);
        TaskId taskId = new TaskId("test", 1, 0, 1, 0);
        MockRemoteTaskFactory.MockRemoteTask remoteTask = remoteTaskFactory.createTableScanTask(taskId, chosenNode, (List<Split>)ImmutableList.of((Object)new Split(CONNECTOR_ID, (ConnectorTransactionHandle)TestingTransactionHandle.create(), (ConnectorSplit)new TestSplitRemote())), this.nodeTaskMap.createTaskStatsTracker(chosenNode, taskId));
        this.nodeTaskMap.addTask(chosenNode, (RemoteTask)remoteTask);
        Assert.assertEquals((Object)this.nodeTaskMap.getPartitionedSplitsOnNode(chosenNode), (Object)TestNodeScheduler.standardWeightSplitsInfo(1));
        remoteTask.abort();
        TimeUnit.MILLISECONDS.sleep(100L);
        Assert.assertEquals((Object)this.nodeTaskMap.getPartitionedSplitsOnNode(chosenNode), (Object)PartitionedSplitsInfo.forZeroSplits());
        remoteTask.abort();
        Assert.assertEquals((Object)this.nodeTaskMap.getPartitionedSplitsOnNode(chosenNode), (Object)PartitionedSplitsInfo.forZeroSplits());
    }

    @Test
    public void testSplitCount() {
        MockRemoteTaskFactory remoteTaskFactory = new MockRemoteTaskFactory(this.remoteTaskExecutor, this.remoteTaskScheduledExecutor);
        InternalNode chosenNode = (InternalNode)Iterables.get((Iterable)this.nodeManager.getActiveConnectorNodes(CONNECTOR_ID), (int)0);
        TaskId taskId1 = new TaskId("test", 1, 0, 1, 0);
        MockRemoteTaskFactory.MockRemoteTask remoteTask1 = remoteTaskFactory.createTableScanTask(taskId1, chosenNode, (List<Split>)ImmutableList.of((Object)new Split(CONNECTOR_ID, (ConnectorTransactionHandle)TestingTransactionHandle.create(), (ConnectorSplit)new TestSplitRemote()), (Object)new Split(CONNECTOR_ID, (ConnectorTransactionHandle)TestingTransactionHandle.create(), (ConnectorSplit)new TestSplitRemote())), this.nodeTaskMap.createTaskStatsTracker(chosenNode, taskId1));
        TaskId taskId2 = new TaskId("test", 1, 0, 2, 0);
        MockRemoteTaskFactory.MockRemoteTask remoteTask2 = remoteTaskFactory.createTableScanTask(taskId2, chosenNode, (List<Split>)ImmutableList.of((Object)new Split(CONNECTOR_ID, (ConnectorTransactionHandle)TestingTransactionHandle.create(), (ConnectorSplit)new TestSplitRemote())), this.nodeTaskMap.createTaskStatsTracker(chosenNode, taskId2));
        this.nodeTaskMap.addTask(chosenNode, (RemoteTask)remoteTask1);
        this.nodeTaskMap.addTask(chosenNode, (RemoteTask)remoteTask2);
        Assert.assertEquals((Object)this.nodeTaskMap.getPartitionedSplitsOnNode(chosenNode), (Object)TestNodeScheduler.standardWeightSplitsInfo(3));
        remoteTask1.abort();
        Assert.assertEquals((Object)this.nodeTaskMap.getPartitionedSplitsOnNode(chosenNode), (Object)TestNodeScheduler.standardWeightSplitsInfo(1));
        remoteTask2.abort();
        Assert.assertEquals((Object)this.nodeTaskMap.getPartitionedSplitsOnNode(chosenNode), (Object)PartitionedSplitsInfo.forZeroSplits());
    }

    @Test
    public void testMoreSplitsAssignedWhenSplitsWeightsAreSmall() {
        int standardSplitsPerNode = this.nodeSchedulerConfig.getMaxSplitsPerNode();
        int standardPendingSplitsPerTask = this.nodeSchedulerConfig.getMaxPendingSplitsPerTask();
        int fullyLoadedStandardSplitCount = standardSplitsPerNode + standardPendingSplitsPerTask;
        long weightLimitPerNode = SplitWeight.rawValueForStandardSplitCount((int)standardSplitsPerNode);
        long weightLimitPendingPerTask = SplitWeight.rawValueForStandardSplitCount((int)standardPendingSplitsPerTask);
        long fullyLoadedStandardSplitWeight = weightLimitPerNode + weightLimitPendingPerTask;
        this.nodeSelector = this.nodeScheduler.createNodeSelector(this.session, CONNECTOR_ID, 1);
        InternalNode workerNode = (InternalNode)this.nodeSelector.selectRandomNodes(1).get(0);
        MockRemoteTaskFactory remoteTaskFactory = new MockRemoteTaskFactory(this.remoteTaskExecutor, this.remoteTaskScheduledExecutor);
        TaskId taskId = new TaskId("test", 1, 0, 1, 0);
        MockRemoteTaskFactory.MockRemoteTask task = remoteTaskFactory.createTableScanTask(taskId, workerNode, (List<Split>)ImmutableList.of(), this.nodeTaskMap.createTaskStatsTracker(workerNode, taskId));
        TestingTransactionHandle transactionHandle = TestingTransactionHandle.create();
        ImmutableSet.Builder splitsBuilder = ImmutableSet.builderWithExpectedSize((int)(fullyLoadedStandardSplitCount * 2));
        SplitWeight halfWeight = SplitWeight.fromProportion((double)0.5);
        for (int i = 0; i < fullyLoadedStandardSplitCount * 2; ++i) {
            splitsBuilder.add((Object)new Split(CONNECTOR_ID, (ConnectorTransactionHandle)transactionHandle, (ConnectorSplit)new TestSplitRemote(halfWeight)));
        }
        ImmutableSet splits = splitsBuilder.build();
        Assert.assertEquals((long)SplitWeight.rawValueSum((Collection)splits, Split::getSplitWeight), (long)fullyLoadedStandardSplitWeight);
        SplitPlacementResult result = this.nodeSelector.computeAssignments((Set)splits, (List)ImmutableList.of((Object)task));
        Assert.assertEquals((int)result.getAssignments().get((Object)workerNode).size(), (int)(standardSplitsPerNode * 2));
        Assert.assertEquals((long)SplitWeight.rawValueSum((Collection)result.getAssignments().get((Object)workerNode), Split::getSplitWeight), (long)weightLimitPerNode);
        task.addSplits((Multimap<PlanNodeId, Split>)ImmutableMultimap.builder().putAll((Object)new PlanNodeId("sourceId"), (Iterable)result.getAssignments().get((Object)workerNode)).build());
        task.startSplits(result.getAssignments().get((Object)workerNode).size());
        Sets.SetView remainingSplits = Sets.difference((Set)splits, (Set)ImmutableSet.copyOf((Collection)result.getAssignments().get((Object)workerNode)));
        SplitPlacementResult secondResults = this.nodeSelector.computeAssignments((Set)remainingSplits, (List)ImmutableList.of((Object)task));
        Assert.assertEquals((int)secondResults.getAssignments().get((Object)workerNode).size(), (int)(standardPendingSplitsPerTask * 2));
        Assert.assertEquals((long)SplitWeight.rawValueSum((Collection)secondResults.getAssignments().get((Object)workerNode), Split::getSplitWeight), (long)weightLimitPendingPerTask);
        task.addSplits((Multimap<PlanNodeId, Split>)ImmutableMultimap.builder().putAll((Object)new PlanNodeId("sourceId"), (Iterable)secondResults.getAssignments().get((Object)workerNode)).build());
        Assert.assertEquals((Object)this.nodeTaskMap.getPartitionedSplitsOnNode(workerNode), (Object)PartitionedSplitsInfo.forSplitCountAndWeightSum((int)(fullyLoadedStandardSplitCount * 2), (long)fullyLoadedStandardSplitWeight));
        SplitPlacementResult resultWhenFull = this.nodeSelector.computeAssignments((Set)ImmutableSet.of((Object)new Split(CONNECTOR_ID, (ConnectorTransactionHandle)transactionHandle, (ConnectorSplit)new TestSplitRemote())), (List)ImmutableList.of((Object)task));
        Assert.assertTrue((boolean)resultWhenFull.getAssignments().isEmpty());
    }

    @Test
    public void testCpuUsage() {
        MockRemoteTaskFactory remoteTaskFactory = new MockRemoteTaskFactory(this.remoteTaskExecutor, this.remoteTaskScheduledExecutor);
        InternalNode chosenNode = (InternalNode)Iterables.get((Iterable)this.nodeManager.getActiveConnectorNodes(CONNECTOR_ID), (int)0);
        TaskId taskId1 = new TaskId("test", 1, 0, 1, 0);
        ImmutableList splits = ImmutableList.of((Object)new Split(CONNECTOR_ID, (ConnectorTransactionHandle)TestingTransactionHandle.create(), (ConnectorSplit)new TestSplitRemote()), (Object)new Split(CONNECTOR_ID, (ConnectorTransactionHandle)TestingTransactionHandle.create(), (ConnectorSplit)new TestSplitRemote()));
        MockRemoteTaskFactory.MockRemoteTask remoteTask1 = remoteTaskFactory.createTableScanTask(taskId1, chosenNode, (List<Split>)splits, this.nodeTaskMap.createTaskStatsTracker(chosenNode, taskId1));
        TaskId taskId2 = new TaskId("test", 1, 0, 2, 0);
        MockRemoteTaskFactory.MockRemoteTask remoteTask2 = remoteTaskFactory.createTableScanTask(taskId2, chosenNode, (List<Split>)ImmutableList.of((Object)new Split(CONNECTOR_ID, (ConnectorTransactionHandle)TestingTransactionHandle.create(), (ConnectorSplit)new TestSplitRemote())), this.nodeTaskMap.createTaskStatsTracker(chosenNode, taskId2));
        this.nodeTaskMap.addTask(chosenNode, (RemoteTask)remoteTask1);
        this.nodeTaskMap.addTask(chosenNode, (RemoteTask)remoteTask2);
        remoteTask2.addSplits((Multimap)ImmutableMultimap.builder().putAll((Object)new PlanNodeId("sourceId"), (Iterable)splits).build());
        Assert.assertEquals((double)this.nodeTaskMap.getNodeCpuUtilizationPercentage(chosenNode), (double)100.0);
        remoteTask1.addSplits((Multimap)ImmutableMultimap.builder().putAll((Object)new PlanNodeId("sourceId"), (Iterable)splits).build());
        Assert.assertEquals((double)this.nodeTaskMap.getNodeCpuUtilizationPercentage(chosenNode), (double)200.0);
        remoteTask1.abort();
        Assert.assertEquals((double)this.nodeTaskMap.getNodeCpuUtilizationPercentage(chosenNode), (double)100.0);
        remoteTask2.abort();
        Assert.assertEquals((double)this.nodeTaskMap.getNodeCpuUtilizationPercentage(chosenNode), (double)0.0);
    }

    @Test
    public void testMemoryUsage() {
        MockRemoteTaskFactory remoteTaskFactory = new MockRemoteTaskFactory(this.remoteTaskExecutor, this.remoteTaskScheduledExecutor);
        InternalNode chosenNode = (InternalNode)Iterables.get((Iterable)this.nodeManager.getActiveConnectorNodes(CONNECTOR_ID), (int)0);
        TaskId taskId1 = new TaskId("test", 1, 0, 1, 0);
        ImmutableList splits = ImmutableList.of((Object)new Split(CONNECTOR_ID, (ConnectorTransactionHandle)TestingTransactionHandle.create(), (ConnectorSplit)new TestSplitRemote()), (Object)new Split(CONNECTOR_ID, (ConnectorTransactionHandle)TestingTransactionHandle.create(), (ConnectorSplit)new TestSplitRemote()));
        MockRemoteTaskFactory.MockRemoteTask remoteTask1 = remoteTaskFactory.createTableScanTask(taskId1, chosenNode, (List<Split>)splits, this.nodeTaskMap.createTaskStatsTracker(chosenNode, taskId1));
        TaskId taskId2 = new TaskId("test", 1, 0, 2, 0);
        MockRemoteTaskFactory.MockRemoteTask remoteTask2 = remoteTaskFactory.createTableScanTask(taskId2, chosenNode, (List<Split>)ImmutableList.of((Object)new Split(CONNECTOR_ID, (ConnectorTransactionHandle)TestingTransactionHandle.create(), (ConnectorSplit)new TestSplitRemote())), this.nodeTaskMap.createTaskStatsTracker(chosenNode, taskId2));
        this.nodeTaskMap.addTask(chosenNode, (RemoteTask)remoteTask1);
        this.nodeTaskMap.addTask(chosenNode, (RemoteTask)remoteTask2);
        remoteTask2.addSplits((Multimap)ImmutableMultimap.builder().putAll((Object)new PlanNodeId("sourceId"), (Iterable)splits).build());
        Assert.assertEquals((long)this.nodeTaskMap.getNodeTotalMemoryUsageInBytes(chosenNode), (long)200L);
        remoteTask1.addSplits((Multimap)ImmutableMultimap.builder().putAll((Object)new PlanNodeId("sourceId"), (Iterable)splits).build());
        Assert.assertEquals((long)this.nodeTaskMap.getNodeTotalMemoryUsageInBytes(chosenNode), (long)200L);
        remoteTask1.abort();
        Assert.assertEquals((long)this.nodeTaskMap.getNodeTotalMemoryUsageInBytes(chosenNode), (long)100L);
        remoteTask2.abort();
        Assert.assertEquals((long)this.nodeTaskMap.getNodeTotalMemoryUsageInBytes(chosenNode), (long)0L);
    }

    @Test
    public void testMaxTasksPerStageWittLimit() {
        NodeTaskMap nodeTaskMap = new NodeTaskMap(this.finalizerService);
        TestingTransactionHandle transactionHandle = TestingTransactionHandle.create();
        NodeSchedulerConfig nodeSchedulerConfig = new NodeSchedulerConfig().setMaxSplitsPerNode(20).setIncludeCoordinator(false).setMaxPendingSplitsPerTask(10);
        NodeScheduler nodeScheduler = new NodeScheduler((NetworkTopology)new LegacyNetworkTopology(), (InternalNodeManager)this.nodeManager, new NodeSelectionStats(), nodeSchedulerConfig, nodeTaskMap, (NodeTtlFetcherManager)new ThrowingNodeTtlFetcherManager(), (QueryManager)new NoOpQueryManager(), new SimpleTtlNodeSelectorConfig());
        NodeSelector nodeSelector = nodeScheduler.createNodeSelector(this.session, CONNECTOR_ID, 2);
        HashSet<Split> splits = new HashSet<Split>();
        splits.add(new Split(CONNECTOR_ID, (ConnectorTransactionHandle)transactionHandle, (ConnectorSplit)new TestSplitRemote()));
        SplitPlacementResult splitPlacementResult = nodeSelector.computeAssignments(splits, (List)ImmutableList.of());
        Set internalNodes = splitPlacementResult.getAssignments().keySet();
        Assert.assertEquals((int)internalNodes.size(), (int)1);
        splits.add(new Split(CONNECTOR_ID, (ConnectorTransactionHandle)transactionHandle, (ConnectorSplit)new TestSplitRemote()));
        splitPlacementResult = nodeSelector.computeAssignments(splits, this.getRemoteTableScanTask(splitPlacementResult));
        Set internalNodesSecondCall = splitPlacementResult.getAssignments().keySet();
        Assert.assertEquals((int)internalNodesSecondCall.size(), (int)2);
        Assert.assertTrue((boolean)internalNodesSecondCall.containsAll(internalNodes));
        splits.add(new Split(CONNECTOR_ID, (ConnectorTransactionHandle)transactionHandle, (ConnectorSplit)new TestSplitRemote()));
        splitPlacementResult = nodeSelector.computeAssignments(splits, this.getRemoteTableScanTask(splitPlacementResult));
        Assert.assertEquals((int)splitPlacementResult.getAssignments().keySet().size(), (int)2);
        Assert.assertEquals((Set)splitPlacementResult.getAssignments().keySet(), (Set)internalNodesSecondCall);
    }

    @Test
    public void testMaxTasksPerStageAddingNewNodes() {
        InMemoryNodeManager nodeManager = new InMemoryNodeManager();
        NodeTaskMap nodeTaskMap = new NodeTaskMap(this.finalizerService);
        TestingTransactionHandle transactionHandle = TestingTransactionHandle.create();
        NodeSchedulerConfig nodeSchedulerConfig = new NodeSchedulerConfig().setMaxSplitsPerNode(20).setIncludeCoordinator(false).setMaxPendingSplitsPerTask(10);
        LegacyNetworkTopology networkTopology = new LegacyNetworkTopology();
        NodeScheduler nodeScheduler = new NodeScheduler(new NetworkLocationCache((NetworkTopology)networkTopology), (NetworkTopology)networkTopology, (InternalNodeManager)nodeManager, new NodeSelectionStats(), nodeSchedulerConfig, nodeTaskMap, Duration.valueOf((String)"0s"), (NodeTtlFetcherManager)new ThrowingNodeTtlFetcherManager(), (QueryManager)new NoOpQueryManager(), new SimpleTtlNodeSelectorConfig());
        NodeSelector nodeSelector = nodeScheduler.createNodeSelector(this.session, CONNECTOR_ID, 2);
        HashSet<Split> splits = new HashSet<Split>();
        splits.add(new Split(CONNECTOR_ID, (ConnectorTransactionHandle)transactionHandle, (ConnectorSplit)new TestSplitRemote()));
        splits.add(new Split(CONNECTOR_ID, (ConnectorTransactionHandle)transactionHandle, (ConnectorSplit)new TestSplitRemote()));
        splits.add(new Split(CONNECTOR_ID, (ConnectorTransactionHandle)transactionHandle, (ConnectorSplit)new TestSplitRemote()));
        nodeManager.addNode(CONNECTOR_ID, (Iterable)ImmutableList.of((Object)new InternalNode("node1", URI.create("http://127.0.0.1:11"), NodeVersion.UNKNOWN, false)));
        SplitPlacementResult splitPlacementResult = nodeSelector.computeAssignments(splits, (List)ImmutableList.of());
        Set internalNodes = splitPlacementResult.getAssignments().keySet();
        Assert.assertEquals((int)internalNodes.size(), (int)1);
        nodeManager.addNode(CONNECTOR_ID, (Iterable)ImmutableList.of((Object)new InternalNode("node2", URI.create("http://127.0.0.1:12"), NodeVersion.UNKNOWN, false)));
        splitPlacementResult = nodeSelector.computeAssignments(splits, this.getRemoteTableScanTask(splitPlacementResult));
        Set internalNodesSecondCall = splitPlacementResult.getAssignments().keySet();
        Assert.assertEquals((int)internalNodesSecondCall.size(), (int)2);
        Assert.assertTrue((boolean)internalNodesSecondCall.containsAll(internalNodes));
        nodeManager.addNode(CONNECTOR_ID, (Iterable)ImmutableList.of((Object)new InternalNode("node2", URI.create("http://127.0.0.1:13"), NodeVersion.UNKNOWN, false)));
        internalNodes = splitPlacementResult.getAssignments().keySet();
        Assert.assertEquals((int)internalNodes.size(), (int)2);
        Assert.assertTrue((boolean)internalNodesSecondCall.containsAll(internalNodes));
    }

    private List<RemoteTask> getRemoteTableScanTask(SplitPlacementResult splitPlacementResult) {
        HashMap<InternalNode, MockRemoteTaskFactory.MockRemoteTask> taskMap = new HashMap<InternalNode, MockRemoteTaskFactory.MockRemoteTask>();
        Multimap assignments = splitPlacementResult.getAssignments();
        MockRemoteTaskFactory remoteTaskFactory = new MockRemoteTaskFactory(this.remoteTaskExecutor, this.remoteTaskScheduledExecutor);
        int task = 0;
        for (InternalNode node : assignments.keySet()) {
            TaskId taskId = new TaskId("test", 1, 1, task, 0);
            ++task;
            MockRemoteTaskFactory.MockRemoteTask remoteTask = remoteTaskFactory.createTableScanTask(taskId, node, (List<Split>)ImmutableList.copyOf((Collection)assignments.get((Object)node)), this.nodeTaskMap.createTaskStatsTracker(node, taskId));
            remoteTask.startSplits(25);
            this.nodeTaskMap.addTask(node, (RemoteTask)remoteTask);
            taskMap.put(node, remoteTask);
        }
        return ImmutableList.copyOf(taskMap.values());
    }

    private static Session sessionWithMaxUnacknowledgedSplitsPerTask(int maxUnacknowledgedSplitsPerTask) {
        return TestingSession.testSessionBuilder().setSystemProperty("max_unacknowledged_splits_per_task", Integer.toString(maxUnacknowledgedSplitsPerTask)).build();
    }

    private static Session sessionWithTtlAwareSchedulingStrategyAndEstimatedExecutionTime(Duration estimatedExecutionTime) {
        return TestingSession.testSessionBuilder().setSystemProperty("resource_aware_scheduling_strategy", NodeSchedulerConfig.ResourceAwareSchedulingStrategy.TTL.name()).setResourceEstimates(new Session.ResourceEstimateBuilder().setExecutionTime(estimatedExecutionTime).build()).build();
    }

    private static PartitionedSplitsInfo standardWeightSplitsInfo(int splitCount) {
        return PartitionedSplitsInfo.forSplitCountAndWeightSum((int)splitCount, (long)SplitWeight.rawValueForStandardSplitCount((int)splitCount));
    }

    private static class TestSplitLocal
    implements ConnectorSplit {
        private final SplitWeight splitWeight;

        public TestSplitLocal() {
            this(SplitWeight.standard());
        }

        public TestSplitLocal(SplitWeight splitWeight) {
            this.splitWeight = Objects.requireNonNull(splitWeight, "splitWeight is null");
        }

        public NodeSelectionStrategy getNodeSelectionStrategy() {
            return NodeSelectionStrategy.HARD_AFFINITY;
        }

        public List<HostAddress> getPreferredNodes(NodeProvider nodeProvider) {
            return ImmutableList.of((Object)HostAddress.fromString((String)"127.0.0.1:11"));
        }

        public Object getInfo() {
            return this;
        }

        public SplitWeight getSplitWeight() {
            return this.splitWeight;
        }
    }

    private static class TestNetworkTopology
    implements NetworkTopology {
        private TestNetworkTopology() {
        }

        public NetworkLocation locate(HostAddress address) {
            ArrayList parts = new ArrayList(ImmutableList.copyOf((Iterable)Splitter.on((String)".").split((CharSequence)address.getHostText())));
            Collections.reverse(parts);
            return NetworkLocation.create(parts);
        }

        public List<String> getLocationSegmentNames() {
            return ImmutableList.of((Object)"rack", (Object)"machine");
        }
    }

    private static class TestSplitRemote
    implements ConnectorSplit {
        private final List<HostAddress> hosts;
        private final SplitWeight splitWeight;

        public TestSplitRemote() {
            this(SplitWeight.standard());
        }

        public TestSplitRemote(SplitWeight splitWeight) {
            this(HostAddress.fromString((String)("127.0.0.1:" + ThreadLocalRandom.current().nextInt(5000))), splitWeight);
        }

        public TestSplitRemote(HostAddress host) {
            this(host, SplitWeight.standard());
        }

        public TestSplitRemote(HostAddress host, SplitWeight splitWeight) {
            this.hosts = ImmutableList.of((Object)Objects.requireNonNull(host, "host is null"));
            this.splitWeight = Objects.requireNonNull(splitWeight, "splitWeight is null");
        }

        public NodeSelectionStrategy getNodeSelectionStrategy() {
            return NodeSelectionStrategy.NO_PREFERENCE;
        }

        public List<HostAddress> getPreferredNodes(NodeProvider nodeProvider) {
            return this.hosts;
        }

        public Object getInfo() {
            return this;
        }

        public SplitWeight getSplitWeight() {
            return this.splitWeight;
        }
    }

    private class TestingQueryManager
    extends NoOpQueryManager {
        private Duration executionTime;

        private TestingQueryManager() {
        }

        private BasicQueryStats getBasicQueryStats(Duration executionTime) {
            Duration defaultDuration = Duration.valueOf((String)"5m");
            return new BasicQueryStats(0L, 0L, defaultDuration, defaultDuration, defaultDuration, executionTime, defaultDuration, 0, 0, 0, 0, 0, 0, DataSize.valueOf((String)"1MB"), 0L, 0.0, 0.0, null, null, null, null, null, null, null, null, false, (Set)ImmutableSet.of(), DataSize.valueOf((String)"1MB"), OptionalDouble.empty());
        }

        private BasicQueryInfo getBasicQueryInfo(Duration executionTime) {
            return new BasicQueryInfo(TestNodeScheduler.this.session.getQueryId(), TestNodeScheduler.this.session.toSessionRepresentation(), Optional.empty(), QueryState.RUNNING, null, true, URI.create("http://127.0.0.1:55"), "", this.getBasicQueryStats(executionTime), null, null, null, Optional.empty(), (List)ImmutableList.of(), Optional.empty());
        }

        public BasicQueryInfo getQueryInfo(QueryId queryId) {
            return this.getBasicQueryInfo(this.executionTime);
        }

        public void setExecutionTime(Duration executionTime) {
            this.executionTime = executionTime;
        }
    }

    private static class TestAffinitySplitRemote
    extends TestSplitRemote {
        private int scheduleIdentifierId;

        public TestAffinitySplitRemote(int scheduleIdentifierId) {
            this.scheduleIdentifierId = scheduleIdentifierId;
        }

        public Object getSplitIdentifier() {
            return this.scheduleIdentifierId;
        }

        @Override
        public NodeSelectionStrategy getNodeSelectionStrategy() {
            return NodeSelectionStrategy.SOFT_AFFINITY;
        }

        @Override
        public List<HostAddress> getPreferredNodes(NodeProvider nodeProvider) {
            return nodeProvider.get(String.format("split%d", this.scheduleIdentifierId));
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            TestAffinitySplitRemote o = (TestAffinitySplitRemote)obj;
            return this.scheduleIdentifierId == o.scheduleIdentifierId;
        }

        public int hashCode() {
            return Objects.hash(this.scheduleIdentifierId);
        }
    }

    private static class TestHardAffinitySplitRemote
    extends TestSplitRemote {
        @Override
        public NodeSelectionStrategy getNodeSelectionStrategy() {
            return NodeSelectionStrategy.HARD_AFFINITY;
        }

        @Override
        public List<HostAddress> getPreferredNodes(NodeProvider nodeProvider) {
            return nodeProvider.get(String.valueOf(new Random().nextInt()));
        }
    }
}

