/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.Session;
import com.facebook.presto.common.WarningHandlingLevel;
import com.facebook.presto.execution.warnings.DefaultWarningCollector;
import com.facebook.presto.execution.warnings.WarningCollectorConfig;
import com.facebook.presto.matching.Captures;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.spi.PrestoWarning;
import com.facebook.presto.spi.WarningCode;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.connector.ConnectorFactory;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.ProjectNode;
import com.facebook.presto.sql.Optimizer;
import com.facebook.presto.sql.analyzer.SemanticException;
import com.facebook.presto.sql.planner.Plan;
import com.facebook.presto.sql.planner.RuleStatsRecorder;
import com.facebook.presto.sql.planner.iterative.IterativeOptimizer;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.plan.Patterns;
import com.facebook.presto.testing.LocalQueryRunner;
import com.facebook.presto.testing.TestingSession;
import com.facebook.presto.tpch.TpchConnectorFactory;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.IntStream;
import org.intellij.lang.annotations.Language;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestPlannerWarnings {
    private LocalQueryRunner queryRunner;

    @BeforeClass
    public void setUp() {
        this.queryRunner = new LocalQueryRunner(TestingSession.testSessionBuilder().setCatalog("local").setSchema("tiny").build());
        this.queryRunner.createCatalog((String)this.queryRunner.getDefaultSession().getCatalog().get(), (ConnectorFactory)new TpchConnectorFactory(1), (Map)ImmutableMap.of());
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        this.queryRunner.close();
    }

    @Test
    public void testWarning() {
        List<PrestoWarning> warnings = TestPlannerWarnings.createTestWarnings(3);
        List warningCodes = (List)warnings.stream().map(PrestoWarning::getWarningCode).collect(ImmutableList.toImmutableList());
        TestPlannerWarnings.assertPlannerWarnings(this.queryRunner, "SELECT * FROM NATION", (Map<String, String>)ImmutableMap.of(), warningCodes, Optional.of(ImmutableList.of((Object)new TestWarningsRule(warnings), (Object)new PassRemoteProjectSanityChecker())));
    }

    public static void assertPlannerWarnings(LocalQueryRunner queryRunner, @Language(value="SQL") String sql, Map<String, String> sessionProperties, List<WarningCode> expectedWarnings, Optional<List<Rule<?>>> rules) {
        Session.SessionBuilder sessionBuilder = TestingSession.testSessionBuilder().setCatalog((String)queryRunner.getDefaultSession().getCatalog().get()).setSchema((String)queryRunner.getDefaultSession().getSchema().get());
        sessionProperties.forEach((arg_0, arg_1) -> ((Session.SessionBuilder)sessionBuilder).setSystemProperty(arg_0, arg_1));
        DefaultWarningCollector warningCollector = new DefaultWarningCollector(new WarningCollectorConfig(), WarningHandlingLevel.NORMAL);
        try {
            queryRunner.inTransaction(sessionBuilder.build(), arg_0 -> TestPlannerWarnings.lambda$assertPlannerWarnings$0(rules, queryRunner, sql, (WarningCollector)warningCollector, arg_0));
        }
        catch (SemanticException semanticException) {
            // empty catch block
        }
        Set warnings = (Set)warningCollector.getWarnings().stream().map(PrestoWarning::getWarningCode).collect(ImmutableSet.toImmutableSet());
        for (WarningCode expectedWarning : expectedWarnings) {
            if (warnings.contains(expectedWarning)) continue;
            Assert.fail((String)("Expected warning: " + expectedWarning));
        }
    }

    private static Plan createPlan(LocalQueryRunner queryRunner, Session session, String sql, WarningCollector warningCollector, List<Rule<?>> rules) {
        IterativeOptimizer optimizer = new IterativeOptimizer(queryRunner.getMetadata(), new RuleStatsRecorder(), queryRunner.getStatsCalculator(), queryRunner.getCostCalculator(), (Set)ImmutableSet.copyOf(rules));
        return queryRunner.createPlan(session, sql, (List)ImmutableList.of((Object)optimizer), Optimizer.PlanStage.OPTIMIZED_AND_VALIDATED, warningCollector);
    }

    public static List<PrestoWarning> createTestWarnings(int numberOfWarnings) {
        Preconditions.checkArgument((numberOfWarnings > 0 ? 1 : 0) != 0, (Object)"numberOfWarnings must be > 0");
        ImmutableList.Builder builder = ImmutableList.builder();
        IntStream.range(1, numberOfWarnings).mapToObj(code -> new PrestoWarning(new WarningCode(code, "testWarning"), "Test warning " + code)).forEach(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        return builder.build();
    }

    private static /* synthetic */ Object lambda$assertPlannerWarnings$0(Optional rules, LocalQueryRunner queryRunner, String sql, WarningCollector warningCollector, Session transactionSession) {
        if (rules.isPresent()) {
            TestPlannerWarnings.createPlan(queryRunner, transactionSession, sql, warningCollector, (List)rules.get());
        } else {
            queryRunner.createPlan(transactionSession, sql, Optimizer.PlanStage.CREATED, false, warningCollector);
        }
        return null;
    }

    public static class TestWarningsRule
    implements Rule<ProjectNode> {
        private final List<PrestoWarning> warnings;

        public TestWarningsRule(List<PrestoWarning> warnings) {
            this.warnings = ImmutableList.copyOf((Collection)Objects.requireNonNull(warnings, "warnings is null"));
        }

        public Pattern<ProjectNode> getPattern() {
            return Patterns.project();
        }

        public Rule.Result apply(ProjectNode node, Captures captures, Rule.Context context) {
            this.warnings.stream().forEach(arg_0 -> ((WarningCollector)context.getWarningCollector()).add(arg_0));
            return Rule.Result.empty();
        }
    }

    public static class PassRemoteProjectSanityChecker
    implements Rule<ProjectNode> {
        public Pattern<ProjectNode> getPattern() {
            return Patterns.project();
        }

        public Rule.Result apply(ProjectNode node, Captures captures, Rule.Context context) {
            if (node.getLocality().equals((Object)ProjectNode.Locality.UNKNOWN)) {
                return Rule.Result.ofPlanNode((PlanNode)new ProjectNode(Optional.empty(), context.getIdAllocator().getNextId(), node.getSource(), node.getAssignments(), ProjectNode.Locality.LOCAL));
            }
            return Rule.Result.empty();
        }
    }
}

