/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.execution.QueryLimit;
import com.facebook.presto.testing.assertions.Assert;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.util.concurrent.TimeUnit;
import org.testng.annotations.Test;

public class TestQueryLimit {
    private static final QueryLimit<Duration> QUERY_LIMIT_DURATION = QueryLimit.createDurationLimit((Duration)new Duration(1.0, TimeUnit.HOURS), (QueryLimit.Source)QueryLimit.Source.SYSTEM);
    private static final QueryLimit<Long> QUERY_LIMIT_DATA_SIZE = QueryLimit.createDataSizeLimit((long)new DataSize(1.0, DataSize.Unit.MEGABYTE).toBytes(), (QueryLimit.Source)QueryLimit.Source.RESOURCE_GROUP);

    @Test
    public void testGetLimit() {
        Assert.assertEquals((Object)QUERY_LIMIT_DURATION.getLimit(), (Object)new Duration(1.0, TimeUnit.HOURS));
        Assert.assertEquals((Long)((Long)QUERY_LIMIT_DATA_SIZE.getLimit()), (long)new DataSize(1.0, DataSize.Unit.MEGABYTE).toBytes());
    }

    @Test
    public void testGetSource() {
        Assert.assertEquals((Object)QUERY_LIMIT_DATA_SIZE.getLimitSource(), (Object)QueryLimit.Source.RESOURCE_GROUP);
        Assert.assertEquals((Object)QUERY_LIMIT_DURATION.getLimitSource(), (Object)QueryLimit.Source.SYSTEM);
        Assert.assertEquals((Object)QueryLimit.createDurationLimit((Duration)new Duration(1.0, TimeUnit.HOURS), (QueryLimit.Source)QueryLimit.Source.QUERY).getLimitSource(), (Object)QueryLimit.Source.QUERY);
    }

    @Test
    public void testGetMinimum() {
        QueryLimit longLimit = QueryLimit.createDurationLimit((Duration)new Duration(2.0, TimeUnit.HOURS), (QueryLimit.Source)QueryLimit.Source.SYSTEM);
        QueryLimit shortLimit = QueryLimit.createDurationLimit((Duration)new Duration(1.0, TimeUnit.MINUTES), (QueryLimit.Source)QueryLimit.Source.RESOURCE_GROUP);
        Assert.assertEquals((Object)QueryLimit.getMinimum(QUERY_LIMIT_DURATION, (QueryLimit[])new QueryLimit[]{longLimit, shortLimit}), (Object)shortLimit);
        QueryLimit largeLimit = QueryLimit.createDataSizeLimit((long)new DataSize(2.0, DataSize.Unit.MEGABYTE).toBytes(), (QueryLimit.Source)QueryLimit.Source.QUERY);
        QueryLimit smallLimit = QueryLimit.createDataSizeLimit((long)new DataSize(1.0, DataSize.Unit.BYTE).toBytes(), (QueryLimit.Source)QueryLimit.Source.RESOURCE_GROUP);
        Assert.assertEquals((Object)QueryLimit.getMinimum((QueryLimit)smallLimit, (QueryLimit[])new QueryLimit[]{QUERY_LIMIT_DATA_SIZE, largeLimit}), (Object)smallLimit);
        Assert.assertEquals((Object)QueryLimit.getMinimum(null, (QueryLimit[])new QueryLimit[]{QUERY_LIMIT_DATA_SIZE, largeLimit}), QUERY_LIMIT_DATA_SIZE);
        Assert.assertEquals((Object)QueryLimit.getMinimum(null, (QueryLimit[])new QueryLimit[]{largeLimit, null, null, QUERY_LIMIT_DATA_SIZE}), QUERY_LIMIT_DATA_SIZE);
        Assert.assertEquals((Object)QueryLimit.getMinimum((QueryLimit)smallLimit, (QueryLimit[])new QueryLimit[]{null, null, null}), (Object)smallLimit);
        org.testng.Assert.assertThrows(IllegalArgumentException.class, () -> QueryLimit.getMinimum(null, (QueryLimit[])new QueryLimit[0]));
        org.testng.Assert.assertThrows(IllegalArgumentException.class, () -> QueryLimit.getMinimum(null, (QueryLimit[])new QueryLimit[]{null, null}));
    }
}

