/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.drift.client.DriftClient;
import com.facebook.presto.execution.MockQueryExecution;
import com.facebook.presto.execution.QueryManagerConfig;
import com.facebook.presto.execution.QueryTracker;
import com.facebook.presto.resourcemanager.ResourceManagerClient;
import com.facebook.presto.resourcemanager.ResourceManagerConfig;
import com.facebook.presto.resourcemanager.TestingClusterQueryTrackerService;
import com.facebook.presto.resourcemanager.TestingResourceManagerClient;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestQueryTrackerHighTaskCountKill {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultipleQueriesKilledDueToTaskCount() {
        QueryManagerConfig config = new QueryManagerConfig().setMaxQueryRunningTaskCount(100).setMaxTotalRunningTaskCountToKillQuery(200);
        ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
        try {
            QueryTracker queryTracker = new QueryTracker(config, scheduledExecutorService, Optional.empty());
            MockQueryExecution smallQuery1 = MockQueryExecution.withRunningTaskCount(50);
            MockQueryExecution largeQueryButNotKilled = MockQueryExecution.withRunningTaskCount(101);
            MockQueryExecution largeQueryToBeKilled1 = MockQueryExecution.withRunningTaskCount(200);
            MockQueryExecution largeQueryToBeKilled2 = MockQueryExecution.withRunningTaskCount(250);
            queryTracker.addQuery((QueryTracker.TrackedQuery)smallQuery1);
            queryTracker.addQuery((QueryTracker.TrackedQuery)largeQueryButNotKilled);
            queryTracker.addQuery((QueryTracker.TrackedQuery)largeQueryToBeKilled1);
            queryTracker.addQuery((QueryTracker.TrackedQuery)largeQueryToBeKilled2);
            queryTracker.enforceTaskLimits();
            Assert.assertFalse((boolean)smallQuery1.getFailureReason().isPresent(), (String)"small query should not be killed");
            Assert.assertFalse((boolean)largeQueryButNotKilled.getFailureReason().isPresent(), (String)"query exceeds per query limit, but not killed since not heaviest and cluster can get into better state");
            Assert.assertTrue((boolean)largeQueryToBeKilled1.getFailureReason().isPresent(), (String)"Query should be killed");
            Throwable failureReason1 = largeQueryToBeKilled1.getFailureReason().get();
            Assert.assertTrue((boolean)(failureReason1 instanceof PrestoException));
            Assert.assertEquals((Object)((PrestoException)failureReason1).getErrorCode(), (Object)StandardErrorCode.CLUSTER_HAS_TOO_MANY_RUNNING_TASKS.toErrorCode());
            Assert.assertTrue((boolean)largeQueryToBeKilled2.getFailureReason().isPresent(), (String)"Query should be killed");
            Throwable failureReason2 = largeQueryToBeKilled2.getFailureReason().get();
            Assert.assertTrue((boolean)(failureReason2 instanceof PrestoException));
            Assert.assertEquals((Object)((PrestoException)failureReason2).getErrorCode(), (Object)StandardErrorCode.CLUSTER_HAS_TOO_MANY_RUNNING_TASKS.toErrorCode());
        }
        finally {
            scheduledExecutorService.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLargeQueryKilledDueToTaskCount_withClusterQueryTracker() {
        QueryManagerConfig config = new QueryManagerConfig().setMaxQueryRunningTaskCount(100).setMaxTotalRunningTaskCountToKillQuery(200);
        ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
        TestingResourceManagerClient resourceManagerClient = new TestingResourceManagerClient();
        TestingClusterQueryTrackerService clusterQueryTrackerService = new TestingClusterQueryTrackerService((DriftClient<ResourceManagerClient>)((DriftClient)(addressSelectionContext, headers) -> resourceManagerClient), Executors.newSingleThreadScheduledExecutor(), new ResourceManagerConfig(), 201);
        try {
            QueryTracker queryTracker = new QueryTracker(config, scheduledExecutorService, Optional.of(clusterQueryTrackerService));
            MockQueryExecution smallQuery = MockQueryExecution.withRunningTaskCount(50);
            MockQueryExecution largeQueryToBeKilled = MockQueryExecution.withRunningTaskCount(101);
            queryTracker.addQuery((QueryTracker.TrackedQuery)smallQuery);
            queryTracker.addQuery((QueryTracker.TrackedQuery)largeQueryToBeKilled);
            queryTracker.enforceTaskLimits();
            Assert.assertFalse((boolean)smallQuery.getFailureReason().isPresent(), (String)"small query should not be killed");
            Throwable failureReason = largeQueryToBeKilled.getFailureReason().get();
            Assert.assertTrue((boolean)(failureReason instanceof PrestoException));
            Assert.assertEquals((Object)((PrestoException)failureReason).getErrorCode(), (Object)StandardErrorCode.CLUSTER_HAS_TOO_MANY_RUNNING_TASKS.toErrorCode());
        }
        finally {
            scheduledExecutorService.shutdownNow();
        }
    }
}

