/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.airlift.concurrent.Threads;
import com.facebook.presto.Session;
import com.facebook.presto.execution.QueryInfo;
import com.facebook.presto.execution.QueryStateMachine;
import com.facebook.presto.execution.SetRoleTask;
import com.facebook.presto.execution.TaskTestUtils;
import com.facebook.presto.metadata.CatalogManager;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.spi.security.AccessControl;
import com.facebook.presto.spi.security.AllowAllAccessControl;
import com.facebook.presto.spi.security.SelectedRole;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.tree.SetRole;
import com.facebook.presto.testing.TestingSession;
import com.facebook.presto.transaction.InMemoryTransactionManager;
import com.facebook.presto.transaction.TransactionManager;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestSetRoleTask {
    private static final String CATALOG_NAME = "foo";
    private TransactionManager transactionManager;
    private AccessControl accessControl;
    private MetadataManager metadata;
    private ExecutorService executor;
    private SqlParser parser;

    @BeforeClass
    public void setUp() throws Exception {
        CatalogManager catalogManager = new CatalogManager();
        this.transactionManager = InMemoryTransactionManager.createTestTransactionManager((CatalogManager)catalogManager);
        this.accessControl = new AllowAllAccessControl();
        this.metadata = MetadataManager.createTestMetadataManager((TransactionManager)this.transactionManager);
        catalogManager.registerCatalog(TestingSession.createBogusTestingCatalog((String)CATALOG_NAME));
        this.executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"test-set-role-task-executor-%s"));
        this.parser = new SqlParser();
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() throws Exception {
        this.executor.shutdownNow();
        this.executor = null;
        this.metadata = null;
        this.accessControl = null;
        this.transactionManager = null;
        this.parser = null;
    }

    @Test
    public void testSetRole() {
        this.assertSetRole("SET ROLE ALL", (Map<String, SelectedRole>)ImmutableMap.of((Object)CATALOG_NAME, (Object)new SelectedRole(SelectedRole.Type.ALL, Optional.empty())));
        this.assertSetRole("SET ROLE NONE", (Map<String, SelectedRole>)ImmutableMap.of((Object)CATALOG_NAME, (Object)new SelectedRole(SelectedRole.Type.NONE, Optional.empty())));
        this.assertSetRole("SET ROLE bar", (Map<String, SelectedRole>)ImmutableMap.of((Object)CATALOG_NAME, (Object)new SelectedRole(SelectedRole.Type.ROLE, Optional.of("bar"))));
    }

    private void assertSetRole(String statement, Map<String, SelectedRole> expected) {
        SetRole setRole = (SetRole)this.parser.createStatement(statement);
        Session session = TestingSession.testSessionBuilder().setCatalog(CATALOG_NAME).build();
        QueryStateMachine stateMachine = TaskTestUtils.createQueryStateMachine(statement, session, false, this.transactionManager, this.executor, this.metadata);
        SetRoleTask setRoleTask = new SetRoleTask();
        setRoleTask.execute(setRole, this.transactionManager, (Metadata)this.metadata, this.accessControl, stateMachine, (List)ImmutableList.of(), "");
        QueryInfo queryInfo = stateMachine.getQueryInfo(Optional.empty());
        Assert.assertEquals((Map)queryInfo.getSetRoles(), expected);
    }
}

