/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.airlift.json.JsonCodec;
import com.facebook.airlift.stats.Distribution;
import com.facebook.presto.common.RuntimeStats;
import com.facebook.presto.execution.StageExecutionStats;
import com.facebook.presto.spi.eventlistener.StageGcStatistics;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.airlift.units.Duration;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestStageExecutionStats {
    private static final StageExecutionStats EXPECTED = new StageExecutionStats(0L, TestStageExecutionStats.getTestDistribution(1), 4, 5, 6, 69, 31, 7, 8, 10, 26, 11, 12.0, 27.0, 13L, 14L, 15L, 42L, new Duration(15.0, TimeUnit.NANOSECONDS), new Duration(16.0, TimeUnit.NANOSECONDS), new Duration(17.0, TimeUnit.NANOSECONDS), new Duration(18.0, TimeUnit.NANOSECONDS), false, (Set)ImmutableSet.of(), 123L, 19L, 20L, 21L, 22L, 23L, 24L, 25L, 26L, new StageGcStatistics(101, 1001, 102, 103, 104, 105, 106, 107), (List)ImmutableList.of(), new RuntimeStats());

    @Test
    public void testJson() {
        JsonCodec codec = JsonCodec.jsonCodec(StageExecutionStats.class);
        String json = codec.toJson((Object)EXPECTED);
        StageExecutionStats actual = (StageExecutionStats)codec.fromJson(json);
        TestStageExecutionStats.assertExpectedStageStats(actual);
    }

    private static void assertExpectedStageStats(StageExecutionStats actual) {
        Assert.assertEquals((long)actual.getSchedulingCompleteInMillis(), (long)0L);
        Assert.assertEquals((double)actual.getGetSplitDistribution().getCount(), (double)1.0);
        Assert.assertEquals((int)actual.getTotalTasks(), (int)4);
        Assert.assertEquals((int)actual.getRunningTasks(), (int)5);
        Assert.assertEquals((int)actual.getCompletedTasks(), (int)6);
        Assert.assertEquals((int)actual.getTotalLifespans(), (int)69);
        Assert.assertEquals((int)actual.getCompletedLifespans(), (int)31);
        Assert.assertEquals((int)actual.getTotalDrivers(), (int)7);
        Assert.assertEquals((int)actual.getQueuedDrivers(), (int)8);
        Assert.assertEquals((int)actual.getRunningDrivers(), (int)10);
        Assert.assertEquals((int)actual.getBlockedDrivers(), (int)26);
        Assert.assertEquals((int)actual.getCompletedDrivers(), (int)11);
        Assert.assertEquals((double)actual.getCumulativeUserMemory(), (double)12.0);
        Assert.assertEquals((long)actual.getUserMemoryReservationInBytes(), (long)13L);
        Assert.assertEquals((long)actual.getTotalMemoryReservationInBytes(), (long)14L);
        Assert.assertEquals((long)actual.getPeakUserMemoryReservationInBytes(), (long)15L);
        Assert.assertEquals((long)actual.getPeakNodeTotalMemoryReservationInBytes(), (long)42L);
        Assert.assertEquals((Object)actual.getTotalScheduledTime(), (Object)new Duration(15.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getTotalCpuTime(), (Object)new Duration(16.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getRetriedCpuTime(), (Object)new Duration(17.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getTotalBlockedTime(), (Object)new Duration(18.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((long)actual.getTotalAllocationInBytes(), (long)123L);
        Assert.assertEquals((long)actual.getRawInputDataSizeInBytes(), (long)19L);
        Assert.assertEquals((long)actual.getRawInputPositions(), (long)20L);
        Assert.assertEquals((long)actual.getProcessedInputDataSizeInBytes(), (long)21L);
        Assert.assertEquals((long)actual.getProcessedInputPositions(), (long)22L);
        Assert.assertEquals((long)actual.getBufferedDataSizeInBytes(), (long)23L);
        Assert.assertEquals((long)actual.getOutputDataSizeInBytes(), (long)24L);
        Assert.assertEquals((long)actual.getOutputPositions(), (long)25L);
        Assert.assertEquals((long)actual.getPhysicalWrittenDataSizeInBytes(), (long)26L);
        Assert.assertEquals((int)actual.getGcInfo().getStageId(), (int)101);
        Assert.assertEquals((int)actual.getGcInfo().getStageExecutionId(), (int)1001);
        Assert.assertEquals((int)actual.getGcInfo().getTasks(), (int)102);
        Assert.assertEquals((int)actual.getGcInfo().getFullGcTasks(), (int)103);
        Assert.assertEquals((int)actual.getGcInfo().getMinFullGcSec(), (int)104);
        Assert.assertEquals((int)actual.getGcInfo().getMaxFullGcSec(), (int)105);
        Assert.assertEquals((int)actual.getGcInfo().getTotalFullGcSec(), (int)106);
        Assert.assertEquals((int)actual.getGcInfo().getAverageFullGcSec(), (int)107);
    }

    private static Distribution.DistributionSnapshot getTestDistribution(int count) {
        Distribution distribution = new Distribution();
        for (int i = 0; i < count; ++i) {
            distribution.add((long)i);
        }
        return distribution.snapshot();
    }
}

