/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.execution.ThreadCountParser;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestThreadCountParser {
    @Test
    public void testParse() {
        Assert.assertEquals((int)ThreadCountParser.parse((String)"1"), (int)1);
        Assert.assertEquals((int)ThreadCountParser.parse((String)"100"), (int)100);
        Assert.assertEquals((int)ThreadCountParser.parse((String)"1", (int)1), (int)1);
        Assert.assertEquals((int)ThreadCountParser.parse((String)"1", (int)2), (int)1);
        Assert.assertEquals((int)ThreadCountParser.parse((String)"100", (int)4), (int)100);
        Assert.assertEquals((int)ThreadCountParser.parse((String)"1C", (int)4), (int)4);
        Assert.assertEquals((int)ThreadCountParser.parse((String)"2C", (int)8), (int)16);
        Assert.assertEquals((int)ThreadCountParser.parse((String)"1.5C", (int)6), (int)9);
        Assert.assertEquals((int)ThreadCountParser.parse((String)"0.1C", (int)1), (int)1);
        Assertions.assertThatThrownBy(() -> ThreadCountParser.parse((String)"0")).hasMessageContaining("Thread count must be positive");
        Assertions.assertThatThrownBy(() -> ThreadCountParser.parse((String)"-1")).hasMessageContaining("Thread count must be positive");
        Assertions.assertThatThrownBy(() -> ThreadCountParser.parse((String)"0C")).hasMessageContaining("Thread multiplier must be positive");
        Assertions.assertThatThrownBy(() -> ThreadCountParser.parse((String)"-1C")).hasMessageContaining("Thread multiplier must be positive");
        Assertions.assertThatThrownBy(() -> ThreadCountParser.parse((String)"abc")).isInstanceOf(NumberFormatException.class);
        Assertions.assertThatThrownBy(() -> ThreadCountParser.parse((String)"abcC")).isInstanceOf(NumberFormatException.class);
    }
}

