/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.drift.codec.ThriftCodec;
import com.facebook.drift.codec.ThriftCodecManager;
import com.facebook.drift.codec.internal.ThriftCodecFactory;
import com.facebook.drift.codec.internal.compiler.CompilerThriftCodecFactory;
import com.facebook.drift.codec.internal.reflection.ReflectionThriftCodecFactory;
import com.facebook.drift.codec.metadata.ThriftCatalog;
import com.facebook.drift.codec.utils.DataSizeToBytesThriftCodec;
import com.facebook.drift.codec.utils.JodaDateTimeToEpochMillisThriftCodec;
import com.facebook.drift.protocol.TBinaryProtocol;
import com.facebook.drift.protocol.TCompactProtocol;
import com.facebook.drift.protocol.TFacebookCompactProtocol;
import com.facebook.drift.protocol.TMemoryBuffer;
import com.facebook.drift.protocol.TProtocol;
import com.facebook.drift.protocol.TProtocolReader;
import com.facebook.drift.protocol.TProtocolWriter;
import com.facebook.drift.protocol.TTransport;
import com.facebook.presto.common.ErrorCode;
import com.facebook.presto.common.ErrorType;
import com.facebook.presto.execution.QueryState;
import com.facebook.presto.operator.BlockedReason;
import com.facebook.presto.server.QueryProgressStats;
import com.facebook.presto.server.QueryStateInfo;
import com.facebook.presto.server.ResourceGroupInfo;
import com.facebook.presto.spi.QueryId;
import com.facebook.presto.spi.resourceGroups.ResourceGroupId;
import com.facebook.presto.spi.resourceGroups.ResourceGroupState;
import com.facebook.presto.spi.resourceGroups.SchedulingPolicy;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.airlift.units.DataSize;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.Set;
import java.util.function.Function;
import org.joda.time.DateTime;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestThriftResourceGroupInfo {
    private static final ThriftCatalog COMMON_CATALOG = new ThriftCatalog();
    private static final DataSizeToBytesThriftCodec DATA_SIZE_CODEC = new DataSizeToBytesThriftCodec(COMMON_CATALOG);
    private static final JodaDateTimeToEpochMillisThriftCodec DATE_TIME_CODEC = new JodaDateTimeToEpochMillisThriftCodec(COMMON_CATALOG);
    private static final ThriftCodecManager COMPILER_READ_CODEC_MANAGER = new ThriftCodecManager((ThriftCodecFactory)new CompilerThriftCodecFactory(false), COMMON_CATALOG, (Set)ImmutableSet.of((Object)DATA_SIZE_CODEC, (Object)DATE_TIME_CODEC));
    private static final ThriftCodecManager COMPILER_WRITE_CODEC_MANAGER = new ThriftCodecManager((ThriftCodecFactory)new CompilerThriftCodecFactory(false), COMMON_CATALOG, (Set)ImmutableSet.of((Object)DATA_SIZE_CODEC, (Object)DATE_TIME_CODEC));
    private static final ThriftCodec<ResourceGroupInfo> COMPILER_READ_CODEC = COMPILER_READ_CODEC_MANAGER.getCodec(ResourceGroupInfo.class);
    private static final ThriftCodec<ResourceGroupInfo> COMPILER_WRITE_CODEC = COMPILER_WRITE_CODEC_MANAGER.getCodec(ResourceGroupInfo.class);
    private static final ThriftCodecManager REFLECTION_READ_CODEC_MANAGER = new ThriftCodecManager((ThriftCodecFactory)new ReflectionThriftCodecFactory(), COMMON_CATALOG, (Set)ImmutableSet.of((Object)DATA_SIZE_CODEC, (Object)DATE_TIME_CODEC));
    private static final ThriftCodecManager REFLECTION_WRITE_CODEC_MANAGER = new ThriftCodecManager((ThriftCodecFactory)new ReflectionThriftCodecFactory(), COMMON_CATALOG, (Set)ImmutableSet.of((Object)DATA_SIZE_CODEC, (Object)DATE_TIME_CODEC));
    private static final ThriftCodec<ResourceGroupInfo> REFLECTION_READ_CODEC = REFLECTION_READ_CODEC_MANAGER.getCodec(ResourceGroupInfo.class);
    private static final ThriftCodec<ResourceGroupInfo> REFLECTION_WRITE_CODEC = REFLECTION_WRITE_CODEC_MANAGER.getCodec(ResourceGroupInfo.class);
    private static final TMemoryBuffer transport = new TMemoryBuffer(102400);
    private static final ResourceGroupId FAKE_RESOURCE_GROUP_ID_PARENT = new ResourceGroupId(Arrays.asList("global", "pipeline", "ns"));
    private static final ResourceGroupId FAKE_SUB_RESOURCE_GROUP_ID_1 = new ResourceGroupId(Arrays.asList("global", "pipeline", "ns", "sub_rg_1"));
    private static final ResourceGroupId FAKE_SUB_RESOURCE_GROUP_ID_2 = new ResourceGroupId(Arrays.asList("global", "pipeline", "ns", "sub_rg_2"));
    private static final ResourceGroupId FAKE_SUB_RESOURCE_GROUP_ID_3 = new ResourceGroupId(Arrays.asList("global", "pipeline", "ns", "sub_rg_3"));
    private static final ResourceGroupState FAKE_RESOURCE_GROUP_STATE = ResourceGroupState.CAN_QUEUE;
    private static final SchedulingPolicy FAKE_SCHEDULING_POLICY = SchedulingPolicy.FAIR;
    private static final int FAKE_SCHEDULING_WEIGHT = 100;
    private static final long FAKE_SOFT_MEMORY_LIMIT_BYTES = Long.MAX_VALUE;
    private static final int FAKE_SOFT_CONCURRENCY_LIMIT = 10;
    private static final int FAKE_HARD_CONCURRENCY_LIMIT = 20;
    private static final int FAKE_MAX_QUEUED_QUERIES = 50;
    private static final long FAKE_CACHED_MEMORY_USAGE_BYTES = 20480L;
    private static final int FAKE_QUEUED_QUERIES = 10;
    private static final int FAKE_RUNNING_QUERIES = 2;
    private static final int FAKE_ELIGIBLE_SUB_GROUPS = 3;
    private static final QueryId FAKE_QUERY_ID_1 = new QueryId("20220202_215711_00938_kvz6g");
    private static final QueryId FAKE_QUERY_ID_2 = new QueryId("20220202_215711_00938_ks4fq");
    private static final ResourceGroupId FAKE_QUERY_RESOURCE_GROUP_ID = new ResourceGroupId(Arrays.asList("global", "pipeline", "ns", "sub_rg", "dummy_prefix", "dummy_query_task_id"));
    private static final QueryState FAKE_QUERY_STATE = QueryState.DISPATCHING;
    private static final String FAKE_QUERY = "SELECT something FROM somewhere";
    private static final DateTime FAKE_CREATE_TIME = new DateTime((Object)"2000-01-01T01:00:00Z");
    private static final String FAKE_QUERY_REQUESTER = "DummyUser";
    private static final String FAKE_QUERY_SOURCE = "DummySource";
    private static final String FAKE_QUERY_CLIENT_INFO = "DummyClientInfo";
    private static final String FAKE_QUERY_CATALOG = "DummyCatalog";
    private static final String FAKE_QUERY_SCHEMA = "DummySchema";
    private static final boolean FAKE_QUERY_TRUNCATED = true;
    private static final boolean FAKE_AUTHENTICATED = true;
    private static final List<String> FAKE_WARNING_CODES = ImmutableList.of((Object)"WARNING1");
    private static final ErrorCode FAKE_ERROR_CODE = new ErrorCode(1234, "DUMMY_ERROR", ErrorType.EXTERNAL, false);
    private static final long FAKE_ELAPSED_TIME_MILLIS = 10000L;
    private static final long FAKE_QUEUED_TIME_MILLIS = 1000L;
    private static final long FAKE_CPU_TIME_MILLS = 1L;
    private static final long FAKE_SCHEDULED_TIME_MILLIS = 50L;
    private static final long FAKE_CURRENT_MEMORY_BYTES = 10240L;
    private static final long FAKE_PEAK_MEMORY_BYTES = 20480L;
    private static final long FAKE_PEAK_TOTAL_MEMORY_BYTES = 40960L;
    private static final long FAKE_PEAK_TASK_TOTAL_MEMORY_BYTES = 20480L;
    private static final long FAKE_INPUT_ROWS = 5L;
    private static final long FAKE_INPUT_BYTES = 1024L;
    private static final boolean FAKE_BLOCKED = true;
    private static final OptionalDouble FAKE_PROGRESS_PERCENTAGE_1 = OptionalDouble.of(65.23124);
    private static final OptionalDouble FAKE_PROGRESS_PERCENTAGE_2 = OptionalDouble.of(98.235);
    private static final long FAKE_EXECUTION_TIME_MILLIS = 124354L;
    private static final double FAKE_CUMULATIVE_USER_MEMORY = 1234.567;
    private static final double FAKE_CUMULATIVE_TOTAL_MEMORY = 2345.6789;
    private static final Set<BlockedReason> FAKE_BLOCKED_REASONS = ImmutableSet.of((Object)BlockedReason.WAITING_FOR_MEMORY);
    private static final int FAKE_QUEUED_DRIVERS = 123;
    private static final int FAKE_RUNNING_DRIVERS = 234;
    private static final int FAKE_COMPLETED_DRIVERS = 133435;
    private ResourceGroupInfo resourceGroupInfo;
    private List<QueryStateInfo> queryStateInfoList;
    private List<QueryProgressStats> queryProgressStats;

    @BeforeMethod
    public void setUp() {
        this.setUpQueryProgressStats();
        this.setUpQueryStateInfoList();
        ArrayList<ResourceGroupInfo> subGroups = new ArrayList<ResourceGroupInfo>();
        ResourceGroupInfo subResourceGroupInfo1 = this.getResourceGroupInfo(FAKE_SUB_RESOURCE_GROUP_ID_1, null, null);
        ResourceGroupInfo subResourceGroupInfo2 = this.getResourceGroupInfo(FAKE_SUB_RESOURCE_GROUP_ID_2, null, null);
        ResourceGroupInfo subResourceGroupInfo3 = this.getResourceGroupInfo(FAKE_SUB_RESOURCE_GROUP_ID_3, null, null);
        subGroups.add(subResourceGroupInfo1);
        subGroups.add(subResourceGroupInfo2);
        subGroups.add(subResourceGroupInfo3);
        this.resourceGroupInfo = this.getResourceGroupInfo(FAKE_RESOURCE_GROUP_ID_PARENT, subGroups, this.queryStateInfoList);
    }

    @DataProvider
    public Object[][] codecCombinations() {
        return new Object[][]{{COMPILER_READ_CODEC, COMPILER_WRITE_CODEC}, {COMPILER_READ_CODEC, REFLECTION_WRITE_CODEC}, {REFLECTION_READ_CODEC, COMPILER_WRITE_CODEC}, {REFLECTION_READ_CODEC, REFLECTION_WRITE_CODEC}};
    }

    @Test(dataProvider="codecCombinations")
    public void testRoundTripSerializeBinaryProtocol(ThriftCodec<ResourceGroupInfo> readCodec, ThriftCodec<ResourceGroupInfo> writeCodec) throws Exception {
        ResourceGroupInfo groupInfo = this.getRoundTripSerialize(readCodec, writeCodec, TBinaryProtocol::new);
        this.assertSerde(groupInfo);
    }

    @Test(dataProvider="codecCombinations")
    public void testRoundTripSerializeTCompactProtocol(ThriftCodec<ResourceGroupInfo> readCodec, ThriftCodec<ResourceGroupInfo> writeCodec) throws Exception {
        ResourceGroupInfo groupInfo = this.getRoundTripSerialize(readCodec, writeCodec, TCompactProtocol::new);
        this.assertSerde(groupInfo);
    }

    @Test(dataProvider="codecCombinations")
    public void testRoundTripSerializeTFacebookCompactProtocol(ThriftCodec<ResourceGroupInfo> readCodec, ThriftCodec<ResourceGroupInfo> writeCodec) throws Exception {
        ResourceGroupInfo groupInfo = this.getRoundTripSerialize(readCodec, writeCodec, TFacebookCompactProtocol::new);
        this.assertSerde(groupInfo);
    }

    private void assertSerde(ResourceGroupInfo actualInfo) {
        Assert.assertEquals((Object)actualInfo.getId(), (Object)FAKE_RESOURCE_GROUP_ID_PARENT);
        this.assertSerdeRGInfoCommonProperties(actualInfo);
        List actualSubGroupList = actualInfo.getSubGroups();
        Assert.assertNotNull((Object)actualSubGroupList);
        Assert.assertEquals((int)actualSubGroupList.size(), (int)3);
        Assert.assertEquals((Object)((ResourceGroupInfo)actualSubGroupList.get(0)).getId(), (Object)FAKE_SUB_RESOURCE_GROUP_ID_1);
        this.assertSerdeRGInfoCommonProperties((ResourceGroupInfo)actualSubGroupList.get(0));
        Assert.assertEquals((Object)((ResourceGroupInfo)actualSubGroupList.get(1)).getId(), (Object)FAKE_SUB_RESOURCE_GROUP_ID_2);
        this.assertSerdeRGInfoCommonProperties((ResourceGroupInfo)actualSubGroupList.get(1));
        Assert.assertEquals((Object)((ResourceGroupInfo)actualSubGroupList.get(2)).getId(), (Object)FAKE_SUB_RESOURCE_GROUP_ID_3);
        this.assertSerdeRGInfoCommonProperties((ResourceGroupInfo)actualSubGroupList.get(2));
        List actualQueryStateInfoList = actualInfo.getRunningQueries();
        Assert.assertNotNull((Object)actualQueryStateInfoList);
        Assert.assertEquals((int)actualQueryStateInfoList.size(), (int)2);
        Assert.assertEquals((Object)((QueryStateInfo)actualQueryStateInfoList.get(0)).getQueryId(), (Object)FAKE_QUERY_ID_1);
        this.assertSerdeQueryState((QueryStateInfo)actualQueryStateInfoList.get(0), FAKE_PROGRESS_PERCENTAGE_1);
        Assert.assertEquals((Object)((QueryStateInfo)actualQueryStateInfoList.get(1)).getQueryId(), (Object)FAKE_QUERY_ID_2);
        this.assertSerdeQueryState((QueryStateInfo)actualQueryStateInfoList.get(1), FAKE_PROGRESS_PERCENTAGE_2);
    }

    private void assertSerdeQueryState(QueryStateInfo actualInfo, OptionalDouble expectedProgress) {
        Assert.assertEquals((Object)actualInfo.getQueryState(), (Object)FAKE_QUERY_STATE);
        Assert.assertTrue((boolean)actualInfo.getResourceGroupId().isPresent());
        Assert.assertEquals(actualInfo.getResourceGroupId().get(), (Object)FAKE_QUERY_RESOURCE_GROUP_ID);
        Assert.assertEquals((String)actualInfo.getQuery(), (String)FAKE_QUERY);
        Assert.assertEquals((Object)actualInfo.getCreateTime(), (Object)FAKE_CREATE_TIME);
        Assert.assertEquals((String)actualInfo.getUser(), (String)FAKE_QUERY_REQUESTER);
        Assert.assertTrue((boolean)actualInfo.getSource().isPresent());
        Assert.assertEquals((String)((String)actualInfo.getSource().get()), (String)FAKE_QUERY_SOURCE);
        Assert.assertTrue((boolean)actualInfo.getClientInfo().isPresent());
        Assert.assertEquals((String)((String)actualInfo.getClientInfo().get()), (String)FAKE_QUERY_CLIENT_INFO);
        Assert.assertTrue((boolean)actualInfo.getCatalog().isPresent());
        Assert.assertEquals((String)((String)actualInfo.getCatalog().get()), (String)FAKE_QUERY_CATALOG);
        Assert.assertTrue((boolean)actualInfo.getSchema().isPresent());
        Assert.assertEquals((String)((String)actualInfo.getSchema().get()), (String)FAKE_QUERY_SCHEMA);
        Assert.assertTrue((boolean)actualInfo.getPathToRoot().isPresent());
        Assert.assertEquals((int)((List)actualInfo.getPathToRoot().get()).size(), (int)0);
        Assert.assertTrue((boolean)actualInfo.getProgress().isPresent());
        QueryProgressStats queryProgressStats = (QueryProgressStats)actualInfo.getProgress().get();
        Assert.assertEquals((long)queryProgressStats.getElapsedTimeMillis(), (long)10000L);
        Assert.assertEquals((long)queryProgressStats.getQueuedTimeMillis(), (long)1000L);
        Assert.assertEquals((long)queryProgressStats.getCpuTimeMillis(), (long)1L);
        Assert.assertEquals((long)queryProgressStats.getScheduledTimeMillis(), (long)50L);
        Assert.assertEquals((long)queryProgressStats.getCurrentMemoryBytes(), (long)10240L);
        Assert.assertEquals((long)queryProgressStats.getPeakMemoryBytes(), (long)20480L);
        Assert.assertEquals((long)queryProgressStats.getPeakTotalMemoryBytes(), (long)40960L);
        Assert.assertEquals((long)queryProgressStats.getPeakTaskTotalMemoryBytes(), (long)20480L);
        Assert.assertEquals((long)queryProgressStats.getInputRows(), (long)5L);
        Assert.assertEquals((long)queryProgressStats.getInputBytes(), (long)1024L);
        Assert.assertEquals((Object)queryProgressStats.getProgressPercentage(), (Object)expectedProgress);
    }

    private void assertSerdeRGInfoCommonProperties(ResourceGroupInfo actualInfo) {
        Assert.assertEquals((Object)actualInfo.getState(), (Object)FAKE_RESOURCE_GROUP_STATE);
        Assert.assertEquals((Object)actualInfo.getSchedulingPolicy(), (Object)FAKE_SCHEDULING_POLICY);
        Assert.assertEquals((int)actualInfo.getSchedulingWeight(), (int)100);
        Assert.assertEquals((long)actualInfo.getSoftMemoryLimit().toBytes(), (long)Long.MAX_VALUE);
        Assert.assertEquals((int)actualInfo.getSoftConcurrencyLimit(), (int)10);
        Assert.assertEquals((int)actualInfo.getHardConcurrencyLimit(), (int)20);
        Assert.assertEquals((int)actualInfo.getMaxQueuedQueries(), (int)50);
        Assert.assertEquals((long)actualInfo.getMemoryUsage().toBytes(), (long)20480L);
        Assert.assertEquals((int)actualInfo.getNumQueuedQueries(), (int)10);
        Assert.assertEquals((int)actualInfo.getNumRunningQueries(), (int)2);
        Assert.assertEquals((int)actualInfo.getNumEligibleSubGroups(), (int)3);
    }

    private ResourceGroupInfo getRoundTripSerialize(ThriftCodec<ResourceGroupInfo> readCodec, ThriftCodec<ResourceGroupInfo> writeCodec, Function<TTransport, TProtocol> protocolFactory) throws Exception {
        TProtocol protocol = protocolFactory.apply((TTransport)transport);
        writeCodec.write((Object)this.resourceGroupInfo, (TProtocolWriter)protocol);
        return (ResourceGroupInfo)readCodec.read((TProtocolReader)protocol);
    }

    private void setUpQueryStateInfoList() {
        this.queryStateInfoList = new ArrayList<QueryStateInfo>();
        this.queryStateInfoList.add(new QueryStateInfo(FAKE_QUERY_ID_1, FAKE_QUERY_STATE, Optional.of(FAKE_QUERY_RESOURCE_GROUP_ID), FAKE_QUERY, true, FAKE_CREATE_TIME.getMillis(), FAKE_QUERY_REQUESTER, true, Optional.of(FAKE_QUERY_SOURCE), Optional.of(FAKE_QUERY_CLIENT_INFO), Optional.of(FAKE_QUERY_CATALOG), Optional.of(FAKE_QUERY_SCHEMA), Optional.of(new ArrayList()), Optional.of(this.queryProgressStats.get(0)), FAKE_WARNING_CODES, Optional.of(FAKE_ERROR_CODE)));
        this.queryStateInfoList.add(new QueryStateInfo(FAKE_QUERY_ID_2, FAKE_QUERY_STATE, Optional.of(FAKE_QUERY_RESOURCE_GROUP_ID), FAKE_QUERY, true, FAKE_CREATE_TIME.getMillis(), FAKE_QUERY_REQUESTER, true, Optional.of(FAKE_QUERY_SOURCE), Optional.of(FAKE_QUERY_CLIENT_INFO), Optional.of(FAKE_QUERY_CATALOG), Optional.of(FAKE_QUERY_SCHEMA), Optional.of(new ArrayList()), Optional.of(this.queryProgressStats.get(1)), (List)ImmutableList.of(), Optional.empty()));
    }

    private void setUpQueryProgressStats() {
        this.queryProgressStats = new ArrayList<QueryProgressStats>();
        this.queryProgressStats.add(new QueryProgressStats(10000L, 1000L, 124354L, 1L, 50L, 10240L, 20480L, 40960L, 20480L, 1234.567, 2345.6789, 5L, 1024L, true, Optional.of(FAKE_BLOCKED_REASONS), FAKE_PROGRESS_PERCENTAGE_1, 123, 234, 133435));
        this.queryProgressStats.add(new QueryProgressStats(10000L, 1000L, 124354L, 1L, 50L, 10240L, 20480L, 40960L, 20480L, 1234.567, 2345.6789, 5L, 1024L, true, Optional.empty(), FAKE_PROGRESS_PERCENTAGE_2, 123, 234, 133435));
    }

    private ResourceGroupInfo getResourceGroupInfo(ResourceGroupId rgID, List<ResourceGroupInfo> subGroups, List<QueryStateInfo> runningQueries) {
        return new ResourceGroupInfo(rgID, FAKE_RESOURCE_GROUP_STATE, FAKE_SCHEDULING_POLICY, 100, DataSize.succinctBytes((long)Long.MAX_VALUE), 10, 20, 50, DataSize.succinctBytes((long)20480L), 10, 2, 3, subGroups, runningQueries, 0);
    }
}

